/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class DocumentSpan
implements JsonSerializable<DocumentSpan> {
    private final int offset;
    private final int length;

    public DocumentSpan(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        return jsonWriter.writeEndObject();
    }

    public static DocumentSpan fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentSpan)jsonReader.readObject(reader -> {
            boolean offsetFound = false;
            int offset = 0;
            boolean lengthFound = false;
            int length = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("offset".equals(fieldName)) {
                    offset = reader.getInt();
                    offsetFound = true;
                    continue;
                }
                if ("length".equals(fieldName)) {
                    length = reader.getInt();
                    lengthFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (offsetFound && lengthFound) {
                return new DocumentSpan(offset, length);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!offsetFound) {
                missingProperties.add("offset");
            }
            if (!lengthFound) {
                missingProperties.add("length");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

