/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BoundingRegion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentTableCellKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentTableCell
implements JsonSerializable<DocumentTableCell> {
    private DocumentTableCellKind kind;
    private final int rowIndex;
    private final int columnIndex;
    private Integer rowSpan;
    private Integer columnSpan;
    private final String content;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;

    public DocumentTableCell(int rowIndex, int columnIndex, String content, List<DocumentSpan> spans) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.content = content;
        this.spans = spans;
    }

    public DocumentTableCellKind getKind() {
        return this.kind;
    }

    public DocumentTableCell setKind(DocumentTableCellKind kind) {
        this.kind = kind;
        return this;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Integer getRowSpan() {
        return this.rowSpan;
    }

    public DocumentTableCell setRowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    public DocumentTableCell setColumnSpan(Integer columnSpan) {
        this.columnSpan = columnSpan;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public DocumentTableCell setBoundingRegions(List<BoundingRegion> boundingRegions) {
        this.boundingRegions = boundingRegions;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowIndex", this.rowIndex);
        jsonWriter.writeIntField("columnIndex", this.columnIndex);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("rowSpan", (Number)this.rowSpan);
        jsonWriter.writeNumberField("columnSpan", (Number)this.columnSpan);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentTableCell fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentTableCell)jsonReader.readObject(reader -> {
            boolean rowIndexFound = false;
            int rowIndex = 0;
            boolean columnIndexFound = false;
            int columnIndex = 0;
            boolean contentFound = false;
            String content = null;
            boolean spansFound = false;
            List spans = null;
            DocumentTableCellKind kind = null;
            Integer rowSpan = null;
            Integer columnSpan = null;
            List boundingRegions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rowIndex".equals(fieldName)) {
                    rowIndex = reader.getInt();
                    rowIndexFound = true;
                    continue;
                }
                if ("columnIndex".equals(fieldName)) {
                    columnIndex = reader.getInt();
                    columnIndexFound = true;
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    contentFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = DocumentTableCellKind.fromString(reader.getString());
                    continue;
                }
                if ("rowSpan".equals(fieldName)) {
                    rowSpan = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("columnSpan".equals(fieldName)) {
                    columnSpan = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (rowIndexFound && columnIndexFound && contentFound && spansFound) {
                DocumentTableCell deserializedDocumentTableCell = new DocumentTableCell(rowIndex, columnIndex, content, spans);
                deserializedDocumentTableCell.kind = kind;
                deserializedDocumentTableCell.rowSpan = rowSpan;
                deserializedDocumentTableCell.columnSpan = columnSpan;
                deserializedDocumentTableCell.boundingRegions = boundingRegions;
                return deserializedDocumentTableCell;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!rowIndexFound) {
                missingProperties.add("rowIndex");
            }
            if (!columnIndexFound) {
                missingProperties.add("columnIndex");
            }
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

