/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CustomDocumentModelsDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.QuotaDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ResourceDetails
implements JsonSerializable<ResourceDetails> {
    private final CustomDocumentModelsDetails customDocumentModels;
    private final QuotaDetails customNeuralDocumentModelBuilds;

    public ResourceDetails(CustomDocumentModelsDetails customDocumentModels, QuotaDetails customNeuralDocumentModelBuilds) {
        this.customDocumentModels = customDocumentModels;
        this.customNeuralDocumentModelBuilds = customNeuralDocumentModelBuilds;
    }

    public CustomDocumentModelsDetails getCustomDocumentModels() {
        return this.customDocumentModels;
    }

    public QuotaDetails getCustomNeuralDocumentModelBuilds() {
        return this.customNeuralDocumentModelBuilds;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("customDocumentModels", (JsonSerializable)this.customDocumentModels);
        jsonWriter.writeJsonField("customNeuralDocumentModelBuilds", (JsonSerializable)this.customNeuralDocumentModelBuilds);
        return jsonWriter.writeEndObject();
    }

    public static ResourceDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceDetails)jsonReader.readObject(reader -> {
            boolean customDocumentModelsFound = false;
            CustomDocumentModelsDetails customDocumentModels = null;
            boolean customNeuralDocumentModelBuildsFound = false;
            QuotaDetails customNeuralDocumentModelBuilds = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customDocumentModels".equals(fieldName)) {
                    customDocumentModels = CustomDocumentModelsDetails.fromJson(reader);
                    customDocumentModelsFound = true;
                    continue;
                }
                if ("customNeuralDocumentModelBuilds".equals(fieldName)) {
                    customNeuralDocumentModelBuilds = QuotaDetails.fromJson(reader);
                    customNeuralDocumentModelBuildsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (customDocumentModelsFound && customNeuralDocumentModelBuildsFound) {
                return new ResourceDetails(customDocumentModels, customNeuralDocumentModelBuilds);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!customDocumentModelsFound) {
                missingProperties.add("customDocumentModels");
            }
            if (!customNeuralDocumentModelBuildsFound) {
                missingProperties.add("customNeuralDocumentModelBuilds");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

