/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.DocumentResult;
import com.azure.ai.formrecognizer.implementation.models.ErrorInformation;
import com.azure.ai.formrecognizer.implementation.models.PageResult;
import com.azure.ai.formrecognizer.implementation.models.ReadResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AnalyzeResult
implements JsonSerializable<AnalyzeResult> {
    private String version;
    private List<ReadResult> readResults;
    private List<PageResult> pageResults;
    private List<DocumentResult> documentResults;
    private List<ErrorInformation> errors;

    public String getVersion() {
        return this.version;
    }

    public AnalyzeResult setVersion(String version) {
        this.version = version;
        return this;
    }

    public List<ReadResult> getReadResults() {
        return this.readResults;
    }

    public AnalyzeResult setReadResults(List<ReadResult> readResults) {
        this.readResults = readResults;
        return this;
    }

    public List<PageResult> getPageResults() {
        return this.pageResults;
    }

    public AnalyzeResult setPageResults(List<PageResult> pageResults) {
        this.pageResults = pageResults;
        return this;
    }

    public List<DocumentResult> getDocumentResults() {
        return this.documentResults;
    }

    public AnalyzeResult setDocumentResults(List<DocumentResult> documentResults) {
        this.documentResults = documentResults;
        return this;
    }

    public List<ErrorInformation> getErrors() {
        return this.errors;
    }

    public AnalyzeResult setErrors(List<ErrorInformation> errors) {
        this.errors = errors;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeArrayField("readResults", this.readResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("pageResults", this.pageResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("documentResults", this.documentResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeResult)jsonReader.readObject(reader -> {
            AnalyzeResult deserializedAnalyzeResult = new AnalyzeResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAnalyzeResult.version = reader.getString();
                    continue;
                }
                if ("readResults".equals(fieldName)) {
                    List readResults;
                    deserializedAnalyzeResult.readResults = readResults = reader.readArray(reader1 -> ReadResult.fromJson(reader1));
                    continue;
                }
                if ("pageResults".equals(fieldName)) {
                    List pageResults;
                    deserializedAnalyzeResult.pageResults = pageResults = reader.readArray(reader1 -> PageResult.fromJson(reader1));
                    continue;
                }
                if ("documentResults".equals(fieldName)) {
                    List documentResults;
                    deserializedAnalyzeResult.documentResults = documentResults = reader.readArray(reader1 -> DocumentResult.fromJson(reader1));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedAnalyzeResult.errors = errors = reader.readArray(reader1 -> ErrorInformation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeResult;
        });
    }
}

