/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.DataTableCell;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DataTable
implements JsonSerializable<DataTable> {
    private int rows;
    private int columns;
    private List<DataTableCell> cells;
    private List<Float> boundingBox;

    public int getRows() {
        return this.rows;
    }

    public DataTable setRows(int rows) {
        this.rows = rows;
        return this;
    }

    public int getColumns() {
        return this.columns;
    }

    public DataTable setColumns(int columns) {
        this.columns = columns;
        return this;
    }

    public List<DataTableCell> getCells() {
        return this.cells;
    }

    public DataTable setCells(List<DataTableCell> cells) {
        this.cells = cells;
        return this;
    }

    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    public DataTable setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rows", this.rows);
        jsonWriter.writeIntField("columns", this.columns);
        jsonWriter.writeArrayField("cells", this.cells, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element.floatValue()));
        return jsonWriter.writeEndObject();
    }

    public static DataTable fromJson(JsonReader jsonReader) throws IOException {
        return (DataTable)jsonReader.readObject(reader -> {
            DataTable deserializedDataTable = new DataTable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rows".equals(fieldName)) {
                    deserializedDataTable.rows = reader.getInt();
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    deserializedDataTable.columns = reader.getInt();
                    continue;
                }
                if ("cells".equals(fieldName)) {
                    List cells;
                    deserializedDataTable.cells = cells = reader.readArray(reader1 -> DataTableCell.fromJson(reader1));
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    List boundingBox;
                    deserializedDataTable.boundingBox = boundingBox = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataTable;
        });
    }
}

