/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DataTableCell
implements JsonSerializable<DataTableCell> {
    private int rowIndex;
    private int columnIndex;
    private Integer rowSpan;
    private Integer columnSpan;
    private String text;
    private List<Float> boundingBox;
    private float confidence;
    private List<String> elements;
    private Boolean isHeader;
    private Boolean isFooter;

    public int getRowIndex() {
        return this.rowIndex;
    }

    public DataTableCell setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public DataTableCell setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }

    public Integer getRowSpan() {
        return this.rowSpan;
    }

    public DataTableCell setRowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    public DataTableCell setColumnSpan(Integer columnSpan) {
        this.columnSpan = columnSpan;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public DataTableCell setText(String text) {
        this.text = text;
        return this;
    }

    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    public DataTableCell setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public DataTableCell setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public DataTableCell setElements(List<String> elements) {
        this.elements = elements;
        return this;
    }

    public Boolean isHeader() {
        return this.isHeader;
    }

    public DataTableCell setIsHeader(Boolean isHeader) {
        this.isHeader = isHeader;
        return this;
    }

    public Boolean isFooter() {
        return this.isFooter;
    }

    public DataTableCell setIsFooter(Boolean isFooter) {
        this.isFooter = isFooter;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowIndex", this.rowIndex);
        jsonWriter.writeIntField("columnIndex", this.columnIndex);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element.floatValue()));
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeNumberField("rowSpan", (Number)this.rowSpan);
        jsonWriter.writeNumberField("columnSpan", (Number)this.columnSpan);
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isHeader", this.isHeader);
        jsonWriter.writeBooleanField("isFooter", this.isFooter);
        return jsonWriter.writeEndObject();
    }

    public static DataTableCell fromJson(JsonReader jsonReader) throws IOException {
        return (DataTableCell)jsonReader.readObject(reader -> {
            DataTableCell deserializedDataTableCell = new DataTableCell();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rowIndex".equals(fieldName)) {
                    deserializedDataTableCell.rowIndex = reader.getInt();
                    continue;
                }
                if ("columnIndex".equals(fieldName)) {
                    deserializedDataTableCell.columnIndex = reader.getInt();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    deserializedDataTableCell.text = reader.getString();
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    List boundingBox;
                    deserializedDataTableCell.boundingBox = boundingBox = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    deserializedDataTableCell.confidence = reader.getFloat();
                    continue;
                }
                if ("rowSpan".equals(fieldName)) {
                    deserializedDataTableCell.rowSpan = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("columnSpan".equals(fieldName)) {
                    deserializedDataTableCell.columnSpan = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    List elements;
                    deserializedDataTableCell.elements = elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isHeader".equals(fieldName)) {
                    deserializedDataTableCell.isHeader = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isFooter".equals(fieldName)) {
                    deserializedDataTableCell.isFooter = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataTableCell;
        });
    }
}

