/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.FieldValue;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class DocumentResult
implements JsonSerializable<DocumentResult> {
    private String docType;
    private UUID modelId;
    private List<Integer> pageRange;
    private Float docTypeConfidence;
    private Map<String, FieldValue> fields;

    public String getDocType() {
        return this.docType;
    }

    public DocumentResult setDocType(String docType) {
        this.docType = docType;
        return this;
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public DocumentResult setModelId(UUID modelId) {
        this.modelId = modelId;
        return this;
    }

    public List<Integer> getPageRange() {
        return this.pageRange;
    }

    public DocumentResult setPageRange(List<Integer> pageRange) {
        this.pageRange = pageRange;
        return this;
    }

    public Float getDocTypeConfidence() {
        return this.docTypeConfidence;
    }

    public DocumentResult setDocTypeConfidence(Float docTypeConfidence) {
        this.docTypeConfidence = docTypeConfidence;
        return this;
    }

    public Map<String, FieldValue> getFields() {
        return this.fields;
    }

    public DocumentResult setFields(Map<String, FieldValue> fields) {
        this.fields = fields;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("docType", this.docType);
        jsonWriter.writeArrayField("pageRange", this.pageRange, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeMapField("fields", this.fields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("modelId", Objects.toString(this.modelId, null));
        jsonWriter.writeNumberField("docTypeConfidence", (Number)this.docTypeConfidence);
        return jsonWriter.writeEndObject();
    }

    public static DocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentResult)jsonReader.readObject(reader -> {
            DocumentResult deserializedDocumentResult = new DocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("docType".equals(fieldName)) {
                    deserializedDocumentResult.docType = reader.getString();
                    continue;
                }
                if ("pageRange".equals(fieldName)) {
                    List pageRange;
                    deserializedDocumentResult.pageRange = pageRange = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    Map fields;
                    deserializedDocumentResult.fields = fields = reader.readMap(reader1 -> FieldValue.fromJson(reader1));
                    continue;
                }
                if ("modelId".equals(fieldName)) {
                    deserializedDocumentResult.modelId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("docTypeConfidence".equals(fieldName)) {
                    deserializedDocumentResult.docTypeConfidence = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentResult;
        });
    }
}

