/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.KeyValueType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class KeyValueElement
implements JsonSerializable<KeyValueElement> {
    private KeyValueType type;
    private String text;
    private List<Float> boundingBox;
    private List<String> elements;

    public KeyValueType getType() {
        return this.type;
    }

    public KeyValueElement setType(KeyValueType type) {
        this.type = type;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public KeyValueElement setText(String text) {
        this.text = text;
        return this;
    }

    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    public KeyValueElement setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public KeyValueElement setElements(List<String> elements) {
        this.elements = elements;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element.floatValue()));
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static KeyValueElement fromJson(JsonReader jsonReader) throws IOException {
        return (KeyValueElement)jsonReader.readObject(reader -> {
            KeyValueElement deserializedKeyValueElement = new KeyValueElement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedKeyValueElement.text = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKeyValueElement.type = KeyValueType.fromString(reader.getString());
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    List boundingBox;
                    deserializedKeyValueElement.boundingBox = boundingBox = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    List elements;
                    deserializedKeyValueElement.elements = elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyValueElement;
        });
    }
}

