/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.DataTable;
import com.azure.ai.formrecognizer.implementation.models.KeyValuePair;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class PageResult
implements JsonSerializable<PageResult> {
    private int page;
    private Integer clusterId;
    private List<KeyValuePair> keyValuePairs;
    private List<DataTable> tables;

    public int getPage() {
        return this.page;
    }

    public PageResult setPage(int page) {
        this.page = page;
        return this;
    }

    public Integer getClusterId() {
        return this.clusterId;
    }

    public PageResult setClusterId(Integer clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public List<KeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public PageResult setKeyValuePairs(List<KeyValuePair> keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
        return this;
    }

    public List<DataTable> getTables() {
        return this.tables;
    }

    public PageResult setTables(List<DataTable> tables) {
        this.tables = tables;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("page", this.page);
        jsonWriter.writeNumberField("clusterId", (Number)this.clusterId);
        jsonWriter.writeArrayField("keyValuePairs", this.keyValuePairs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PageResult fromJson(JsonReader jsonReader) throws IOException {
        return (PageResult)jsonReader.readObject(reader -> {
            PageResult deserializedPageResult = new PageResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("page".equals(fieldName)) {
                    deserializedPageResult.page = reader.getInt();
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedPageResult.clusterId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("keyValuePairs".equals(fieldName)) {
                    List keyValuePairs;
                    deserializedPageResult.keyValuePairs = keyValuePairs = reader.readArray(reader1 -> KeyValuePair.fromJson(reader1));
                    continue;
                }
                if ("tables".equals(fieldName)) {
                    List tables;
                    deserializedPageResult.tables = tables = reader.readArray(reader1 -> DataTable.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPageResult;
        });
    }
}

