/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.SelectionMark;
import com.azure.ai.formrecognizer.implementation.models.TextLine;
import com.azure.ai.formrecognizer.models.LengthUnit;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ReadResult
implements JsonSerializable<ReadResult> {
    private int page;
    private float angle;
    private float width;
    private float height;
    private LengthUnit unit;
    private List<TextLine> lines;
    private List<SelectionMark> selectionMarks;

    public int getPage() {
        return this.page;
    }

    public ReadResult setPage(int page) {
        this.page = page;
        return this;
    }

    public float getAngle() {
        return this.angle;
    }

    public ReadResult setAngle(float angle) {
        this.angle = angle;
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public ReadResult setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public ReadResult setHeight(float height) {
        this.height = height;
        return this;
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public ReadResult setUnit(LengthUnit unit) {
        this.unit = unit;
        return this;
    }

    public List<TextLine> getLines() {
        return this.lines;
    }

    public ReadResult setLines(List<TextLine> lines) {
        this.lines = lines;
        return this;
    }

    public List<SelectionMark> getSelectionMarks() {
        return this.selectionMarks;
    }

    public ReadResult setSelectionMarks(List<SelectionMark> selectionMarks) {
        this.selectionMarks = selectionMarks;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("page", this.page);
        jsonWriter.writeFloatField("angle", this.angle);
        jsonWriter.writeFloatField("width", this.width);
        jsonWriter.writeFloatField("height", this.height);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("lines", this.lines, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("selectionMarks", this.selectionMarks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ReadResult fromJson(JsonReader jsonReader) throws IOException {
        return (ReadResult)jsonReader.readObject(reader -> {
            ReadResult deserializedReadResult = new ReadResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("page".equals(fieldName)) {
                    deserializedReadResult.page = reader.getInt();
                    continue;
                }
                if ("angle".equals(fieldName)) {
                    deserializedReadResult.angle = reader.getFloat();
                    continue;
                }
                if ("width".equals(fieldName)) {
                    deserializedReadResult.width = reader.getFloat();
                    continue;
                }
                if ("height".equals(fieldName)) {
                    deserializedReadResult.height = reader.getFloat();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedReadResult.unit = LengthUnit.fromString(reader.getString());
                    continue;
                }
                if ("lines".equals(fieldName)) {
                    List lines;
                    deserializedReadResult.lines = lines = reader.readArray(reader1 -> TextLine.fromJson(reader1));
                    continue;
                }
                if ("selectionMarks".equals(fieldName)) {
                    List selectionMarks;
                    deserializedReadResult.selectionMarks = selectionMarks = reader.readArray(reader1 -> SelectionMark.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReadResult;
        });
    }
}

