/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.models.TextStyleName;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Style
implements JsonSerializable<Style> {
    private TextStyleName name;
    private float confidence;

    public TextStyleName getName() {
        return this.name;
    }

    public Style setName(TextStyleName name) {
        this.name = name;
        return this;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public Style setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeFloatField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static Style fromJson(JsonReader jsonReader) throws IOException {
        return (Style)jsonReader.readObject(reader -> {
            Style deserializedStyle = new Style();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStyle.name = TextStyleName.fromString(reader.getString());
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    deserializedStyle.confidence = reader.getFloat();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStyle;
        });
    }
}

