/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.Appearance;
import com.azure.ai.formrecognizer.implementation.models.TextWord;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TextLine
implements JsonSerializable<TextLine> {
    private String text;
    private List<Float> boundingBox;
    private List<TextWord> words;
    private Appearance appearance;

    public String getText() {
        return this.text;
    }

    public TextLine setText(String text) {
        this.text = text;
        return this;
    }

    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    public TextLine setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public List<TextWord> getWords() {
        return this.words;
    }

    public TextLine setWords(List<TextWord> words) {
        this.words = words;
        return this;
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public TextLine setAppearance(Appearance appearance) {
        this.appearance = appearance;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element.floatValue()));
        jsonWriter.writeArrayField("words", this.words, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("appearance", (JsonSerializable)this.appearance);
        return jsonWriter.writeEndObject();
    }

    public static TextLine fromJson(JsonReader jsonReader) throws IOException {
        return (TextLine)jsonReader.readObject(reader -> {
            TextLine deserializedTextLine = new TextLine();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedTextLine.text = reader.getString();
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    List boundingBox;
                    deserializedTextLine.boundingBox = boundingBox = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                if ("words".equals(fieldName)) {
                    List words;
                    deserializedTextLine.words = words = reader.readArray(reader1 -> TextWord.fromJson(reader1));
                    continue;
                }
                if ("appearance".equals(fieldName)) {
                    deserializedTextLine.appearance = Appearance.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTextLine;
        });
    }
}

