/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TextWord
implements JsonSerializable<TextWord> {
    private String text;
    private List<Float> boundingBox;
    private Float confidence;

    public String getText() {
        return this.text;
    }

    public TextWord setText(String text) {
        this.text = text;
        return this;
    }

    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    public TextWord setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public TextWord setConfidence(Float confidence) {
        this.confidence = confidence;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element.floatValue()));
        jsonWriter.writeNumberField("confidence", (Number)this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static TextWord fromJson(JsonReader jsonReader) throws IOException {
        return (TextWord)jsonReader.readObject(reader -> {
            TextWord deserializedTextWord = new TextWord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedTextWord.text = reader.getString();
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    List boundingBox;
                    deserializedTextWord.boundingBox = boundingBox = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    deserializedTextWord.confidence = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTextWord;
        });
    }
}

