/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.ErrorInformation;
import com.azure.ai.formrecognizer.implementation.models.FormFieldsReport;
import com.azure.ai.formrecognizer.implementation.models.TrainingDocumentInfo;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class TrainResult
implements JsonSerializable<TrainResult> {
    private List<TrainingDocumentInfo> trainingDocuments;
    private List<FormFieldsReport> fields;
    private Float averageModelAccuracy;
    private UUID modelId;
    private List<ErrorInformation> errors;

    public List<TrainingDocumentInfo> getTrainingDocuments() {
        return this.trainingDocuments;
    }

    public TrainResult setTrainingDocuments(List<TrainingDocumentInfo> trainingDocuments) {
        this.trainingDocuments = trainingDocuments;
        return this;
    }

    public List<FormFieldsReport> getFields() {
        return this.fields;
    }

    public TrainResult setFields(List<FormFieldsReport> fields) {
        this.fields = fields;
        return this;
    }

    public Float getAverageModelAccuracy() {
        return this.averageModelAccuracy;
    }

    public TrainResult setAverageModelAccuracy(Float averageModelAccuracy) {
        this.averageModelAccuracy = averageModelAccuracy;
        return this;
    }

    public UUID getModelId() {
        return this.modelId;
    }

    public TrainResult setModelId(UUID modelId) {
        this.modelId = modelId;
        return this;
    }

    public List<ErrorInformation> getErrors() {
        return this.errors;
    }

    public TrainResult setErrors(List<ErrorInformation> errors) {
        this.errors = errors;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("trainingDocuments", this.trainingDocuments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("fields", this.fields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("averageModelAccuracy", (Number)this.averageModelAccuracy);
        jsonWriter.writeStringField("modelId", Objects.toString(this.modelId, null));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TrainResult fromJson(JsonReader jsonReader) throws IOException {
        return (TrainResult)jsonReader.readObject(reader -> {
            TrainResult deserializedTrainResult = new TrainResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trainingDocuments".equals(fieldName)) {
                    List trainingDocuments;
                    deserializedTrainResult.trainingDocuments = trainingDocuments = reader.readArray(reader1 -> TrainingDocumentInfo.fromJson(reader1));
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    List fields;
                    deserializedTrainResult.fields = fields = reader.readArray(reader1 -> FormFieldsReport.fromJson(reader1));
                    continue;
                }
                if ("averageModelAccuracy".equals(fieldName)) {
                    deserializedTrainResult.averageModelAccuracy = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("modelId".equals(fieldName)) {
                    deserializedTrainResult.modelId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedTrainResult.errors = errors = reader.readArray(reader1 -> ErrorInformation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrainResult;
        });
    }
}

