/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.ErrorInformation;
import com.azure.ai.formrecognizer.implementation.models.TrainStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TrainingDocumentInfo
implements JsonSerializable<TrainingDocumentInfo> {
    private String documentName;
    private int pages;
    private List<ErrorInformation> errors;
    private TrainStatus status;

    public String getDocumentName() {
        return this.documentName;
    }

    public TrainingDocumentInfo setDocumentName(String documentName) {
        this.documentName = documentName;
        return this;
    }

    public int getPages() {
        return this.pages;
    }

    public TrainingDocumentInfo setPages(int pages) {
        this.pages = pages;
        return this;
    }

    public List<ErrorInformation> getErrors() {
        return this.errors;
    }

    public TrainingDocumentInfo setErrors(List<ErrorInformation> errors) {
        this.errors = errors;
        return this;
    }

    public TrainStatus getStatus() {
        return this.status;
    }

    public TrainingDocumentInfo setStatus(TrainStatus status) {
        this.status = status;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("documentName", this.documentName);
        jsonWriter.writeIntField("pages", this.pages);
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static TrainingDocumentInfo fromJson(JsonReader jsonReader) throws IOException {
        return (TrainingDocumentInfo)jsonReader.readObject(reader -> {
            TrainingDocumentInfo deserializedTrainingDocumentInfo = new TrainingDocumentInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("documentName".equals(fieldName)) {
                    deserializedTrainingDocumentInfo.documentName = reader.getString();
                    continue;
                }
                if ("pages".equals(fieldName)) {
                    deserializedTrainingDocumentInfo.pages = reader.getInt();
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedTrainingDocumentInfo.errors = errors = reader.readArray(reader1 -> ErrorInformation.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTrainingDocumentInfo.status = TrainStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrainingDocumentInfo;
        });
    }
}

