/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training;

import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.implementation.Constants;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.models.FormRecognizerAudience;
import com.azure.ai.formrecognizer.training.FormTrainingAsyncClient;
import com.azure.ai.formrecognizer.training.FormTrainingClient;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={FormTrainingAsyncClient.class, FormTrainingClient.class})
public final class FormTrainingClientBuilder
implements AzureKeyCredentialTrait<FormTrainingClientBuilder>,
ConfigurationTrait<FormTrainingClientBuilder>,
EndpointTrait<FormTrainingClientBuilder>,
HttpTrait<FormTrainingClientBuilder>,
TokenCredentialTrait<FormTrainingClientBuilder> {
    private final ClientLogger logger = new ClientLogger(FormTrainingClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private String endpoint;
    private AzureKeyCredential azureKeyCredential;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private TokenCredential tokenCredential;
    private FormRecognizerServiceVersion version;
    private FormRecognizerAudience audience;

    public FormTrainingClient buildClient() {
        Objects.requireNonNull(this.endpoint, "'Endpoint' is required and can not be null.");
        if (this.audience == null) {
            this.audience = FormRecognizerAudience.AZURE_PUBLIC_CLOUD;
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        FormRecognizerServiceVersion serviceVersion = this.version != null ? this.version : FormRecognizerServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline;
        if (pipeline == null) {
            pipeline = Utility.buildHttpPipeline(this.clientOptions, this.httpLogOptions, buildConfiguration, this.retryPolicy, this.retryOptions, this.azureKeyCredential, this.tokenCredential, this.audience, this.perCallPolicies, this.perRetryPolicies, this.httpClient);
        }
        return new FormTrainingClient(new FormRecognizerClientImpl(pipeline, this.endpoint, serviceVersion.getVersion()), serviceVersion);
    }

    public FormTrainingAsyncClient buildAsyncClient() {
        Objects.requireNonNull(this.endpoint, "'Endpoint' is required and can not be null.");
        if (this.audience == null) {
            this.audience = FormRecognizerAudience.AZURE_PUBLIC_CLOUD;
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        FormRecognizerServiceVersion serviceVersion = this.version != null ? this.version : FormRecognizerServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline;
        if (pipeline == null) {
            pipeline = Utility.buildHttpPipeline(this.clientOptions, this.httpLogOptions, buildConfiguration, this.retryPolicy, this.retryOptions, this.azureKeyCredential, this.tokenCredential, this.audience, this.perCallPolicies, this.perRetryPolicies, this.httpClient);
        }
        return new FormTrainingAsyncClient(new FormRecognizerClientImpl(pipeline, this.endpoint, serviceVersion.getVersion()), serviceVersion);
    }

    public FormTrainingClientBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL.", ex));
        }
        this.endpoint = endpoint.endsWith("/") ? endpoint.substring(0, endpoint.length() - 1) : endpoint;
        return this;
    }

    public FormTrainingClientBuilder credential(AzureKeyCredential azureKeyCredential) {
        this.azureKeyCredential = Objects.requireNonNull(azureKeyCredential, "'azureKeyCredential' cannot be null.");
        return this;
    }

    public FormTrainingClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        return this;
    }

    public FormTrainingClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public static HttpLogOptions getDefaultLogOptions() {
        return Constants.DEFAULT_LOG_OPTIONS_SUPPLIER.get();
    }

    public FormTrainingClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public FormTrainingClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public FormTrainingClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public FormTrainingClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public FormTrainingClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public FormTrainingClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public FormTrainingClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public FormTrainingClientBuilder serviceVersion(FormRecognizerServiceVersion version) {
        this.version = version;
        return this;
    }

    public FormTrainingClientBuilder audience(FormRecognizerAudience audience) {
        Objects.requireNonNull(audience, "'audience' is required and can not be null");
        this.audience = audience;
        return this;
    }
}

