/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class CopyAuthorization {
    private static final ClientLogger LOGGER = new ClientLogger(CopyAuthorization.class);
    private final String modelId;
    private final String accessToken;
    private final String resourceId;
    private final String resourceRegion;
    private final long expirationDateTimeTicks;
    private final OffsetDateTime expiresOn;

    public CopyAuthorization(String modelId, String accessToken, String resourceId, String resourceRegion, long expiresOn) {
        this.modelId = modelId;
        this.accessToken = accessToken;
        this.resourceId = resourceId;
        this.resourceRegion = resourceRegion;
        this.expirationDateTimeTicks = expiresOn;
        this.expiresOn = OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresOn), ZoneOffset.UTC);
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String toJson() {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            block13: {
                JsonWriter jsonWriter = JsonProviders.createWriter((OutputStream)outputStream);
                try {
                    jsonWriter.writeStartObject();
                    jsonWriter.writeStringField("modelId", this.modelId);
                    jsonWriter.writeStringField("accessToken", this.accessToken);
                    jsonWriter.writeStringField("resourceId", this.resourceId);
                    jsonWriter.writeStringField("resourceRegion", this.resourceRegion);
                    jsonWriter.writeLongField("expirationDateTimeTicks", this.expirationDateTimeTicks);
                    jsonWriter.writeEndObject();
                    jsonWriter.flush();
                    string = outputStream.toString();
                    if (jsonWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Serialization Failed.", e));
        }
    }

    public static CopyAuthorization fromJson(String copyAuthorization) {
        CopyAuthorization copyAuthorization2;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)copyAuthorization);
            try {
                copyAuthorization2 = (CopyAuthorization)jsonReader.readObject(reader -> {
                    String modelId = null;
                    String accessToken = null;
                    String resourceId = null;
                    String resourceRegion = null;
                    long expirationDateTimeTicks = 0L;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("modelId".equals(fieldName)) {
                            modelId = reader.getString();
                            continue;
                        }
                        if ("accessToken".equals(fieldName)) {
                            accessToken = reader.getString();
                            continue;
                        }
                        if ("resourceId".equals(fieldName)) {
                            resourceId = reader.getString();
                            continue;
                        }
                        if ("resourceRegion".equals(fieldName)) {
                            resourceRegion = reader.getString();
                            continue;
                        }
                        if ("expirationDateTimeTicks".equals(fieldName)) {
                            expirationDateTimeTicks = reader.getLong();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    return new CopyAuthorization(modelId, accessToken, resourceId, resourceRegion, expirationDateTimeTicks);
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Deserialization Failed.", e));
                }
            }
            jsonReader.close();
        }
        return copyAuthorization2;
    }
}

