/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class CopyAuthorization {
    private static final ClientLogger LOGGER = new ClientLogger(CopyAuthorization.class);
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private String modelId;
    private String accessToken;
    private String resourceId;
    private String resourceRegion;
    @JsonProperty(value="expirationDateTimeTicks")
    private long expirationDateTimeTicks;
    @JsonIgnore
    private OffsetDateTime expiresOn;

    CopyAuthorization() {
    }

    public CopyAuthorization(String modelId, String accessToken, String resourceId, String resourceRegion, long expiresOn) {
        this.modelId = modelId;
        this.accessToken = accessToken;
        this.resourceId = resourceId;
        this.resourceRegion = resourceRegion;
        this.expirationDateTimeTicks = expiresOn;
        this.expiresOn = OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresOn), ZoneOffset.UTC);
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    public String toJson() {
        try {
            return SERIALIZER.serialize((Object)this, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Serialization Failed.", e));
        }
    }

    public static CopyAuthorization fromJson(String copyAuthorization) {
        CopyAuthorization copyAuthorizationObj;
        try {
            copyAuthorizationObj = (CopyAuthorization)SERIALIZER.deserialize(copyAuthorization, CopyAuthorization.class, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Deserialization Failed.", e));
        }
        return new CopyAuthorization(copyAuthorizationObj.getModelId(), copyAuthorizationObj.getAccessToken(), copyAuthorizationObj.getResourceId(), copyAuthorizationObj.getResourceRegion(), copyAuthorizationObj.getExpirationDateTimeTicks());
    }

    long getExpirationDateTimeTicks() {
        return this.expirationDateTimeTicks;
    }
}

