/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatCompletionsToolCall;
import com.azure.ai.inference.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatResponseMessage
implements JsonSerializable<ChatResponseMessage> {
    private final ChatRole role;
    private final String content;
    private List<ChatCompletionsToolCall> toolCalls;

    private ChatResponseMessage(ChatRole role, String content) {
        this.role = role;
        this.content = content;
    }

    public ChatRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChatResponseMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatResponseMessage)jsonReader.readObject(reader -> {
            ChatRole role = null;
            String content = null;
            List toolCalls = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            ChatResponseMessage deserializedChatResponseMessage = new ChatResponseMessage(role, content);
            deserializedChatResponseMessage.toolCalls = toolCalls;
            return deserializedChatResponseMessage;
        });
    }
}

