/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CompletionsUsage
implements JsonSerializable<CompletionsUsage> {
    private final int completionTokens;
    private final int promptTokens;
    private final int totalTokens;

    private CompletionsUsage(int completionTokens, int promptTokens, int totalTokens) {
        this.completionTokens = completionTokens;
        this.promptTokens = promptTokens;
        this.totalTokens = totalTokens;
    }

    public int getCompletionTokens() {
        return this.completionTokens;
    }

    public int getPromptTokens() {
        return this.promptTokens;
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("completion_tokens", this.completionTokens);
        jsonWriter.writeIntField("prompt_tokens", this.promptTokens);
        jsonWriter.writeIntField("total_tokens", this.totalTokens);
        return jsonWriter.writeEndObject();
    }

    public static CompletionsUsage fromJson(JsonReader jsonReader) throws IOException {
        return (CompletionsUsage)jsonReader.readObject(reader -> {
            int completionTokens = 0;
            int promptTokens = 0;
            int totalTokens = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completion_tokens".equals(fieldName)) {
                    completionTokens = reader.getInt();
                    continue;
                }
                if ("prompt_tokens".equals(fieldName)) {
                    promptTokens = reader.getInt();
                    continue;
                }
                if ("total_tokens".equals(fieldName)) {
                    totalTokens = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new CompletionsUsage(completionTokens, promptTokens, totalTokens);
        });
    }
}

