/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.TypeReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EmbeddingItem
implements JsonSerializable<EmbeddingItem> {
    private final BinaryData embedding;
    private final int index;

    private EmbeddingItem(BinaryData embedding, int index) {
        this.embedding = embedding;
        this.index = index;
    }

    public BinaryData getEmbedding() {
        return this.embedding;
    }

    public List<Float> getEmbeddingList() {
        return (List)this.embedding.toObject((TypeReference)new TypeReference<List<Float>>(){});
    }

    public int getIndex() {
        return this.index;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("embedding", this.embedding.toObject(Object.class));
        jsonWriter.writeIntField("index", this.index);
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingItem fromJson(JsonReader jsonReader) throws IOException {
        return (EmbeddingItem)jsonReader.readObject(reader -> {
            BinaryData embedding = null;
            int index = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("embedding".equals(fieldName)) {
                    embedding = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new EmbeddingItem(embedding, index);
        });
    }
}

