/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.implementation.models;

import com.azure.ai.inference.models.EmbeddingEncodingFormat;
import com.azure.ai.inference.models.EmbeddingInput;
import com.azure.ai.inference.models.EmbeddingInputType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ImageEmbedRequest
implements JsonSerializable<ImageEmbedRequest> {
    private final List<EmbeddingInput> input;
    private Integer dimensions;
    private EmbeddingEncodingFormat encodingFormat;
    private EmbeddingInputType inputType;
    private String model;
    private Map<String, Object> additionalProperties;

    public ImageEmbedRequest(List<EmbeddingInput> input) {
        this.input = input;
    }

    public List<EmbeddingInput> getInput() {
        return this.input;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public ImageEmbedRequest setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public EmbeddingEncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    public ImageEmbedRequest setEncodingFormat(EmbeddingEncodingFormat encodingFormat) {
        this.encodingFormat = encodingFormat;
        return this;
    }

    public EmbeddingInputType getInputType() {
        return this.inputType;
    }

    public ImageEmbedRequest setInputType(EmbeddingInputType inputType) {
        this.inputType = inputType;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public ImageEmbedRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ImageEmbedRequest setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("input", this.input, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("dimensions", (Number)this.dimensions);
        jsonWriter.writeStringField("encoding_format", this.encodingFormat == null ? null : this.encodingFormat.toString());
        jsonWriter.writeStringField("input_type", this.inputType == null ? null : this.inputType.toString());
        jsonWriter.writeStringField("model", this.model);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ImageEmbedRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ImageEmbedRequest)jsonReader.readObject(reader -> {
            List input = null;
            Integer dimensions = null;
            EmbeddingEncodingFormat encodingFormat = null;
            EmbeddingInputType inputType = null;
            String model = null;
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    input = reader.readArray(reader1 -> EmbeddingInput.fromJson(reader1));
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    dimensions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("encoding_format".equals(fieldName)) {
                    encodingFormat = EmbeddingEncodingFormat.fromString(reader.getString());
                    continue;
                }
                if ("input_type".equals(fieldName)) {
                    inputType = EmbeddingInputType.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            ImageEmbedRequest deserializedEmbedRequest1 = new ImageEmbedRequest(input);
            deserializedEmbedRequest1.dimensions = dimensions;
            deserializedEmbedRequest1.encodingFormat = encodingFormat;
            deserializedEmbedRequest1.inputType = inputType;
            deserializedEmbedRequest1.model = model;
            deserializedEmbedRequest1.additionalProperties = additionalProperties;
            return deserializedEmbedRequest1;
        });
    }
}

