/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.implementation.models;

import com.azure.ai.inference.models.EmbeddingEncodingFormat;
import com.azure.ai.inference.models.EmbeddingInputType;
import com.azure.ai.inference.models.ImageEmbeddingInput;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ImageEmbedRequest
implements JsonSerializable<ImageEmbedRequest> {
    private final List<ImageEmbeddingInput> input;
    private Integer dimensions;
    private EmbeddingEncodingFormat encodingFormat;
    private EmbeddingInputType inputType;
    private String model;
    private Map<String, BinaryData> additionalProperties;

    public ImageEmbedRequest(List<ImageEmbeddingInput> input) {
        this.input = input;
    }

    public List<ImageEmbeddingInput> getInput() {
        return this.input;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public ImageEmbedRequest setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public EmbeddingEncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    public ImageEmbedRequest setEncodingFormat(EmbeddingEncodingFormat encodingFormat) {
        this.encodingFormat = encodingFormat;
        return this;
    }

    public EmbeddingInputType getInputType() {
        return this.inputType;
    }

    public ImageEmbedRequest setInputType(EmbeddingInputType inputType) {
        this.inputType = inputType;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public ImageEmbedRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public Map<String, BinaryData> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ImageEmbedRequest setAdditionalProperties(Map<String, BinaryData> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("input", this.input, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("dimensions", (Number)this.dimensions);
        jsonWriter.writeStringField("encoding_format", this.encodingFormat == null ? null : this.encodingFormat.toString());
        jsonWriter.writeStringField("input_type", this.inputType == null ? null : this.inputType.toString());
        jsonWriter.writeStringField("model", this.model);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, BinaryData> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeFieldName(additionalProperty.getKey());
                if (additionalProperty.getValue() == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                additionalProperty.getValue().writeTo(jsonWriter);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ImageEmbedRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ImageEmbedRequest)jsonReader.readObject(reader -> {
            List input = null;
            Integer dimensions = null;
            EmbeddingEncodingFormat encodingFormat = null;
            EmbeddingInputType inputType = null;
            String model = null;
            LinkedHashMap<String, BinaryData> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    input = reader.readArray(reader1 -> ImageEmbeddingInput.fromJson(reader1));
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    dimensions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("encoding_format".equals(fieldName)) {
                    encodingFormat = EmbeddingEncodingFormat.fromString(reader.getString());
                    continue;
                }
                if ("input_type".equals(fieldName)) {
                    inputType = EmbeddingInputType.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, BinaryData>();
                }
                additionalProperties.put(fieldName, (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
            }
            ImageEmbedRequest deserializedEmbedRequest1 = new ImageEmbedRequest(input);
            deserializedEmbedRequest1.dimensions = dimensions;
            deserializedEmbedRequest1.encodingFormat = encodingFormat;
            deserializedEmbedRequest1.inputType = inputType;
            deserializedEmbedRequest1.model = model;
            deserializedEmbedRequest1.additionalProperties = additionalProperties;
            return deserializedEmbedRequest1;
        });
    }
}

