/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.FunctionCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ChatCompletionsToolCall
implements JsonSerializable<ChatCompletionsToolCall> {
    private final String id;
    private final String type = "function";
    private final FunctionCall function;

    public ChatCompletionsToolCall(String id, FunctionCall function) {
        this.id = id;
        this.function = function;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public FunctionCall getFunction() {
        return this.function;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("function", (JsonSerializable)this.function);
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletionsToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (ChatCompletionsToolCall)jsonReader.readObject(reader -> {
            String id = null;
            FunctionCall function = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("function".equals(fieldName)) {
                    function = FunctionCall.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatCompletionsToolCall(id, function);
        });
    }
}

