/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor;

import com.azure.ai.metricsadvisor.MetricsAdvisorClientBuilder;
import com.azure.ai.metricsadvisor.MetricsAdvisorServiceVersion;
import com.azure.ai.metricsadvisor.implementation.AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl;
import com.azure.ai.metricsadvisor.implementation.models.AlertingResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDimensionQuery;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyFeedback;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyFeedbackValue;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyResult;
import com.azure.ai.metricsadvisor.implementation.models.ChangePointFeedback;
import com.azure.ai.metricsadvisor.implementation.models.ChangePointFeedbackValue;
import com.azure.ai.metricsadvisor.implementation.models.CommentFeedback;
import com.azure.ai.metricsadvisor.implementation.models.CommentFeedbackValue;
import com.azure.ai.metricsadvisor.implementation.models.CreateMetricFeedbackHeaders;
import com.azure.ai.metricsadvisor.implementation.models.DetectionAnomalyFilterCondition;
import com.azure.ai.metricsadvisor.implementation.models.DetectionAnomalyResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.DetectionIncidentFilterCondition;
import com.azure.ai.metricsadvisor.implementation.models.DetectionIncidentResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.DetectionSeriesQuery;
import com.azure.ai.metricsadvisor.implementation.models.DimensionGroupIdentity;
import com.azure.ai.metricsadvisor.implementation.models.EnrichmentStatusQueryOption;
import com.azure.ai.metricsadvisor.implementation.models.FeedbackDimensionFilter;
import com.azure.ai.metricsadvisor.implementation.models.IncidentResult;
import com.azure.ai.metricsadvisor.implementation.models.MetricDataList;
import com.azure.ai.metricsadvisor.implementation.models.MetricDataQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricDimensionQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedbackFilter;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesItem;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.PeriodFeedback;
import com.azure.ai.metricsadvisor.implementation.models.PeriodFeedbackValue;
import com.azure.ai.metricsadvisor.implementation.models.RootCauseList;
import com.azure.ai.metricsadvisor.implementation.models.SeriesIdentity;
import com.azure.ai.metricsadvisor.implementation.models.SeriesResultList;
import com.azure.ai.metricsadvisor.implementation.util.AnomalyTransforms;
import com.azure.ai.metricsadvisor.implementation.util.DetectionConfigurationTransforms;
import com.azure.ai.metricsadvisor.implementation.util.IncidentHelper;
import com.azure.ai.metricsadvisor.implementation.util.IncidentRootCauseTransforms;
import com.azure.ai.metricsadvisor.implementation.util.IncidentTransforms;
import com.azure.ai.metricsadvisor.implementation.util.MetricEnrichedSeriesDataTransformations;
import com.azure.ai.metricsadvisor.implementation.util.MetricFeedbackTransforms;
import com.azure.ai.metricsadvisor.implementation.util.MetricSeriesDataTransforms;
import com.azure.ai.metricsadvisor.implementation.util.MetricSeriesDefinitionTransforms;
import com.azure.ai.metricsadvisor.implementation.util.Utility;
import com.azure.ai.metricsadvisor.models.AnomalyAlert;
import com.azure.ai.metricsadvisor.models.AnomalyIncident;
import com.azure.ai.metricsadvisor.models.DataPointAnomaly;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import com.azure.ai.metricsadvisor.models.EnrichmentStatus;
import com.azure.ai.metricsadvisor.models.IncidentRootCause;
import com.azure.ai.metricsadvisor.models.ListAlertOptions;
import com.azure.ai.metricsadvisor.models.ListAnomaliesAlertedOptions;
import com.azure.ai.metricsadvisor.models.ListAnomaliesDetectedOptions;
import com.azure.ai.metricsadvisor.models.ListAnomalyDimensionValuesOptions;
import com.azure.ai.metricsadvisor.models.ListIncidentsAlertedOptions;
import com.azure.ai.metricsadvisor.models.ListIncidentsDetectedOptions;
import com.azure.ai.metricsadvisor.models.ListMetricDimensionValuesOptions;
import com.azure.ai.metricsadvisor.models.ListMetricEnrichmentStatusOptions;
import com.azure.ai.metricsadvisor.models.ListMetricFeedbackOptions;
import com.azure.ai.metricsadvisor.models.ListMetricSeriesDefinitionOptions;
import com.azure.ai.metricsadvisor.models.MetricAnomalyFeedback;
import com.azure.ai.metricsadvisor.models.MetricChangePointFeedback;
import com.azure.ai.metricsadvisor.models.MetricCommentFeedback;
import com.azure.ai.metricsadvisor.models.MetricEnrichedSeriesData;
import com.azure.ai.metricsadvisor.models.MetricFeedback;
import com.azure.ai.metricsadvisor.models.MetricPeriodFeedback;
import com.azure.ai.metricsadvisor.models.MetricSeriesData;
import com.azure.ai.metricsadvisor.models.MetricSeriesDefinition;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MetricsAdvisorClientBuilder.class, isAsync=true)
public final class MetricsAdvisorAsyncClient {
    private static final String METRICS_ADVISOR_TRACING_NAMESPACE_VALUE = "Microsoft.CognitiveServices";
    final ClientLogger logger = new ClientLogger(MetricsAdvisorAsyncClient.class);
    private final AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl service;

    MetricsAdvisorAsyncClient(AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl service, MetricsAdvisorServiceVersion serviceVersion) {
        this.service = service;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricSeriesDefinition> listMetricSeriesDefinitions(String metricId, OffsetDateTime activeSince) {
        return this.listMetricSeriesDefinitions(metricId, activeSince, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricSeriesDefinition> listMetricSeriesDefinitions(String metricId, OffsetDateTime activeSince, ListMetricSeriesDefinitionOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listMetricSeriesDefinitionSinglePageAsync(metricId, activeSince, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listMetricSeriesDefinitionNextPageAsync((String)continuationToken, activeSince, options, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<MetricSeriesDefinition> listMetricSeriesDefinitions(String metricId, OffsetDateTime activeSince, ListMetricSeriesDefinitionOptions options, Context context) {
        return new PagedFlux(() -> this.listMetricSeriesDefinitionSinglePageAsync(metricId, activeSince, options, context), continuationToken -> this.listMetricSeriesDefinitionNextPageAsync((String)continuationToken, activeSince, options, context));
    }

    private Mono<PagedResponse<MetricSeriesDefinition>> listMetricSeriesDefinitionSinglePageAsync(String metricId, OffsetDateTime activeSince, ListMetricSeriesDefinitionOptions options, Context context) {
        if (activeSince == null) {
            Objects.requireNonNull(options, "'activeSince' is required and cannot be null.");
        }
        if (options == null) {
            options = new ListMetricSeriesDefinitionOptions();
        }
        MetricSeriesQueryOptions metricSeriesQueryOptions = new MetricSeriesQueryOptions().setActiveSince(activeSince).setDimensionFilter(options.getDimensionCombinationsToFilter());
        return this.service.getMetricSeriesSinglePageAsync(UUID.fromString(metricId), metricSeriesQueryOptions, options.getSkip(), options.getMaxPageSize(), context).doOnRequest(ignoredValue -> this.logger.info("Listing information metric series definitions")).doOnSuccess(response -> this.logger.info("Listed metric series definitions - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list metric series definitions information - {}", new Object[]{error})).map(res -> MetricSeriesDefinitionTransforms.fromInnerResponse((PagedResponse<MetricSeriesItem>)res));
    }

    private Mono<PagedResponse<MetricSeriesDefinition>> listMetricSeriesDefinitionNextPageAsync(String nextPageLink, OffsetDateTime activeSince, ListMetricSeriesDefinitionOptions options, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        if (activeSince == null) {
            Objects.requireNonNull(options, "'activeSince' is required and cannot be null.");
        }
        if (options == null) {
            options = new ListMetricSeriesDefinitionOptions();
        }
        MetricSeriesQueryOptions metricSeriesQueryOptions = new MetricSeriesQueryOptions().setActiveSince(activeSince).setDimensionFilter(options.getDimensionCombinationsToFilter());
        return this.service.getMetricSeriesNextSinglePageAsync(nextPageLink, metricSeriesQueryOptions, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(res -> MetricSeriesDefinitionTransforms.fromInnerResponse((PagedResponse<MetricSeriesItem>)res));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricSeriesData> listMetricSeriesData(String metricId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listMetricSeriesDataInternal(metricId, seriesKeys, startTime, endTime, (Context)context)), null);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<MetricSeriesData> listMetricSeriesData(String metricId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        return new PagedFlux(() -> this.listMetricSeriesDataInternal(metricId, seriesKeys, startTime, endTime, context), null);
    }

    private Mono<PagedResponse<MetricSeriesData>> listMetricSeriesDataInternal(String metricId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        Objects.requireNonNull(metricId, "'metricId' cannot be null.");
        Objects.requireNonNull(startTime, "'startTime' cannot be null.");
        Objects.requireNonNull(endTime, "'endTime' cannot be null.");
        if (CoreUtils.isNullOrEmpty(seriesKeys)) {
            Objects.requireNonNull(seriesKeys, "'seriesKeys' cannot be null or empty.");
        }
        List<Map<String, String>> dimensionList = seriesKeys.stream().map(DimensionKey::asMap).collect(Collectors.toList());
        MetricDataQueryOptions metricDataQueryOptions = new MetricDataQueryOptions().setStartTime(startTime).setEndTime(startTime).setSeries(dimensionList);
        return this.service.getMetricDataWithResponseAsync(UUID.fromString(metricId), metricDataQueryOptions, context).map(response -> MetricSeriesDataTransforms.fromInnerResponse((Response<MetricDataList>)response));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listMetricDimensionValues(String metricId, String dimensionName) {
        return this.listMetricDimensionValues(metricId, dimensionName, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listMetricDimensionValues(String metricId, String dimensionName, ListMetricDimensionValuesOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listMetricDimensionValuesSinglePageAsync(metricId, dimensionName, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listMetricDimensionValuesNextPageAsync((String)continuationToken, dimensionName, options, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<String> listMetricDimensionValues(String metricId, String dimensionName, ListMetricDimensionValuesOptions options, Context context) {
        return new PagedFlux(() -> this.listMetricDimensionValuesSinglePageAsync(metricId, dimensionName, options, context), continuationToken -> this.listMetricDimensionValuesNextPageAsync((String)continuationToken, dimensionName, options, context));
    }

    private Mono<PagedResponse<String>> listMetricDimensionValuesSinglePageAsync(String metricId, String dimensionName, ListMetricDimensionValuesOptions options, Context context) {
        Objects.requireNonNull(metricId, "'metricId' cannot be null.");
        Objects.requireNonNull(dimensionName, "'dimensionName' cannot be null.");
        if (options == null) {
            options = new ListMetricDimensionValuesOptions();
        }
        MetricDimensionQueryOptions metricDimensionQueryOptions = new MetricDimensionQueryOptions().setDimensionName(dimensionName).setDimensionValueFilter(options.getDimensionValueToFilter());
        return this.service.getMetricDimensionSinglePageAsync(UUID.fromString(metricId), metricDimensionQueryOptions, options.getSkip(), options.getMaxPageSize(), context).doOnRequest(ignoredValue -> this.logger.info("Listing all dimension values for a metric")).doOnSuccess(response -> this.logger.info("Listed all dimension values for a metric")).doOnError(error -> this.logger.warning("Failed to list all dimension values for a metric information", new Object[]{error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue(), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<String>> listMetricDimensionValuesNextPageAsync(String nextPageLink, String dimensionName, ListMetricDimensionValuesOptions options, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        if (options == null) {
            options = new ListMetricDimensionValuesOptions();
        }
        MetricDimensionQueryOptions metricDimensionQueryOptions = new MetricDimensionQueryOptions().setDimensionName(dimensionName).setDimensionValueFilter(options.getDimensionValueToFilter());
        return this.service.getMetricDimensionNextSinglePageAsync(nextPageLink, metricDimensionQueryOptions, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue(), (String)res.getContinuationToken(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EnrichmentStatus> listMetricEnrichmentStatus(String metricId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listMetricEnrichmentStatus(metricId, startTime, endTime, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EnrichmentStatus> listMetricEnrichmentStatus(String metricId, OffsetDateTime startTime, OffsetDateTime endTime, ListMetricEnrichmentStatusOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listMetricEnrichmentStatusSinglePageAsync(metricId, startTime, endTime, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listMetricEnrichmentStatusNextPageAsync((String)continuationToken, startTime, endTime, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<EnrichmentStatus> listMetricEnrichmentStatus(String metricId, OffsetDateTime startTime, OffsetDateTime endTime, ListMetricEnrichmentStatusOptions options, Context context) {
        return new PagedFlux(() -> this.listMetricEnrichmentStatusSinglePageAsync(metricId, startTime, endTime, options, context), continuationToken -> this.listMetricEnrichmentStatusNextPageAsync((String)continuationToken, startTime, endTime, context));
    }

    private Mono<PagedResponse<EnrichmentStatus>> listMetricEnrichmentStatusSinglePageAsync(String metricId, OffsetDateTime startTime, OffsetDateTime endTime, ListMetricEnrichmentStatusOptions options, Context context) {
        Objects.requireNonNull(metricId, "'metricId' is required.");
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        if (options == null) {
            options = new ListMetricEnrichmentStatusOptions();
        }
        EnrichmentStatusQueryOption enrichmentStatusQueryOption = new EnrichmentStatusQueryOption().setStartTime(startTime).setEndTime(endTime);
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getEnrichmentStatusByMetricSinglePageAsync(UUID.fromString(metricId), enrichmentStatusQueryOption, options.getSkip(), options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing all metric enrichment status values for a metric")).doOnSuccess(response -> this.logger.info("Listed all metric enrichment status values for a metric - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list all metric enrichment values for a metric information", new Object[]{error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue(), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<EnrichmentStatus>> listMetricEnrichmentStatusNextPageAsync(String nextPageLink, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        EnrichmentStatusQueryOption enrichmentStatusQueryOption = new EnrichmentStatusQueryOption().setStartTime(startTime).setEndTime(endTime);
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getEnrichmentStatusByMetricNextSinglePageAsync(nextPageLink, enrichmentStatusQueryOption, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue(), (String)res.getContinuationToken(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricEnrichedSeriesData> listMetricEnrichedSeriesData(String detectionConfigurationId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listMetricEnrichedSeriesDataInternal(detectionConfigurationId, seriesKeys, startTime, endTime, (Context)context)), null);
        }
        catch (RuntimeException e) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e));
        }
    }

    PagedFlux<MetricEnrichedSeriesData> listMetricEnrichedSeriesData(String detectionConfigurationId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        return new PagedFlux(() -> this.listMetricEnrichedSeriesDataInternal(detectionConfigurationId, seriesKeys, startTime, endTime, context), null);
    }

    private Mono<PagedResponse<MetricEnrichedSeriesData>> listMetricEnrichedSeriesDataInternal(String detectionConfigurationId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        Objects.requireNonNull(seriesKeys, "'seriesKeys' is required.");
        if (seriesKeys.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'seriesKeys' cannot be empty."));
        }
        Objects.requireNonNull(detectionConfigurationId, "'detectionConfigurationId' is required.");
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        List<SeriesIdentity> innerSeriesKeys = seriesKeys.stream().map(seriesId -> new SeriesIdentity().setDimension(seriesId.asMap())).collect(Collectors.toList());
        DetectionSeriesQuery query = new DetectionSeriesQuery().setSeries(innerSeriesKeys).setStartTime(startTime).setEndTime(endTime);
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getSeriesByAnomalyDetectionConfigurationWithResponseAsync(UUID.fromString(detectionConfigurationId), query, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the EnrichedSeries")).doOnSuccess(response -> this.logger.info("Retrieved the EnrichedSeries {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to retrieve EnrichedSeries", new Object[]{error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), MetricEnrichedSeriesDataTransformations.fromInnerList((SeriesResultList)res.getValue()), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataPointAnomaly> listAnomaliesForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listAnomaliesForDetectionConfig(detectionConfigurationId, startTime, endTime, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataPointAnomaly> listAnomaliesForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomaliesDetectedOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listAnomaliesForDetectionConfigSinglePageAsync(detectionConfigurationId, startTime, endTime, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listAnomaliesForDetectionConfigNextPageAsync((String)continuationToken, startTime, endTime, options, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DataPointAnomaly> listAnomaliesForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomaliesDetectedOptions options, Context context) {
        return new PagedFlux(() -> this.listAnomaliesForDetectionConfigSinglePageAsync(detectionConfigurationId, startTime, endTime, options, context), continuationToken -> this.listAnomaliesForDetectionConfigNextPageAsync((String)continuationToken, startTime, endTime, options, context));
    }

    private Mono<PagedResponse<DataPointAnomaly>> listAnomaliesForDetectionConfigSinglePageAsync(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomaliesDetectedOptions options, Context context) {
        DetectionAnomalyFilterCondition innerFilter;
        Objects.requireNonNull(detectionConfigurationId, "'detectionConfigurationId' is required.");
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        DetectionAnomalyResultQuery query = new DetectionAnomalyResultQuery().setStartTime(startTime).setEndTime(endTime);
        if (options == null) {
            options = new ListAnomaliesDetectedOptions();
        }
        if (options.getFilter() != null && (innerFilter = AnomalyTransforms.toInnerFilter(options.getFilter(), this.logger)) != null) {
            query.setFilter(innerFilter);
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(UUID.fromString(detectionConfigurationId), query, options.getSkip(), options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing anomalies detected")).doOnSuccess(response -> this.logger.info("Listed anomalies {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the anomalies detected", new Object[]{error})).map(response -> AnomalyTransforms.fromInnerPagedResponse((PagedResponse<AnomalyResult>)response));
    }

    private Mono<PagedResponse<DataPointAnomaly>> listAnomaliesForDetectionConfigNextPageAsync(String nextPageLink, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomaliesDetectedOptions options, Context context) {
        DetectionAnomalyFilterCondition innerFilter;
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        DetectionAnomalyResultQuery query = new DetectionAnomalyResultQuery().setStartTime(startTime).setEndTime(endTime);
        if (options == null) {
            options = new ListAnomaliesDetectedOptions();
        }
        if (options.getFilter() != null && (innerFilter = AnomalyTransforms.toInnerFilter(options.getFilter(), this.logger)) != null) {
            query.setFilter(innerFilter);
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(nextPageLink, query, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {} {}", new Object[]{nextPageLink, response})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(response -> AnomalyTransforms.fromInnerPagedResponse((PagedResponse<AnomalyResult>)response));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyIncident> listIncidentsForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listIncidentsForDetectionConfig(detectionConfigurationId, startTime, endTime, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyIncident> listIncidentsForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListIncidentsDetectedOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIncidentsForDetectionConfigSinglePageAsync(detectionConfigurationId, startTime, endTime, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listIncidentsForDetectionConfigNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<AnomalyIncident> listIncidentsForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListIncidentsDetectedOptions options, Context context) {
        return new PagedFlux(() -> this.listIncidentsForDetectionConfigSinglePageAsync(detectionConfigurationId, startTime, endTime, options, context), continuationToken -> this.listIncidentsForDetectionConfigNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<AnomalyIncident>> listIncidentsForDetectionConfigSinglePageAsync(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListIncidentsDetectedOptions options, Context context) {
        Objects.requireNonNull(detectionConfigurationId, "'detectionConfigurationId' is required.");
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        DetectionIncidentResultQuery query = new DetectionIncidentResultQuery().setStartTime(startTime).setEndTime(endTime);
        if (options == null) {
            options = new ListIncidentsDetectedOptions();
        }
        if (options.getDimensionsToFilter() != null) {
            ArrayList<DimensionGroupIdentity> innerDimensionsToFilter = new ArrayList<DimensionGroupIdentity>();
            for (DimensionKey dimensionToFilter : options.getDimensionsToFilter()) {
                innerDimensionsToFilter.add(new DimensionGroupIdentity().setDimension(dimensionToFilter.asMap()));
            }
            if (!innerDimensionsToFilter.isEmpty()) {
                query.setFilter(new DetectionIncidentFilterCondition().setDimensionFilter(innerDimensionsToFilter));
            }
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(UUID.fromString(detectionConfigurationId), query, options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing incidents detected")).doOnSuccess(response -> this.logger.info("Listed incidents {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the incidents detected", new Object[]{error})).map(response -> IncidentTransforms.fromInnerPagedResponse((PagedResponse<IncidentResult>)response));
    }

    private Mono<PagedResponse<AnomalyIncident>> listIncidentsForDetectionConfigNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync(nextPageLink, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {} {}", new Object[]{nextPageLink, response})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(response -> IncidentTransforms.fromInnerPagedResponse((PagedResponse<IncidentResult>)response));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentRootCause> listIncidentRootCauses(String detectionConfigurationId, String incidentId) {
        AnomalyIncident anomalyIncident = new AnomalyIncident();
        IncidentHelper.setId(anomalyIncident, incidentId);
        IncidentHelper.setDetectionConfigurationId(anomalyIncident, detectionConfigurationId);
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIncidentRootCausesInternal(anomalyIncident, (Context)context)), null);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<IncidentRootCause> listIncidentRootCauses(String detectionConfigurationId, String incidentId, Context context) {
        try {
            Objects.requireNonNull(detectionConfigurationId, "'detectionConfigurationId' is required.");
            Objects.requireNonNull(incidentId, "'incidentId' is required.");
            AnomalyIncident anomalyIncident = new AnomalyIncident();
            IncidentHelper.setId(anomalyIncident, incidentId);
            IncidentHelper.setDetectionConfigurationId(anomalyIncident, detectionConfigurationId);
            return new PagedFlux(() -> this.listIncidentRootCausesInternal(anomalyIncident, context), null);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentRootCause> listIncidentRootCauses(AnomalyIncident anomalyIncident) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIncidentRootCausesInternal(anomalyIncident, (Context)context)), null);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<IncidentRootCause> listIncidentRootCauses(AnomalyIncident anomalyIncident, Context context) {
        return new PagedFlux(() -> this.listIncidentRootCausesInternal(anomalyIncident, context), null);
    }

    private Mono<PagedResponse<IncidentRootCause>> listIncidentRootCausesInternal(AnomalyIncident anomalyIncident, Context context) {
        if (anomalyIncident == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'anomalyIncident' is required."));
        }
        Objects.requireNonNull(anomalyIncident.getDetectionConfigurationId(), "'anomalyIncident.detectionConfigurationId' is required.");
        Objects.requireNonNull(anomalyIncident.getId(), "'anomalyIncident.id' is required");
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(UUID.fromString(anomalyIncident.getDetectionConfigurationId()), anomalyIncident.getId(), withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieved the IncidentRootCauses - {}", new Object[]{anomalyIncident.getDetectionConfigurationId()})).doOnSuccess(response -> this.logger.info("Retrieved the IncidentRootCauses - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to retrieve the incident root causes - {}", new Object[]{anomalyIncident.getDetectionConfigurationId(), error})).map(res -> IncidentRootCauseTransforms.fromInnerResponse((Response<RootCauseList>)res));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listAnomalyDimensionValues(String detectionConfigurationId, String dimensionName, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listAnomalyDimensionValues(detectionConfigurationId, dimensionName, startTime, endTime, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listAnomalyDimensionValues(String detectionConfigurationId, String dimensionName, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomalyDimensionValuesOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listAnomalyDimensionValuesSinglePageAsync(detectionConfigurationId, dimensionName, startTime, endTime, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listAnomalyDimensionValuesNextPageAsync((String)continuationToken, dimensionName, startTime, endTime, options, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<String> listAnomalyDimensionValues(String detectionConfigurationId, String dimensionName, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomalyDimensionValuesOptions options, Context context) {
        return new PagedFlux(() -> this.listAnomalyDimensionValuesSinglePageAsync(detectionConfigurationId, dimensionName, startTime, endTime, options, context), continuationToken -> this.listAnomalyDimensionValuesNextPageAsync((String)continuationToken, dimensionName, startTime, endTime, options, context));
    }

    private Mono<PagedResponse<String>> listAnomalyDimensionValuesSinglePageAsync(String detectionConfigurationId, String dimensionName, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomalyDimensionValuesOptions options, Context context) {
        Objects.requireNonNull(detectionConfigurationId, "'detectionConfigurationId' is required.");
        Objects.requireNonNull(dimensionName, "'dimensionName' is required.");
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        AnomalyDimensionQuery query = new AnomalyDimensionQuery();
        query.setDimensionName(dimensionName);
        query.setStartTime(startTime);
        query.setEndTime(endTime);
        if (options == null) {
            options = new ListAnomalyDimensionValuesOptions();
        }
        if (options.getDimensionToFilter() != null) {
            query.setDimensionFilter(new DimensionGroupIdentity().setDimension(options.getDimensionToFilter().asMap()));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(UUID.fromString(detectionConfigurationId), query, options.getSkip(), options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing dimension values with anomalies")).doOnSuccess(response -> this.logger.info("Listed dimension values with anomalies {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the dimension values with anomalies", new Object[]{error}));
    }

    private Mono<PagedResponse<String>> listAnomalyDimensionValuesNextPageAsync(String nextPageLink, String dimensionName, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomalyDimensionValuesOptions options, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        AnomalyDimensionQuery query = new AnomalyDimensionQuery();
        query.setDimensionName(dimensionName);
        query.setStartTime(startTime);
        query.setEndTime(endTime);
        if (options.getDimensionToFilter() != null) {
            query.setDimensionFilter(new DimensionGroupIdentity().setDimension(options.getDimensionToFilter().asMap()));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(nextPageLink, query, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlert> listAlerts(String alertConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listAlerts(alertConfigurationId, startTime, endTime, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlert> listAlerts(String alertConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAlertOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listAlertsSinglePageAsync(alertConfigurationId, startTime, endTime, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listAlertsNextPageAsync((String)continuationToken, startTime, endTime, options, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<AnomalyAlert> listAlerts(String alertConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAlertOptions options, Context context) {
        return new PagedFlux(() -> this.listAlertsSinglePageAsync(alertConfigurationId, startTime, endTime, options, context), continuationToken -> this.listAlertsNextPageAsync((String)continuationToken, startTime, endTime, options, context));
    }

    private Mono<PagedResponse<AnomalyAlert>> listAlertsSinglePageAsync(String alertConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAlertOptions options, Context context) {
        Objects.requireNonNull(alertConfigurationId, "'alertConfigurationId' is required.");
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        if (options == null) {
            options = new ListAlertOptions();
        }
        AlertingResultQuery query = new AlertingResultQuery();
        query.setStartTime(startTime);
        query.setEndTime(endTime);
        query.setTimeMode(options.getTimeMode());
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getAlertsByAnomalyAlertingConfigurationSinglePageAsync(UUID.fromString(alertConfigurationId), query, options.getSkip(), options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing alerts")).doOnSuccess(response -> this.logger.info("Listed alerts {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the alerts", new Object[]{error}));
    }

    private Mono<PagedResponse<AnomalyAlert>> listAlertsNextPageAsync(String nextPageLink, OffsetDateTime startTime, OffsetDateTime endTime, ListAlertOptions options, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        AlertingResultQuery query = new AlertingResultQuery();
        query.setStartTime(startTime);
        query.setEndTime(endTime);
        query.setTimeMode(options.getTimeMode());
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync(nextPageLink, query, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataPointAnomaly> listAnomaliesForAlert(String alertConfigurationId, String alertId) {
        return this.listAnomaliesForAlert(alertConfigurationId, alertId, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataPointAnomaly> listAnomaliesForAlert(String alertConfigurationId, String alertId, ListAnomaliesAlertedOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listAnomaliesForAlertSinglePageAsync(alertConfigurationId, alertId, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listAnomaliesForAlertNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DataPointAnomaly> listAnomaliesForAlert(String alertConfigurationId, String alertId, ListAnomaliesAlertedOptions options, Context context) {
        return new PagedFlux(() -> this.listAnomaliesForAlertSinglePageAsync(alertConfigurationId, alertId, options, context), continuationToken -> this.listAnomaliesForAlertNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<DataPointAnomaly>> listAnomaliesForAlertSinglePageAsync(String alertConfigurationId, String alertId, ListAnomaliesAlertedOptions options, Context context) {
        Objects.requireNonNull(alertConfigurationId, "'alertConfigurationId' is required.");
        Objects.requireNonNull(alertId, "'alertId' is required.");
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(UUID.fromString(alertConfigurationId), alertId, options == null ? null : options.getSkip(), options == null ? null : options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing anomalies for alert")).doOnSuccess(response -> this.logger.info("Listed anomalies {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the anomalies for alert", new Object[]{error})).map(response -> AnomalyTransforms.fromInnerPagedResponse((PagedResponse<AnomalyResult>)response));
    }

    private Mono<PagedResponse<DataPointAnomaly>> listAnomaliesForAlertNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(nextPageLink, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {} {}", new Object[]{nextPageLink, response})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(response -> AnomalyTransforms.fromInnerPagedResponse((PagedResponse<AnomalyResult>)response));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyIncident> listIncidentsForAlert(String alertConfigurationId, String alertId) {
        return this.listIncidentsForAlert(alertConfigurationId, alertId, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyIncident> listIncidentsForAlert(String alertConfigurationId, String alertId, ListIncidentsAlertedOptions options) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIncidentsForAlertSinglePageAsync(alertConfigurationId, alertId, options, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listIncidentsForAlertNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<AnomalyIncident> listIncidentsForAlert(String alertConfigurationId, String alertId, ListIncidentsAlertedOptions options, Context context) {
        return new PagedFlux(() -> this.listIncidentsForAlertSinglePageAsync(alertConfigurationId, alertId, options, context), continuationToken -> this.listIncidentsForAlertNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<AnomalyIncident>> listIncidentsForAlertSinglePageAsync(String alertConfigurationId, String alertId, ListIncidentsAlertedOptions options, Context context) {
        Objects.requireNonNull(alertConfigurationId, "'alertConfigurationId' is required.");
        Objects.requireNonNull(alertId, "'alertId' is required.");
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(UUID.fromString(alertConfigurationId), alertId, options == null ? null : options.getSkip(), options == null ? null : options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing incidents for alert")).doOnSuccess(response -> this.logger.info("Listed incidents {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the incidents for alert", new Object[]{error})).map(response -> IncidentTransforms.fromInnerPagedResponse((PagedResponse<IncidentResult>)response));
    }

    private Mono<PagedResponse<AnomalyIncident>> listIncidentsForAlertNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(nextPageLink, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(response -> IncidentTransforms.fromInnerPagedResponse((PagedResponse<IncidentResult>)response));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricFeedback> addFeedback(String metricId, MetricFeedback metricFeedback) {
        return this.addFeedbackWithResponse(metricId, metricFeedback).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricFeedback>> addFeedbackWithResponse(String metricId, MetricFeedback metricFeedback) {
        try {
            return FluxUtil.withContext(context -> this.addFeedbackWithResponse(metricId, metricFeedback, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<MetricFeedback>> addFeedbackWithResponse(String metricId, MetricFeedback metricFeedback, Context context) {
        com.azure.ai.metricsadvisor.implementation.models.MetricFeedback innerMetricFeedback;
        Objects.requireNonNull(metricId, "'metricId' is required.");
        Objects.requireNonNull(metricFeedback, "'metricFeedback' is required.");
        Objects.requireNonNull(metricFeedback.getDimensionFilter(), "'metricFeedback.dimensionFilter' is required.");
        if (metricFeedback instanceof MetricAnomalyFeedback) {
            MetricAnomalyFeedback metricAnomalyFeedback = (MetricAnomalyFeedback)metricFeedback;
            Objects.requireNonNull(metricAnomalyFeedback.getStartTime(), "'metricFeedback.startTime' is required.");
            Objects.requireNonNull(metricAnomalyFeedback.getEndTime(), "'metricFeedback.endTime' is required.");
            Objects.requireNonNull(metricAnomalyFeedback.getAnomalyValue(), "'metricFeedback.anomalyValue' is required.");
            AnomalyFeedback innerAnomalyFeedback = new AnomalyFeedback().setStartTime(metricAnomalyFeedback.getStartTime()).setEndTime(metricAnomalyFeedback.getEndTime()).setValue(new AnomalyFeedbackValue().setAnomalyValue(metricAnomalyFeedback.getAnomalyValue()));
            if (metricAnomalyFeedback.getDetectionConfiguration() != null) {
                innerAnomalyFeedback.setAnomalyDetectionConfigurationId(UUID.fromString(metricAnomalyFeedback.getDetectionConfiguration().getId())).setAnomalyDetectionConfigurationSnapshot(DetectionConfigurationTransforms.toInnerForCreate(this.logger, metricId, metricAnomalyFeedback.getDetectionConfiguration()));
            }
            innerMetricFeedback = innerAnomalyFeedback.setMetricId(UUID.fromString(metricId)).setDimensionFilter(new FeedbackDimensionFilter().setDimension(metricAnomalyFeedback.getDimensionFilter().asMap()));
        } else if (metricFeedback instanceof MetricChangePointFeedback) {
            MetricChangePointFeedback metricChangePointFeedback = (MetricChangePointFeedback)metricFeedback;
            Objects.requireNonNull(metricChangePointFeedback.getStartTime(), "'metricFeedback.startTime' is required.");
            Objects.requireNonNull(metricChangePointFeedback.getEndTime(), "'metricFeedback.endTime' is required.");
            Objects.requireNonNull(metricChangePointFeedback.getChangePointValue(), "'metricFeedback.changePointValue' is required.");
            innerMetricFeedback = new ChangePointFeedback().setStartTime(metricChangePointFeedback.getStartTime()).setEndTime(metricChangePointFeedback.getEndTime()).setValue(new ChangePointFeedbackValue().setChangePointValue(metricChangePointFeedback.getChangePointValue())).setMetricId(UUID.fromString(metricId)).setDimensionFilter(new FeedbackDimensionFilter().setDimension(metricChangePointFeedback.getDimensionFilter().asMap()));
        } else if (metricFeedback instanceof MetricPeriodFeedback) {
            MetricPeriodFeedback metricPeriodFeedback = (MetricPeriodFeedback)metricFeedback;
            Objects.requireNonNull(metricPeriodFeedback.getPeriodType(), "'metricFeedback.periodType' is required.");
            Objects.requireNonNull(Integer.valueOf(metricPeriodFeedback.getPeriodValue()), "'metricFeedback.periodValue' is required.");
            innerMetricFeedback = new PeriodFeedback().setValue(new PeriodFeedbackValue().setPeriodValue(metricPeriodFeedback.getPeriodValue()).setPeriodType(metricPeriodFeedback.getPeriodType())).setMetricId(UUID.fromString(metricId)).setDimensionFilter(new FeedbackDimensionFilter().setDimension(metricPeriodFeedback.getDimensionFilter().asMap()));
        } else if (metricFeedback instanceof MetricCommentFeedback) {
            MetricCommentFeedback metricCommentFeedback = (MetricCommentFeedback)metricFeedback;
            Objects.requireNonNull(metricCommentFeedback.getComment(), "'metricFeedback.comment' is required.");
            innerMetricFeedback = new CommentFeedback().setStartTime(metricCommentFeedback.getStartTime()).setEndTime(metricCommentFeedback.getEndTime()).setValue(new CommentFeedbackValue().setCommentValue(metricCommentFeedback.getComment())).setMetricId(UUID.fromString(metricId)).setDimensionFilter(new FeedbackDimensionFilter().setDimension(metricCommentFeedback.getDimensionFilter().asMap()));
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown feedback type."));
        }
        return this.service.createMetricFeedbackWithResponseAsync(innerMetricFeedback, context).flatMap(createdMetricFeedbackResponse -> this.getFeedbackWithResponse(Utility.parseOperationId(((CreateMetricFeedbackHeaders)createdMetricFeedbackResponse.getDeserializedHeaders()).getLocation())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricFeedback> getFeedback(String feedbackId) {
        return this.getFeedbackWithResponse(feedbackId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricFeedback>> getFeedbackWithResponse(String feedbackId) {
        try {
            return FluxUtil.withContext(context -> this.getFeedbackWithResponse(feedbackId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<MetricFeedback>> getFeedbackWithResponse(String feedbackId, Context context) {
        Objects.requireNonNull(feedbackId, "'feedbackId' is required.");
        return this.service.getMetricFeedbackWithResponseAsync(UUID.fromString(feedbackId), context).map(metricFeedbackResponse -> new SimpleResponse(metricFeedbackResponse, (Object)MetricFeedbackTransforms.fromInner((com.azure.ai.metricsadvisor.implementation.models.MetricFeedback)metricFeedbackResponse.getValue())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricFeedback> listFeedback(String metricId) {
        return this.listFeedback(metricId, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricFeedback> listFeedback(String metricId, ListMetricFeedbackOptions options) {
        options = options != null ? options : new ListMetricFeedbackOptions();
        try {
            MetricFeedbackFilter metricFeedbackFilter = MetricFeedbackTransforms.toInnerFilter(metricId, options);
            ListMetricFeedbackOptions finalOptions = options;
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listMetricFeedbacksSinglePage(metricFeedbackFilter, finalOptions.getMaxPageSize(), finalOptions.getSkip(), (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listMetricFeedbacksNextPage((String)continuationToken, metricFeedbackFilter, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<MetricFeedback> listFeedback(String metricId, ListMetricFeedbackOptions options, Context context) {
        options = options != null ? options : new ListMetricFeedbackOptions();
        MetricFeedbackFilter metricFeedbackFilter = MetricFeedbackTransforms.toInnerFilter(metricId, options);
        ListMetricFeedbackOptions finalOptions = options;
        return new PagedFlux(() -> this.listMetricFeedbacksSinglePage(metricFeedbackFilter, finalOptions.getMaxPageSize(), finalOptions.getSkip(), context), continuationToken -> this.listMetricFeedbacksNextPage((String)continuationToken, metricFeedbackFilter, context));
    }

    private Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksSinglePage(MetricFeedbackFilter metricFeedbackFilter, Integer maxPageSize, Integer skip, Context context) {
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.listMetricFeedbacksSinglePageAsync(metricFeedbackFilter, skip, maxPageSize, withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing information for all metric feedbacks")).doOnSuccess(response -> this.logger.info("Listed metric feedbacks - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list all metric feedbacks information", new Object[]{error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(MetricFeedbackTransforms::fromInner).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksNextPage(String nextPageLink, MetricFeedbackFilter metricFeedbackFilter, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.listMetricFeedbacksNextSinglePageAsync(nextPageLink, metricFeedbackFilter, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(MetricFeedbackTransforms::fromInner).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }
}

