/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor;

import com.azure.ai.metricsadvisor.MetricsAdvisorAsyncClient;
import com.azure.ai.metricsadvisor.MetricsAdvisorClientBuilder;
import com.azure.ai.metricsadvisor.models.AnomalyAlert;
import com.azure.ai.metricsadvisor.models.AnomalyIncident;
import com.azure.ai.metricsadvisor.models.DataPointAnomaly;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import com.azure.ai.metricsadvisor.models.EnrichmentStatus;
import com.azure.ai.metricsadvisor.models.IncidentRootCause;
import com.azure.ai.metricsadvisor.models.ListAlertOptions;
import com.azure.ai.metricsadvisor.models.ListAnomaliesAlertedOptions;
import com.azure.ai.metricsadvisor.models.ListAnomaliesDetectedOptions;
import com.azure.ai.metricsadvisor.models.ListAnomalyDimensionValuesOptions;
import com.azure.ai.metricsadvisor.models.ListIncidentsAlertedOptions;
import com.azure.ai.metricsadvisor.models.ListIncidentsDetectedOptions;
import com.azure.ai.metricsadvisor.models.ListMetricDimensionValuesOptions;
import com.azure.ai.metricsadvisor.models.ListMetricEnrichmentStatusOptions;
import com.azure.ai.metricsadvisor.models.ListMetricFeedbackOptions;
import com.azure.ai.metricsadvisor.models.ListMetricSeriesDefinitionOptions;
import com.azure.ai.metricsadvisor.models.MetricEnrichedSeriesData;
import com.azure.ai.metricsadvisor.models.MetricFeedback;
import com.azure.ai.metricsadvisor.models.MetricSeriesData;
import com.azure.ai.metricsadvisor.models.MetricSeriesDefinition;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import java.time.OffsetDateTime;
import java.util.List;

@ServiceClient(builder=MetricsAdvisorClientBuilder.class)
public final class MetricsAdvisorClient {
    private final MetricsAdvisorAsyncClient client;

    MetricsAdvisorClient(MetricsAdvisorAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesDefinition> listMetricSeriesDefinitions(String metricId, OffsetDateTime activeSince) {
        return this.listMetricSeriesDefinitions(metricId, activeSince, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesDefinition> listMetricSeriesDefinitions(String metricId, OffsetDateTime activeSince, ListMetricSeriesDefinitionOptions options, Context context) {
        return new PagedIterable(this.client.listMetricSeriesDefinitions(metricId, activeSince, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesData> listMetricSeriesData(String metricId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listMetricSeriesData(metricId, seriesKeys, startTime, endTime, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesData> listMetricSeriesData(String metricId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        return new PagedIterable(this.client.listMetricSeriesData(metricId, seriesKeys, startTime, endTime, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EnrichmentStatus> listMetricEnrichmentStatus(String metricId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listMetricEnrichmentStatus(metricId, startTime, endTime, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EnrichmentStatus> listMetricEnrichmentStatus(String metricId, OffsetDateTime startTime, OffsetDateTime endTime, ListMetricEnrichmentStatusOptions options, Context context) {
        return new PagedIterable(this.client.listMetricEnrichmentStatus(metricId, startTime, endTime, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricEnrichedSeriesData> listMetricEnrichedSeriesData(String detectionConfigurationId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listMetricEnrichedSeriesData(detectionConfigurationId, seriesKeys, startTime, endTime, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricEnrichedSeriesData> listMetricEnrichedSeriesData(String detectionConfigurationId, List<DimensionKey> seriesKeys, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        return new PagedIterable(this.client.listMetricEnrichedSeriesData(detectionConfigurationId, seriesKeys, startTime, endTime, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataPointAnomaly> listAnomaliesForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listAnomaliesForDetectionConfig(detectionConfigurationId, startTime, endTime, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataPointAnomaly> listAnomaliesForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomaliesDetectedOptions options, Context context) {
        return new PagedIterable(this.client.listAnomaliesForDetectionConfig(detectionConfigurationId, startTime, endTime, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyIncident> listIncidentsForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listIncidentsForDetectionConfig(detectionConfigurationId, startTime, endTime, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyIncident> listIncidentsForDetectionConfig(String detectionConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListIncidentsDetectedOptions options, Context context) {
        return new PagedIterable(this.client.listIncidentsForDetectionConfig(detectionConfigurationId, startTime, endTime, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentRootCause> listIncidentRootCauses(String detectionConfigurationId, String incidentId) {
        return new PagedIterable(this.client.listIncidentRootCauses(detectionConfigurationId, incidentId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentRootCause> listIncidentRootCauses(String detectionConfigurationId, String incidentId, Context context) {
        return new PagedIterable(this.client.listIncidentRootCauses(detectionConfigurationId, incidentId, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentRootCause> listIncidentRootCauses(AnomalyIncident anomalyIncident) {
        return new PagedIterable(this.client.listIncidentRootCauses(anomalyIncident, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listAnomalyDimensionValues(String detectionConfigurationId, String dimensionName, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listAnomalyDimensionValues(detectionConfigurationId, dimensionName, startTime, endTime, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listAnomalyDimensionValues(String detectionConfigurationId, String dimensionName, OffsetDateTime startTime, OffsetDateTime endTime, ListAnomalyDimensionValuesOptions options, Context context) {
        return new PagedIterable(this.client.listAnomalyDimensionValues(detectionConfigurationId, dimensionName, startTime, endTime, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlert> listAlerts(String alertConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.listAlerts(alertConfigurationId, startTime, endTime, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlert> listAlerts(String alertConfigurationId, OffsetDateTime startTime, OffsetDateTime endTime, ListAlertOptions options, Context context) {
        return new PagedIterable(this.client.listAlerts(alertConfigurationId, startTime, endTime, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataPointAnomaly> listAnomaliesForAlert(String alertConfigurationId, String alertId) {
        return this.listAnomaliesForAlert(alertConfigurationId, alertId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataPointAnomaly> listAnomaliesForAlert(String alertConfigurationId, String alertId, ListAnomaliesAlertedOptions options, Context context) {
        return new PagedIterable(this.client.listAnomaliesForAlert(alertConfigurationId, alertId, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyIncident> listIncidentsForAlert(String alertConfigurationId, String alertId) {
        return this.listIncidentsForAlert(alertConfigurationId, alertId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyIncident> listIncidentsForAlert(String alertConfigurationId, String alertId, ListIncidentsAlertedOptions options, Context context) {
        return new PagedIterable(this.client.listIncidentsForAlert(alertConfigurationId, alertId, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricFeedback addFeedback(String metricId, MetricFeedback metricFeedback) {
        return (MetricFeedback)this.addFeedbackWithResponse(metricId, metricFeedback, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricFeedback> addFeedbackWithResponse(String metricId, MetricFeedback metricFeedback, Context context) {
        return (Response)this.client.addFeedbackWithResponse(metricId, metricFeedback, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricFeedback getFeedback(String feedbackId) {
        return (MetricFeedback)this.getFeedbackWithResponse(feedbackId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricFeedback> getFeedbackWithResponse(String feedbackId, Context context) {
        return (Response)this.client.getFeedbackWithResponse(feedbackId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricFeedback> listFeedback(String metricId) {
        return this.listFeedback(metricId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricFeedback> listFeedback(String metricId, ListMetricFeedbackOptions options, Context context) {
        return new PagedIterable(this.client.listFeedback(metricId, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listMetricDimensionValues(String metricId, String dimensionName) {
        return this.listMetricDimensionValues(metricId, dimensionName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listMetricDimensionValues(String metricId, String dimensionName, ListMetricDimensionValuesOptions options, Context context) {
        return new PagedIterable(this.client.listMetricDimensionValues(metricId, dimensionName, options, context == null ? Context.NONE : context));
    }
}

