/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration;

import com.azure.ai.metricsadvisor.MetricsAdvisorServiceVersion;
import com.azure.ai.metricsadvisor.administration.MetricsAdvisorAdministrationClientBuilder;
import com.azure.ai.metricsadvisor.administration.models.AnomalyAlertConfiguration;
import com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration;
import com.azure.ai.metricsadvisor.administration.models.DataFeed;
import com.azure.ai.metricsadvisor.administration.models.DataFeedGranularity;
import com.azure.ai.metricsadvisor.administration.models.DataFeedGranularityType;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionProgress;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionSettings;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionStatus;
import com.azure.ai.metricsadvisor.administration.models.DataFeedMissingDataPointFillSettings;
import com.azure.ai.metricsadvisor.administration.models.DataFeedMissingDataPointFillType;
import com.azure.ai.metricsadvisor.administration.models.DataFeedOptions;
import com.azure.ai.metricsadvisor.administration.models.DataFeedRollupSettings;
import com.azure.ai.metricsadvisor.administration.models.DataFeedSchema;
import com.azure.ai.metricsadvisor.administration.models.DataSourceCredentialEntity;
import com.azure.ai.metricsadvisor.administration.models.ListAnomalyAlertConfigsOptions;
import com.azure.ai.metricsadvisor.administration.models.ListCredentialEntityOptions;
import com.azure.ai.metricsadvisor.administration.models.ListDataFeedFilter;
import com.azure.ai.metricsadvisor.administration.models.ListDataFeedIngestionOptions;
import com.azure.ai.metricsadvisor.administration.models.ListDataFeedOptions;
import com.azure.ai.metricsadvisor.administration.models.ListDetectionConfigsOptions;
import com.azure.ai.metricsadvisor.administration.models.ListHookOptions;
import com.azure.ai.metricsadvisor.administration.models.NotificationHook;
import com.azure.ai.metricsadvisor.implementation.AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.CreateAnomalyAlertingConfigurationHeaders;
import com.azure.ai.metricsadvisor.implementation.models.CreateAnomalyDetectionConfigurationHeaders;
import com.azure.ai.metricsadvisor.implementation.models.CreateCredentialHeaders;
import com.azure.ai.metricsadvisor.implementation.models.CreateDataFeedHeaders;
import com.azure.ai.metricsadvisor.implementation.models.CreateHookHeaders;
import com.azure.ai.metricsadvisor.implementation.models.DataFeedDetail;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredential;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceType;
import com.azure.ai.metricsadvisor.implementation.models.EntityStatus;
import com.azure.ai.metricsadvisor.implementation.models.FillMissingPointType;
import com.azure.ai.metricsadvisor.implementation.models.Granularity;
import com.azure.ai.metricsadvisor.implementation.models.HookInfo;
import com.azure.ai.metricsadvisor.implementation.models.IngestionProgressResetOptions;
import com.azure.ai.metricsadvisor.implementation.models.IngestionStatusQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.NeedRollupEnum;
import com.azure.ai.metricsadvisor.implementation.models.RollUpMethod;
import com.azure.ai.metricsadvisor.implementation.models.ViewMode;
import com.azure.ai.metricsadvisor.implementation.util.AlertConfigurationTransforms;
import com.azure.ai.metricsadvisor.implementation.util.DataFeedTransforms;
import com.azure.ai.metricsadvisor.implementation.util.DataSourceCredentialEntityTransforms;
import com.azure.ai.metricsadvisor.implementation.util.DetectionConfigurationTransforms;
import com.azure.ai.metricsadvisor.implementation.util.HookTransforms;
import com.azure.ai.metricsadvisor.implementation.util.Utility;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MetricsAdvisorAdministrationClientBuilder.class, isAsync=true)
public final class MetricsAdvisorAdministrationAsyncClient {
    private static final String METRICS_ADVISOR_TRACING_NAMESPACE_VALUE = "Microsoft.CognitiveServices";
    private final ClientLogger logger = new ClientLogger(MetricsAdvisorAdministrationAsyncClient.class);
    private final AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl service;

    MetricsAdvisorAdministrationAsyncClient(AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl service, MetricsAdvisorServiceVersion serviceVersion) {
        this.service = service;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeed> createDataFeed(DataFeed dataFeed) {
        return this.createDataFeedWithResponse(dataFeed).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeed>> createDataFeedWithResponse(DataFeed dataFeed) {
        try {
            return FluxUtil.withContext(context -> this.createDataFeedWithResponse(dataFeed, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DataFeed>> createDataFeedWithResponse(DataFeed dataFeed, Context context) {
        Objects.requireNonNull(dataFeed, "'dataFeed' is required and cannot be null.");
        Objects.requireNonNull(dataFeed.getSource(), "'dataFeedSource' is required and cannot be null.");
        Objects.requireNonNull(dataFeed.getName(), "'dataFeedName' cannot be null or empty.");
        DataFeedSchema dataFeedSchema = dataFeed.getSchema();
        DataFeedGranularity dataFeedGranularity = dataFeed.getGranularity();
        DataFeedIngestionSettings dataFeedIngestionSettings = dataFeed.getIngestionSettings();
        if (dataFeedSchema == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'dataFeedSchema.metrics' cannot be null or empty."));
        }
        Objects.requireNonNull(dataFeedSchema.getMetrics(), "'dataFeedSchema.metrics' cannot be null or empty.");
        if (dataFeedGranularity == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'dataFeedGranularity.granularityType' is required and cannot be null."));
        }
        Objects.requireNonNull(dataFeedGranularity.getGranularityType(), "'dataFeedGranularity.granularityType' is required.");
        if (DataFeedGranularityType.CUSTOM.equals((Object)dataFeedGranularity.getGranularityType())) {
            Objects.requireNonNull(dataFeedGranularity.getCustomGranularityValue(), "'dataFeedGranularity.customGranularityValue' is required when granularity type is CUSTOM");
        }
        if (dataFeedIngestionSettings == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'dataFeedIngestionSettings.ingestionStartTime' is required and cannot be null."));
        }
        Objects.requireNonNull(dataFeedIngestionSettings.getIngestionStartTime(), "'dataFeedIngestionSettings.ingestionStartTime' is required and cannot be null.");
        DataFeedOptions finalDataFeedOptions = dataFeed.getOptions() == null ? new DataFeedOptions() : dataFeed.getOptions();
        DataFeedRollupSettings dataFeedRollupSettings = finalDataFeedOptions.getRollupSettings() == null ? new DataFeedRollupSettings() : finalDataFeedOptions.getRollupSettings();
        DataFeedMissingDataPointFillSettings dataFeedMissingDataPointFillSettings = finalDataFeedOptions.getMissingDataPointFillSettings() == null ? new DataFeedMissingDataPointFillSettings() : finalDataFeedOptions.getMissingDataPointFillSettings();
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.createDataFeedWithResponseAsync(DataFeedTransforms.toDataFeedDetailSource(dataFeed.getSource()).setDataFeedName(dataFeed.getName()).setDataFeedDescription(finalDataFeedOptions.getDescription()).setGranularityName(Granularity.fromString(dataFeedGranularity.getGranularityType() == null ? null : dataFeedGranularity.getGranularityType().toString())).setGranularityAmount(dataFeedGranularity.getCustomGranularityValue()).setDimension(DataFeedTransforms.toInnerDimensionsListForCreate(dataFeedSchema.getDimensions())).setMetrics(DataFeedTransforms.toInnerMetricsListForCreate(dataFeedSchema.getMetrics())).setTimestampColumn(dataFeedSchema.getTimestampColumn()).setDataStartFrom(dataFeedIngestionSettings.getIngestionStartTime()).setStartOffsetInSeconds(dataFeedIngestionSettings.getIngestionStartOffset() == null ? null : Long.valueOf(dataFeedIngestionSettings.getIngestionStartOffset().getSeconds())).setMaxConcurrency(dataFeedIngestionSettings.getDataSourceRequestConcurrency()).setStopRetryAfterInSeconds(dataFeedIngestionSettings.getStopRetryAfter() == null ? null : Long.valueOf(dataFeedIngestionSettings.getStopRetryAfter().getSeconds())).setMinRetryIntervalInSeconds(dataFeedIngestionSettings.getIngestionRetryDelay() == null ? null : Long.valueOf(dataFeedIngestionSettings.getIngestionRetryDelay().getSeconds())).setRollUpColumns(dataFeedRollupSettings.getAutoRollupGroupByColumnNames()).setRollUpMethod(RollUpMethod.fromString(dataFeedRollupSettings.getDataFeedAutoRollUpMethod() == null ? null : dataFeedRollupSettings.getDataFeedAutoRollUpMethod().toString())).setNeedRollup(NeedRollupEnum.fromString(dataFeedRollupSettings.getRollupType() == null ? null : dataFeedRollupSettings.getRollupType().toString())).setAllUpIdentification(dataFeedRollupSettings.getRollupIdentificationValue()).setFillMissingPointType(FillMissingPointType.fromString(dataFeedMissingDataPointFillSettings.getFillType() == null ? null : dataFeedMissingDataPointFillSettings.getFillType().toString())).setFillMissingPointValue(dataFeedMissingDataPointFillSettings.getCustomFillValue()).setViewMode(ViewMode.fromString(finalDataFeedOptions.getAccessMode() == null ? null : finalDataFeedOptions.getAccessMode().toString())).setViewers(finalDataFeedOptions.getViewers()).setAdmins(finalDataFeedOptions.getAdmins()).setActionLinkTemplate(finalDataFeedOptions.getActionLinkTemplate()), withTracing).flatMap(createDataFeedResponse -> {
            String dataFeedId = Utility.parseOperationId(((CreateDataFeedHeaders)createDataFeedResponse.getDeserializedHeaders()).getLocation());
            return this.getDataFeedWithResponse(dataFeedId);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeed> getDataFeed(String dataFeedId) {
        return this.getDataFeedWithResponse(dataFeedId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeed>> getDataFeedWithResponse(String dataFeedId) {
        try {
            return FluxUtil.withContext(context -> this.getDataFeedWithResponse(dataFeedId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DataFeed>> getDataFeedWithResponse(String dataFeedId, Context context) {
        Objects.requireNonNull(dataFeedId, "'dataFeedId' cannot be null.");
        return this.service.getDataFeedByIdWithResponseAsync(UUID.fromString(dataFeedId), context).map(response -> new SimpleResponse(response, (Object)DataFeedTransforms.fromInner((DataFeedDetail)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeed> updateDataFeed(DataFeed dataFeed) {
        return this.updateDataFeedWithResponse(dataFeed).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeed>> updateDataFeedWithResponse(DataFeed dataFeed) {
        try {
            return FluxUtil.withContext(context -> this.updateDataFeedWithResponse(dataFeed, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DataFeed>> updateDataFeedWithResponse(DataFeed dataFeed, Context context) {
        DataFeedIngestionSettings dataFeedIngestionSettings = dataFeed.getIngestionSettings();
        DataFeedOptions dataFeedOptions = dataFeed.getOptions() == null ? new DataFeedOptions() : dataFeed.getOptions();
        DataFeedRollupSettings dataFeedRollupSettings = dataFeedOptions.getRollupSettings() == null ? new DataFeedRollupSettings() : dataFeedOptions.getRollupSettings();
        DataFeedMissingDataPointFillSettings dataFeedMissingDataPointFillSettings = dataFeedOptions.getMissingDataPointFillSettings() == null ? new DataFeedMissingDataPointFillSettings() : dataFeedOptions.getMissingDataPointFillSettings();
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.updateDataFeedWithResponseAsync(UUID.fromString(dataFeed.getId()), DataFeedTransforms.toInnerForUpdate(dataFeed.getSource()).setDataFeedName(dataFeed.getName()).setDataFeedDescription(dataFeedOptions.getDescription()).setTimestampColumn(dataFeed.getSchema() == null ? null : dataFeed.getSchema().getTimestampColumn()).setDataStartFrom(dataFeed.getIngestionSettings().getIngestionStartTime()).setStartOffsetInSeconds(dataFeedIngestionSettings.getIngestionStartOffset() == null ? null : Long.valueOf(dataFeedIngestionSettings.getIngestionStartOffset().getSeconds())).setMaxConcurrency(dataFeedIngestionSettings.getDataSourceRequestConcurrency()).setStopRetryAfterInSeconds(dataFeedIngestionSettings.getStopRetryAfter() == null ? null : Long.valueOf(dataFeedIngestionSettings.getStopRetryAfter().getSeconds())).setMinRetryIntervalInSeconds(dataFeedIngestionSettings.getIngestionRetryDelay() == null ? null : Long.valueOf(dataFeedIngestionSettings.getIngestionRetryDelay().getSeconds())).setNeedRollup(dataFeedRollupSettings.getRollupType() != null ? NeedRollupEnum.fromString(dataFeedRollupSettings.getRollupType().toString()) : null).setRollUpColumns(dataFeedRollupSettings.getAutoRollupGroupByColumnNames()).setRollUpMethod(dataFeedRollupSettings.getDataFeedAutoRollUpMethod() != null ? RollUpMethod.fromString(dataFeedRollupSettings.getDataFeedAutoRollUpMethod().toString()) : null).setAllUpIdentification(dataFeedRollupSettings.getRollupIdentificationValue()).setFillMissingPointType(dataFeedMissingDataPointFillSettings.getFillType() != null ? FillMissingPointType.fromString(dataFeedMissingDataPointFillSettings.getFillType().toString()) : null).setFillMissingPointValue(dataFeedMissingDataPointFillSettings.getFillType() == DataFeedMissingDataPointFillType.CUSTOM_VALUE ? dataFeedMissingDataPointFillSettings.getCustomFillValue() : null).setViewMode(dataFeedOptions.getAccessMode() != null ? ViewMode.fromString(dataFeedOptions.getAccessMode().toString()) : null).setViewers(dataFeedOptions.getViewers()).setAdmins(dataFeedOptions.getAdmins()).setStatus(dataFeed.getStatus() != null ? EntityStatus.fromString(dataFeed.getStatus().toString()) : null).setActionLinkTemplate(dataFeedOptions.getActionLinkTemplate()), withTracing).flatMap(updatedDataFeedResponse -> this.getDataFeedWithResponse(dataFeed.getId()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFeed(String dataFeedId) {
        return this.deleteDataFeedWithResponse(dataFeedId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFeedWithResponse(String dataFeedId) {
        try {
            return FluxUtil.withContext(context -> this.deleteDataFeedWithResponse(dataFeedId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteDataFeedWithResponse(String dataFeedId, Context context) {
        Objects.requireNonNull(dataFeedId, "'dataFeedId' cannot be null.");
        return this.service.deleteDataFeedWithResponseAsync(UUID.fromString(dataFeedId), context).map(response -> new SimpleResponse(response, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFeed> listDataFeeds() {
        return this.listDataFeeds(new ListDataFeedOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFeed> listDataFeeds(ListDataFeedOptions listDataFeedOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDataFeedsSinglePageAsync(listDataFeedOptions, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDataFeedsNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DataFeed> listDataFeeds(ListDataFeedOptions options, Context context) {
        return new PagedFlux(() -> this.listDataFeedsSinglePageAsync(options, context), continuationToken -> this.listDataFeedsNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<DataFeed>> listDataFeedsSinglePageAsync(ListDataFeedOptions options, Context context) {
        options = options != null ? options : new ListDataFeedOptions();
        ListDataFeedFilter dataFeedFilter = options.getListDataFeedFilter() != null ? options.getListDataFeedFilter() : new ListDataFeedFilter();
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.listDataFeedsSinglePageAsync(dataFeedFilter.getName(), dataFeedFilter.getSourceType() != null ? DataSourceType.fromString(dataFeedFilter.getSourceType().toString()) : null, dataFeedFilter.getGranularityType() != null ? Granularity.fromString(dataFeedFilter.getGranularityType().toString()) : null, dataFeedFilter.getStatus() != null ? EntityStatus.fromString(dataFeedFilter.getStatus().toString()) : null, dataFeedFilter.getCreator(), options.getSkip(), options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing information for all data feeds")).doOnSuccess(response -> this.logger.info("Listed data feeds {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list all data feeds information - {}", new Object[]{error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(DataFeedTransforms::fromInner).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<DataFeed>> listDataFeedsNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.listDataFeedsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(DataFeedTransforms::fromInner).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFeedIngestionStatus> listDataFeedIngestionStatus(String dataFeedId, ListDataFeedIngestionOptions listDataFeedIngestionOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDataFeedIngestionStatusSinglePageAsync(dataFeedId, listDataFeedIngestionOptions, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDataFeedIngestionStatusNextPageAsync((String)continuationToken, listDataFeedIngestionOptions, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DataFeedIngestionStatus> listDataFeedIngestionStatus(String dataFeedId, ListDataFeedIngestionOptions options, Context context) {
        return new PagedFlux(() -> this.listDataFeedIngestionStatusSinglePageAsync(dataFeedId, options, context), continuationToken -> this.listDataFeedIngestionStatusNextPageAsync((String)continuationToken, options, context));
    }

    private Mono<PagedResponse<DataFeedIngestionStatus>> listDataFeedIngestionStatusSinglePageAsync(String dataFeedId, ListDataFeedIngestionOptions options, Context context) {
        Objects.requireNonNull(dataFeedId, "'dataFeedId' is required.");
        Objects.requireNonNull(options, "'options' is required.");
        Objects.requireNonNull(options.getStartTime(), "'options.startTime' is required.");
        Objects.requireNonNull(options.getEndTime(), "'options.endTime' is required.");
        IngestionStatusQueryOptions queryOptions = new IngestionStatusQueryOptions().setStartTime(options.getStartTime()).setEndTime(options.getEndTime());
        return this.service.getDataFeedIngestionStatusSinglePageAsync(UUID.fromString(dataFeedId), queryOptions, options.getSkip(), options.getMaxPageSize(), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Listing ingestion status for data feed")).doOnSuccess(response -> this.logger.info("Listed ingestion status {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to ingestion status for data feed", new Object[]{error}));
    }

    private Mono<PagedResponse<DataFeedIngestionStatus>> listDataFeedIngestionStatusNextPageAsync(String nextPageLink, ListDataFeedIngestionOptions options, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        IngestionStatusQueryOptions queryOptions = new IngestionStatusQueryOptions().setStartTime(options.getStartTime()).setEndTime(options.getEndTime());
        return this.service.getDataFeedIngestionStatusNextSinglePageAsync(nextPageLink, queryOptions, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {} {}", new Object[]{nextPageLink, response})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> refreshDataFeedIngestion(String dataFeedId, OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.refreshDataFeedIngestionWithResponse(dataFeedId, startTime, endTime).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> refreshDataFeedIngestionWithResponse(String dataFeedId, OffsetDateTime startTime, OffsetDateTime endTime) {
        try {
            return FluxUtil.withContext(context -> this.refreshDataFeedIngestionWithResponse(dataFeedId, startTime, endTime, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<Void>> refreshDataFeedIngestionWithResponse(String dataFeedId, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        Objects.requireNonNull(dataFeedId, "'dataFeedId' is required.");
        Objects.requireNonNull(startTime, "'startTime' is required.");
        Objects.requireNonNull(endTime, "'endTime' is required.");
        return this.service.resetDataFeedIngestionStatusWithResponseAsync(UUID.fromString(dataFeedId), new IngestionProgressResetOptions().setStartTime(startTime).setEndTime(endTime), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Resetting ingestion status for the data feed")).doOnSuccess(response -> this.logger.info("Ingestion status got reset {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to reset ingestion status for the data feed", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeedIngestionProgress> getDataFeedIngestionProgress(String dataFeedId) {
        return this.getDataFeedIngestionProgressWithResponse(dataFeedId, Context.NONE).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeedIngestionProgress>> getDataFeedIngestionProgressWithResponse(String dataFeedId) {
        try {
            return FluxUtil.withContext(context -> this.getDataFeedIngestionProgressWithResponse(dataFeedId, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<DataFeedIngestionProgress>> getDataFeedIngestionProgressWithResponse(String dataFeedId, Context context) {
        Objects.requireNonNull(dataFeedId, "'dataFeedId' is required.");
        return this.service.getIngestionProgressWithResponseAsync(UUID.fromString(dataFeedId), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Retrieving ingestion progress for metric")).doOnSuccess(response -> this.logger.info("Retrieved ingestion progress {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to retrieve ingestion progress for metric", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> createDetectionConfig(String metricId, AnomalyDetectionConfiguration detectionConfiguration) {
        return this.createDetectionConfigWithResponse(metricId, detectionConfiguration).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> createDetectionConfigWithResponse(String metricId, AnomalyDetectionConfiguration detectionConfiguration) {
        try {
            return FluxUtil.withContext(context -> this.createDetectionConfigWithResponse(metricId, detectionConfiguration, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<AnomalyDetectionConfiguration>> createDetectionConfigWithResponse(String metricId, AnomalyDetectionConfiguration detectionConfiguration, Context context) {
        Objects.requireNonNull(metricId, "metricId is required");
        Objects.requireNonNull(detectionConfiguration, "detectionConfiguration is required");
        com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfiguration innerDetectionConfiguration = DetectionConfigurationTransforms.toInnerForCreate(this.logger, metricId, detectionConfiguration);
        return this.service.createAnomalyDetectionConfigurationWithResponseAsync(innerDetectionConfiguration, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Creating AnomalyDetectionConfiguration")).doOnSuccess(response -> this.logger.info("Created AnomalyDetectionConfiguration")).doOnError(error -> this.logger.warning("Failed to create AnomalyDetectionConfiguration", new Object[]{error})).flatMap(response -> {
            String configurationId = Utility.parseOperationId(((CreateAnomalyDetectionConfigurationHeaders)response.getDeserializedHeaders()).getLocation());
            return this.getDetectionConfigWithResponse(configurationId, context).map(configurationResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((AnomalyDetectionConfiguration)configurationResponse.getValue()), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> getDetectionConfig(String detectionConfigurationId) {
        return this.getDetectionConfigWithResponse(detectionConfigurationId).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> getDetectionConfigWithResponse(String detectionConfigurationId) {
        try {
            return FluxUtil.withContext(context -> this.getDetectionConfigWithResponse(detectionConfigurationId, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<AnomalyDetectionConfiguration>> getDetectionConfigWithResponse(String detectionConfigurationId, Context context) {
        Objects.requireNonNull(detectionConfigurationId, "detectionConfigurationId is required.");
        return this.service.getAnomalyDetectionConfigurationWithResponseAsync(UUID.fromString(detectionConfigurationId), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving AnomalyDetectionConfiguration - {}", new Object[]{detectionConfigurationId})).doOnSuccess(response -> this.logger.info("Retrieved AnomalyDetectionConfiguration - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to retrieve AnomalyDetectionConfiguration - {}", new Object[]{detectionConfigurationId, error})).map(response -> {
            AnomalyDetectionConfiguration configuration = DetectionConfigurationTransforms.fromInner((com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfiguration)response.getValue());
            return new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)configuration, null);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> updateDetectionConfig(AnomalyDetectionConfiguration detectionConfiguration) {
        return this.updateDetectionConfigWithResponse(detectionConfiguration).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> updateDetectionConfigWithResponse(AnomalyDetectionConfiguration detectionConfiguration) {
        try {
            return FluxUtil.withContext(context -> this.updateDetectionConfigWithResponse(detectionConfiguration, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<AnomalyDetectionConfiguration>> updateDetectionConfigWithResponse(AnomalyDetectionConfiguration detectionConfiguration, Context context) {
        Objects.requireNonNull(detectionConfiguration, "detectionConfiguration is required");
        Objects.requireNonNull(detectionConfiguration.getId(), "detectionConfiguration.id is required");
        AnomalyDetectionConfigurationPatch innerDetectionConfigurationPatch = DetectionConfigurationTransforms.toInnerForUpdate(this.logger, detectionConfiguration);
        return this.service.updateAnomalyDetectionConfigurationWithResponseAsync(UUID.fromString(detectionConfiguration.getId()), innerDetectionConfigurationPatch, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Updating AnomalyDetectionConfiguration")).doOnSuccess(response -> this.logger.info("Updated AnomalyDetectionConfiguration")).doOnError(error -> this.logger.warning("Failed to update AnomalyDetectionConfiguration", new Object[]{error})).flatMap(response -> this.getDetectionConfigWithResponse(detectionConfiguration.getId(), context).map(configurationResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((AnomalyDetectionConfiguration)configurationResponse.getValue()), null)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDetectionConfig(String detectionConfigurationId) {
        return this.deleteDetectionConfigWithResponse(detectionConfigurationId).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDetectionConfigWithResponse(String detectionConfigurationId) {
        try {
            return FluxUtil.withContext(context -> this.deleteDetectionConfigWithResponse(detectionConfigurationId, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<Void>> deleteDetectionConfigWithResponse(String detectionConfigurationId, Context context) {
        Objects.requireNonNull(detectionConfigurationId, "detectionConfigurationId is required.");
        return this.service.deleteHookWithResponseAsync(UUID.fromString(detectionConfigurationId), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Deleting MetricAnomalyDetectionConfiguration")).doOnSuccess(response -> this.logger.info("Deleted MetricAnomalyDetectionConfiguration")).doOnError(error -> this.logger.warning("Failed to delete MetricAnomalyDetectionConfiguration", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyDetectionConfiguration> listDetectionConfigs(String metricId) {
        return this.listDetectionConfigs(metricId, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyDetectionConfiguration> listDetectionConfigs(String metricId, ListDetectionConfigsOptions listDetectionConfigsOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listAnomalyDetectionConfigsSinglePageAsync(metricId, listDetectionConfigsOptions, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listAnomalyDetectionConfigsNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<AnomalyDetectionConfiguration> listDetectionConfigs(String metricId, ListDetectionConfigsOptions options, Context context) {
        return new PagedFlux(() -> this.listAnomalyDetectionConfigsSinglePageAsync(metricId, options, context), continuationToken -> this.listAnomalyDetectionConfigsNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<AnomalyDetectionConfiguration>> listAnomalyDetectionConfigsSinglePageAsync(String metricId, ListDetectionConfigsOptions options, Context context) {
        if (options == null) {
            options = new ListDetectionConfigsOptions();
        }
        return this.service.getAnomalyDetectionConfigurationsByMetricSinglePageAsync(UUID.fromString(metricId), options.getSkip(), options.getMaxPageSize(), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Listing MetricAnomalyDetectionConfigs")).doOnSuccess(response -> this.logger.info("Listed MetricAnomalyDetectionConfigs {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the MetricAnomalyDetectionConfigs", new Object[]{error})).map(response -> DetectionConfigurationTransforms.fromInnerPagedResponse((PagedResponse<com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfiguration>)response));
    }

    private Mono<PagedResponse<AnomalyDetectionConfiguration>> listAnomalyDetectionConfigsNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync(nextPageLink, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {} {}", new Object[]{nextPageLink, response})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(response -> DetectionConfigurationTransforms.fromInnerPagedResponse((PagedResponse<com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfiguration>)response));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotificationHook> createHook(NotificationHook notificationHook) {
        return this.createHookWithResponse(notificationHook).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotificationHook>> createHookWithResponse(NotificationHook notificationHook) {
        try {
            return FluxUtil.withContext(context -> this.createHookWithResponse(notificationHook, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<NotificationHook>> createHookWithResponse(NotificationHook notificationHook, Context context) {
        Objects.requireNonNull(notificationHook, "'notificationHook' cannot be null.");
        return this.service.createHookWithResponseAsync(HookTransforms.toInnerForCreate(this.logger, notificationHook), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Creating NotificationHook")).doOnSuccess(response -> this.logger.info("Created NotificationHook {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to create notificationHook", new Object[]{error})).flatMap(response -> {
            String hookUri = ((CreateHookHeaders)response.getDeserializedHeaders()).getLocation();
            String hookId = Utility.parseOperationId(hookUri);
            return this.getHookWithResponse(hookId, context).map(hookResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((NotificationHook)hookResponse.getValue()), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotificationHook> getHook(String hookId) {
        return this.getHookWithResponse(hookId).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotificationHook>> getHookWithResponse(String hookId) {
        try {
            return FluxUtil.withContext(context -> this.getHookWithResponse(hookId, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<NotificationHook>> getHookWithResponse(String hookId, Context context) {
        Objects.requireNonNull(hookId, "hookId is required.");
        return this.service.getHookWithResponseAsync(UUID.fromString(hookId), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Retrieving NotificationHook")).doOnSuccess(response -> this.logger.info("Retrieved NotificationHook {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to retrieve hook", new Object[]{error})).map(innerResponse -> new ResponseBase(innerResponse.getRequest(), innerResponse.getStatusCode(), innerResponse.getHeaders(), (Object)HookTransforms.fromInner(this.logger, (HookInfo)innerResponse.getValue()), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotificationHook> updateHook(NotificationHook notificationHook) {
        return this.updateHookWithResponse(notificationHook).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotificationHook>> updateHookWithResponse(NotificationHook notificationHook) {
        try {
            return FluxUtil.withContext(context -> this.updateHookWithResponse(notificationHook, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<NotificationHook>> updateHookWithResponse(NotificationHook notificationHook, Context context) {
        Objects.requireNonNull(notificationHook, "'notificationHook' cannot be null.");
        Objects.requireNonNull(notificationHook.getId(), "'notificationHook.id' cannot be null.");
        return this.service.updateHookWithResponseAsync(UUID.fromString(notificationHook.getId()), HookTransforms.toInnerForUpdate(this.logger, notificationHook), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Updating NotificationHook")).doOnSuccess(response -> this.logger.info("Updated NotificationHook {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to update notificationHook", new Object[]{error})).flatMap(response -> this.getHookWithResponse(notificationHook.getId(), context).map(hookResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((NotificationHook)hookResponse.getValue()), null)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteHook(String hookId) {
        return this.deleteHookWithResponse(hookId).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHookWithResponse(String hookId) {
        try {
            return FluxUtil.withContext(context -> this.deleteHookWithResponse(hookId, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<Void>> deleteHookWithResponse(String hookId, Context context) {
        Objects.requireNonNull(hookId, "hookId is required.");
        return this.service.deleteHookWithResponseAsync(UUID.fromString(hookId), context).doOnRequest(ignoredValue -> this.logger.info("Deleting NotificationHook")).doOnSuccess(response -> this.logger.info("Deleted NotificationHook")).doOnError(error -> this.logger.warning("Failed to delete hook", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotificationHook> listHooks() {
        return this.listHooks(new ListHookOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotificationHook> listHooks(ListHookOptions listHookOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listHooksSinglePageAsync(listHookOptions, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listHooksNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<NotificationHook> listHooks(ListHookOptions options, Context context) {
        return new PagedFlux(() -> this.listHooksSinglePageAsync(options, context), continuationToken -> this.listHooksNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<NotificationHook>> listHooksSinglePageAsync(ListHookOptions options, Context context) {
        return this.service.listHooksSinglePageAsync(options != null ? options.getHookNameFilter() : null, options != null ? options.getSkip() : null, options != null ? options.getMaxPageSize() : null, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Listing hooks")).doOnSuccess(response -> this.logger.info("Listed hooks {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the hooks", new Object[]{error})).map(response -> HookTransforms.fromInnerPagedResponse(this.logger, (PagedResponse<HookInfo>)response));
    }

    private Mono<PagedResponse<NotificationHook>> listHooksNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.listHooksNextSinglePageAsync(nextPageLink, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {} {}", new Object[]{nextPageLink, response})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(response -> HookTransforms.fromInnerPagedResponse(this.logger, (PagedResponse<HookInfo>)response));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyAlertConfiguration> createAlertConfig(AnomalyAlertConfiguration alertConfiguration) {
        return this.createAlertConfigWithResponse(alertConfiguration).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertConfiguration>> createAlertConfigWithResponse(AnomalyAlertConfiguration alertConfiguration) {
        try {
            return FluxUtil.withContext(context -> this.createAlertConfigWithResponse(alertConfiguration, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AnomalyAlertConfiguration>> createAlertConfigWithResponse(AnomalyAlertConfiguration alertConfiguration, Context context) {
        Objects.requireNonNull(alertConfiguration, "'alertConfiguration' is required.");
        if (CoreUtils.isNullOrEmpty(alertConfiguration.getMetricAlertConfigurations())) {
            Objects.requireNonNull("'alertConfiguration.metricAnomalyAlertConfigurations' is required");
        }
        if (alertConfiguration.getCrossMetricsOperator() == null && alertConfiguration.getMetricAlertConfigurations().size() > 1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("crossMetricsOperator is required when there are more than one metric level alert configuration."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        AnomalyAlertingConfiguration innerAlertConfiguration = AlertConfigurationTransforms.toInnerForCreate(alertConfiguration);
        return this.service.createAnomalyAlertingConfigurationWithResponseAsync(innerAlertConfiguration, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Creating AnomalyAlertConfiguration - {}", new Object[]{innerAlertConfiguration})).doOnSuccess(response -> this.logger.info("Created AnomalyAlertConfiguration - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to create AnomalyAlertConfiguration - {}", new Object[]{innerAlertConfiguration, error})).flatMap(response -> {
            String configurationId = Utility.parseOperationId(((CreateAnomalyAlertingConfigurationHeaders)response.getDeserializedHeaders()).getLocation());
            return this.getAlertConfigWithResponse(configurationId, context).map(getResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((AnomalyAlertConfiguration)getResponse.getValue()), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyAlertConfiguration> getAlertConfig(String alertConfigurationId) {
        return this.getAlertConfigWithResponse(alertConfigurationId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertConfiguration>> getAlertConfigWithResponse(String alertConfigurationId) {
        try {
            return FluxUtil.withContext(context -> this.getAlertConfigWithResponse(alertConfigurationId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AnomalyAlertConfiguration>> getAlertConfigWithResponse(String alertConfigurationId, Context context) {
        Objects.requireNonNull(alertConfigurationId, "'alertConfigurationId' is required.");
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.getAnomalyAlertingConfigurationWithResponseAsync(UUID.fromString(alertConfigurationId), withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving AnomalyDetectionConfiguration - {}", new Object[]{alertConfigurationId})).doOnSuccess(response -> this.logger.info("Retrieved AnomalyDetectionConfiguration - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to retrieve AnomalyDetectionConfiguration - {}", new Object[]{alertConfigurationId, error})).map(response -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)AlertConfigurationTransforms.fromInner((AnomalyAlertingConfiguration)response.getValue()), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyAlertConfiguration> updateAlertConfig(AnomalyAlertConfiguration alertConfiguration) {
        return this.updateAlertConfigWithResponse(alertConfiguration).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertConfiguration>> updateAlertConfigWithResponse(AnomalyAlertConfiguration alertConfiguration) {
        try {
            return FluxUtil.withContext(context -> this.updateAlertConfigWithResponse(alertConfiguration, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AnomalyAlertConfiguration>> updateAlertConfigWithResponse(AnomalyAlertConfiguration alertConfiguration, Context context) {
        Objects.requireNonNull(alertConfiguration, "'alertConfiguration' is required");
        if (CoreUtils.isNullOrEmpty(alertConfiguration.getMetricAlertConfigurations())) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'alertConfiguration.metricAnomalyAlertConfigurations' is required and cannot be empty"));
        }
        AnomalyAlertingConfigurationPatch innerAlertConfiguration = AlertConfigurationTransforms.toInnerForUpdate(alertConfiguration);
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.updateAnomalyAlertingConfigurationWithResponseAsync(UUID.fromString(alertConfiguration.getId()), innerAlertConfiguration, withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Updating AnomalyAlertConfiguration - {}", new Object[]{innerAlertConfiguration})).doOnSuccess(response -> this.logger.info("Updated AnomalyAlertConfiguration - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to update AnomalyAlertConfiguration - {}", new Object[]{innerAlertConfiguration, error})).flatMap(response -> this.getAlertConfigWithResponse(alertConfiguration.getId(), context).map(getResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((AnomalyAlertConfiguration)getResponse.getValue()), null)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAlertConfig(String alertConfigurationId) {
        return this.deleteAlertConfigWithResponse(alertConfigurationId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAlertConfigWithResponse(String alertConfigurationId) {
        try {
            return FluxUtil.withContext(context -> this.deleteAlertConfigWithResponse(alertConfigurationId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteAlertConfigWithResponse(String alertConfigurationId, Context context) {
        Objects.requireNonNull(alertConfigurationId, "'alertConfigurationId' is required.");
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.deleteAnomalyAlertingConfigurationWithResponseAsync(UUID.fromString(alertConfigurationId), withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Deleting AnomalyAlertConfiguration - {}", new Object[]{alertConfigurationId})).doOnSuccess(response -> this.logger.info("Deleted AnomalyAlertConfiguration - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to delete AnomalyAlertConfiguration - {}", new Object[]{alertConfigurationId, error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlertConfiguration> listAlertConfigs(String detectionConfigurationId, ListAnomalyAlertConfigsOptions listAnomalyAlertConfigsOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listAnomalyAlertConfigsSinglePageAsync(detectionConfigurationId, listAnomalyAlertConfigsOptions, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listAnomalyAlertConfigsNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<AnomalyAlertConfiguration> listAlertConfigs(String detectionConfigurationId, ListAnomalyAlertConfigsOptions options, Context context) {
        return new PagedFlux(() -> this.listAnomalyAlertConfigsSinglePageAsync(detectionConfigurationId, options, context), continuationToken -> this.listAnomalyAlertConfigsNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<AnomalyAlertConfiguration>> listAnomalyAlertConfigsSinglePageAsync(String detectionConfigurationId, ListAnomalyAlertConfigsOptions options, Context context) {
        Objects.requireNonNull(detectionConfigurationId, "'detectionConfigurationId' is required.");
        if (options == null) {
            options = new ListAnomalyAlertConfigsOptions();
        }
        return this.service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(UUID.fromString(detectionConfigurationId), options.getSkip(), options.getMaxPageSize(), context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Listing AnomalyAlertConfigs")).doOnSuccess(response -> this.logger.info("Listed AnomalyAlertConfigs {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list the AnomalyAlertConfigs", new Object[]{error})).map(response -> AlertConfigurationTransforms.fromInnerPagedResponse((PagedResponse<AnomalyAlertingConfiguration>)response));
    }

    private Mono<PagedResponse<AnomalyAlertConfiguration>> listAnomalyAlertConfigsNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync(nextPageLink, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {} {}", new Object[]{nextPageLink, response})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(response -> AlertConfigurationTransforms.fromInnerPagedResponse((PagedResponse<AnomalyAlertingConfiguration>)response));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataSourceCredentialEntity> createDataSourceCredential(DataSourceCredentialEntity dataSourceCredential) {
        return this.createDataSourceCredentialWithResponse(dataSourceCredential).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataSourceCredentialEntity>> createDataSourceCredentialWithResponse(DataSourceCredentialEntity dataSourceCredential) {
        try {
            return FluxUtil.withContext(context -> this.createDataSourceCredentialWithResponse(dataSourceCredential, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<DataSourceCredentialEntity>> createDataSourceCredentialWithResponse(DataSourceCredentialEntity dataSourceCredential, Context context) {
        Objects.requireNonNull(dataSourceCredential, "dataSourceCredential is required");
        DataSourceCredential innerDataSourceCredential = DataSourceCredentialEntityTransforms.toInnerForCreate(dataSourceCredential);
        return this.service.createCredentialWithResponseAsync(innerDataSourceCredential, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Creating DataSourceCredentialEntity")).doOnSuccess(response -> this.logger.info("Created DataSourceCredentialEntity")).doOnError(error -> this.logger.warning("Failed to create DataSourceCredentialEntity", new Object[]{error})).flatMap(response -> {
            String credentialId = Utility.parseOperationId(((CreateCredentialHeaders)response.getDeserializedHeaders()).getLocation());
            return this.getDataSourceCredentialWithResponse(credentialId, context).map(configurationResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((DataSourceCredentialEntity)configurationResponse.getValue()), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataSourceCredentialEntity> updateDataSourceCredential(DataSourceCredentialEntity dataSourceCredential) {
        return this.updateDataSourceCredentialWithResponse(dataSourceCredential).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataSourceCredentialEntity>> updateDataSourceCredentialWithResponse(DataSourceCredentialEntity dataSourceCredential) {
        try {
            return FluxUtil.withContext(context -> this.updateDataSourceCredentialWithResponse(dataSourceCredential, (Context)context));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<DataSourceCredentialEntity>> updateDataSourceCredentialWithResponse(DataSourceCredentialEntity dataSourceCredential, Context context) {
        Objects.requireNonNull(dataSourceCredential, "dataSourceCredential is required");
        DataSourceCredentialPatch innerDataSourceCredential = DataSourceCredentialEntityTransforms.toInnerForUpdate(dataSourceCredential);
        return this.service.updateCredentialWithResponseAsync(UUID.fromString(dataSourceCredential.getId()), innerDataSourceCredential, context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Updating DataSourceCredentialEntity")).doOnSuccess(response -> this.logger.info("Updated DataSourceCredentialEntity")).doOnError(error -> this.logger.warning("Failed to update DataSourceCredentialEntity", new Object[]{error})).flatMap(response -> this.getDataSourceCredentialWithResponse(dataSourceCredential.getId(), context).map(configurationResponse -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((DataSourceCredentialEntity)configurationResponse.getValue()), null)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataSourceCredentialEntity> getDataSourceCredential(String credentialId) {
        return this.getDataSourceCredentialWithResponse(credentialId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataSourceCredentialEntity>> getDataSourceCredentialWithResponse(String credentialId) {
        try {
            return FluxUtil.withContext(context -> this.getDataSourceCredentialWithResponse(credentialId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DataSourceCredentialEntity>> getDataSourceCredentialWithResponse(String credentialId, Context context) {
        Objects.requireNonNull(credentialId, "'credentialId' cannot be null.");
        return this.service.getCredentialWithResponseAsync(UUID.fromString(credentialId), context).map(response -> new SimpleResponse(response, (Object)DataSourceCredentialEntityTransforms.fromInner((DataSourceCredential)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataSourceCredential(String credentialId) {
        return this.deleteDataSourceCredentialWithResponse(credentialId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataSourceCredentialWithResponse(String credentialId) {
        try {
            return FluxUtil.withContext(context -> this.deleteDataSourceCredentialWithResponse(credentialId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteDataSourceCredentialWithResponse(String credentialId, Context context) {
        Objects.requireNonNull(credentialId, "'credentialId' is required.");
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.deleteCredentialWithResponseAsync(UUID.fromString(credentialId), withTracing).doOnSubscribe(ignoredValue -> this.logger.info("Deleting deleteDataSourceCredentialEntity - {}", new Object[]{credentialId})).doOnSuccess(response -> this.logger.info("Deleted deleteDataSourceCredentialEntity - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to delete deleteDataSourceCredentialEntity - {}", new Object[]{credentialId, error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataSourceCredentialEntity> listDataSourceCredentials() {
        return this.listDataSourceCredentials(new ListCredentialEntityOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataSourceCredentialEntity> listDataSourceCredentials(ListCredentialEntityOptions listCredentialEntityOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listCredentialEntitiesSinglePageAsync(listCredentialEntityOptions, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listCredentialEntitiesSNextPageAsync((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DataSourceCredentialEntity> listDataSourceCredentials(ListCredentialEntityOptions options, Context context) {
        return new PagedFlux(() -> this.listCredentialEntitiesSinglePageAsync(options, context), continuationToken -> this.listCredentialEntitiesSNextPageAsync((String)continuationToken, context));
    }

    private Mono<PagedResponse<DataSourceCredentialEntity>> listCredentialEntitiesSinglePageAsync(ListCredentialEntityOptions options, Context context) {
        options = options != null ? options : new ListCredentialEntityOptions();
        Context withTracing = context.addData((Object)"az.namespace", (Object)METRICS_ADVISOR_TRACING_NAMESPACE_VALUE);
        return this.service.listCredentialsSinglePageAsync(options.getSkip(), options.getMaxPageSize(), withTracing).doOnRequest(ignoredValue -> this.logger.info("Listing information for all data source credentials")).doOnSuccess(response -> this.logger.info("Listed data source credentials {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to list all data source credential information - {}", new Object[]{error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(DataSourceCredentialEntityTransforms::fromInner).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<DataSourceCredentialEntity>> listCredentialEntitiesSNextPageAsync(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.listCredentialsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(DataSourceCredentialEntityTransforms::fromInner).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }
}

