/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration;

import com.azure.ai.metricsadvisor.administration.MetricsAdvisorAdministrationAsyncClient;
import com.azure.ai.metricsadvisor.administration.MetricsAdvisorAdministrationClientBuilder;
import com.azure.ai.metricsadvisor.administration.models.AnomalyAlertConfiguration;
import com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration;
import com.azure.ai.metricsadvisor.administration.models.DataFeed;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionProgress;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionStatus;
import com.azure.ai.metricsadvisor.administration.models.DataSourceCredentialEntity;
import com.azure.ai.metricsadvisor.administration.models.ListAnomalyAlertConfigsOptions;
import com.azure.ai.metricsadvisor.administration.models.ListCredentialEntityOptions;
import com.azure.ai.metricsadvisor.administration.models.ListDataFeedIngestionOptions;
import com.azure.ai.metricsadvisor.administration.models.ListDataFeedOptions;
import com.azure.ai.metricsadvisor.administration.models.ListDetectionConfigsOptions;
import com.azure.ai.metricsadvisor.administration.models.ListHookOptions;
import com.azure.ai.metricsadvisor.administration.models.NotificationHook;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import java.time.OffsetDateTime;

@ServiceClient(builder=MetricsAdvisorAdministrationClientBuilder.class)
public final class MetricsAdvisorAdministrationClient {
    final MetricsAdvisorAdministrationAsyncClient client;

    MetricsAdvisorAdministrationClient(MetricsAdvisorAdministrationAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFeed createDataFeed(DataFeed dataFeed) {
        return (DataFeed)this.createDataFeedWithResponse(dataFeed, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFeed> createDataFeedWithResponse(DataFeed dataFeed, Context context) {
        return (Response)this.client.createDataFeedWithResponse(dataFeed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFeed getDataFeed(String dataFeedId) {
        return (DataFeed)this.getDataFeedWithResponse(dataFeedId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFeed> getDataFeedWithResponse(String dataFeedId, Context context) {
        return (Response)this.client.getDataFeedWithResponse(dataFeedId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFeed updateDataFeed(DataFeed dataFeed) {
        return (DataFeed)this.updateDataFeedWithResponse(dataFeed, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFeed> updateDataFeedWithResponse(DataFeed dataFeed, Context context) {
        return (Response)this.client.updateDataFeedWithResponse(dataFeed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataFeed(String dataFeedId) {
        this.deleteDataFeedWithResponse(dataFeedId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataFeedWithResponse(String dataFeedId, Context context) {
        return (Response)this.client.deleteDataFeedWithResponse(dataFeedId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeed> listDataFeeds() {
        return this.listDataFeeds(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeed> listDataFeeds(ListDataFeedOptions options, Context context) {
        return new PagedIterable(this.client.listDataFeeds(options, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeedIngestionStatus> listDataFeedIngestionStatus(String dataFeedId, ListDataFeedIngestionOptions options) {
        return this.listDataFeedIngestionStatus(dataFeedId, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeedIngestionStatus> listDataFeedIngestionStatus(String dataFeedId, ListDataFeedIngestionOptions options, Context context) {
        return new PagedIterable(this.client.listDataFeedIngestionStatus(dataFeedId, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void refreshDataFeedIngestion(String dataFeedId, OffsetDateTime startTime, OffsetDateTime endTime) {
        this.refreshDataFeedIngestionWithResponse(dataFeedId, startTime, endTime, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> refreshDataFeedIngestionWithResponse(String dataFeedId, OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        return (Response)this.client.refreshDataFeedIngestionWithResponse(dataFeedId, startTime, endTime, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFeedIngestionProgress getDataFeedIngestionProgress(String dataFeedId) {
        return (DataFeedIngestionProgress)this.getDataFeedIngestionProgressWithResponse(dataFeedId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFeedIngestionProgress> getDataFeedIngestionProgressWithResponse(String dataFeedId, Context context) {
        return (Response)this.client.getDataFeedIngestionProgressWithResponse(dataFeedId, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyDetectionConfiguration createDetectionConfig(String metricId, AnomalyDetectionConfiguration detectionConfiguration) {
        return (AnomalyDetectionConfiguration)this.createDetectionConfigWithResponse(metricId, detectionConfiguration, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyDetectionConfiguration> createDetectionConfigWithResponse(String metricId, AnomalyDetectionConfiguration detectionConfiguration, Context context) {
        return (Response)this.client.createDetectionConfigWithResponse(metricId, detectionConfiguration, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyDetectionConfiguration getDetectionConfig(String detectionConfigurationId) {
        return (AnomalyDetectionConfiguration)this.getDetectionConfigWithResponse(detectionConfigurationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyDetectionConfiguration> getDetectionConfigWithResponse(String detectionConfigurationId, Context context) {
        return (Response)this.client.getDetectionConfigWithResponse(detectionConfigurationId, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyDetectionConfiguration updateDetectionConfig(AnomalyDetectionConfiguration detectionConfiguration) {
        return (AnomalyDetectionConfiguration)this.updateDetectionConfigWithResponse(detectionConfiguration, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyDetectionConfiguration> updateDetectionConfigWithResponse(AnomalyDetectionConfiguration detectionConfiguration, Context context) {
        return (Response)this.client.updateDetectionConfigWithResponse(detectionConfiguration, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDetectionConfig(String detectionConfigurationId) {
        this.deleteDetectionConfigWithResponse(detectionConfigurationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDetectionConfigWithResponse(String detectionConfigurationId, Context context) {
        return (Response)this.client.deleteDetectionConfigWithResponse(detectionConfigurationId, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyDetectionConfiguration> listDetectionConfigs(String metricId) {
        return new PagedIterable(this.client.listDetectionConfigs(metricId, null, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyDetectionConfiguration> listDetectionConfigs(String metricId, ListDetectionConfigsOptions options, Context context) {
        return new PagedIterable(this.client.listDetectionConfigs(metricId, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotificationHook createHook(NotificationHook notificationHook) {
        return (NotificationHook)this.createHookWithResponse(notificationHook, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NotificationHook> createHookWithResponse(NotificationHook notificationHook, Context context) {
        return (Response)this.client.createHookWithResponse(notificationHook, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotificationHook getHook(String hookId) {
        return (NotificationHook)this.getHookWithResponse(hookId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NotificationHook> getHookWithResponse(String hookId, Context context) {
        return (Response)this.client.getHookWithResponse(hookId, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotificationHook updateHook(NotificationHook notificationHook) {
        return (NotificationHook)this.updateHookWithResponse(notificationHook, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NotificationHook> updateHookWithResponse(NotificationHook notificationHook, Context context) {
        return (Response)this.client.updateHookWithResponse(notificationHook, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteHook(String hookId) {
        this.deleteHookWithResponse(hookId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteHookWithResponse(String hookId, Context context) {
        return (Response)this.client.deleteHookWithResponse(hookId, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotificationHook> listHooks() {
        return this.listHooks(new ListHookOptions(), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotificationHook> listHooks(ListHookOptions options, Context context) {
        return new PagedIterable(this.client.listHooks(options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyAlertConfiguration createAlertConfig(AnomalyAlertConfiguration alertConfiguration) {
        return (AnomalyAlertConfiguration)this.createAlertConfigWithResponse(alertConfiguration, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyAlertConfiguration> createAlertConfigWithResponse(AnomalyAlertConfiguration alertConfiguration, Context context) {
        return (Response)this.client.createAlertConfigWithResponse(alertConfiguration, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyAlertConfiguration getAlertConfig(String alertConfigurationId) {
        return (AnomalyAlertConfiguration)this.getAlertConfigWithResponse(alertConfigurationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyAlertConfiguration> getAlertConfigWithResponse(String alertConfigurationId, Context context) {
        return (Response)this.client.getAlertConfigWithResponse(alertConfigurationId, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyAlertConfiguration updateAlertConfig(AnomalyAlertConfiguration alertConfiguration) {
        return (AnomalyAlertConfiguration)this.updateAlertConfigWithResponse(alertConfiguration, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyAlertConfiguration> updateAlertConfigWithResponse(AnomalyAlertConfiguration alertConfiguration, Context context) {
        return (Response)this.client.updateAlertConfigWithResponse(alertConfiguration, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAlertConfig(String alertConfigurationId) {
        this.deleteAlertConfigWithResponse(alertConfigurationId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAlertConfigWithResponse(String alertConfigurationId, Context context) {
        return (Response)this.client.deleteAlertConfigWithResponse(alertConfigurationId, context == null ? Context.NONE : context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlertConfiguration> listAlertConfigs(String detectionConfigurationId, ListAnomalyAlertConfigsOptions options) {
        return this.listAlertConfigs(detectionConfigurationId, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlertConfiguration> listAlertConfigs(String detectionConfigurationId, ListAnomalyAlertConfigsOptions options, Context context) {
        return new PagedIterable(this.client.listAlertConfigs(detectionConfigurationId, options, context == null ? Context.NONE : context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataSourceCredentialEntity createDataSourceCredential(DataSourceCredentialEntity dataSourceCredential) {
        return (DataSourceCredentialEntity)this.createDataSourceCredentialWithResponse(dataSourceCredential, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataSourceCredentialEntity> createDataSourceCredentialWithResponse(DataSourceCredentialEntity dataSourceCredential, Context context) {
        return (Response)this.client.createDataSourceCredentialWithResponse(dataSourceCredential, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataSourceCredentialEntity getDataSourceCredential(String credentialId) {
        return (DataSourceCredentialEntity)this.getDataSourceCredentialWithResponse(credentialId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataSourceCredentialEntity> getDataSourceCredentialWithResponse(String credentialId, Context context) {
        return (Response)this.client.getDataSourceCredentialWithResponse(credentialId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataSourceCredentialEntity updateDataSourceCredential(DataSourceCredentialEntity dataSourceCredential) {
        return (DataSourceCredentialEntity)this.updateDataSourceCredentialWithResponse(dataSourceCredential, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataSourceCredentialEntity> updateDataSourceCredentialWithResponse(DataSourceCredentialEntity dataSourceCredential, Context context) {
        return (Response)this.client.updateDataSourceCredentialWithResponse(dataSourceCredential, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataSourceCredential(String credentialId) {
        this.deleteDataSourceCredentialWithResponse(credentialId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataSourceCredentialWithResponse(String credentialId, Context context) {
        return (Response)this.client.deleteDataFeedWithResponse(credentialId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataSourceCredentialEntity> listDataSourceCredentials() {
        return this.listDataSourceCredentials(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataSourceCredentialEntity> listDataSourceCredentials(ListCredentialEntityOptions options, Context context) {
        return new PagedIterable(this.client.listDataSourceCredentials(options, context));
    }
}

