/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration;

import com.azure.ai.metricsadvisor.MetricsAdvisorServiceVersion;
import com.azure.ai.metricsadvisor.administration.MetricsAdvisorAdministrationAsyncClient;
import com.azure.ai.metricsadvisor.administration.MetricsAdvisorAdministrationClient;
import com.azure.ai.metricsadvisor.implementation.AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl;
import com.azure.ai.metricsadvisor.implementation.AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2ImplBuilder;
import com.azure.ai.metricsadvisor.models.MetricsAdvisorKeyCredential;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={MetricsAdvisorAdministrationAsyncClient.class, MetricsAdvisorAdministrationClient.class})
public final class MetricsAdvisorAdministrationClientBuilder {
    private static final String ECHO_REQUEST_ID_HEADER = "x-ms-return-client-request-id";
    private static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String METRICSADVISOR_PROPERTIES = "azure-ai-metricsadvisor.properties";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
    private static final String DEFAULT_SCOPE = "https://cognitiveservices.azure.com/.default";
    private static final HttpLogOptions DEFAULT_LOG_OPTIONS = new HttpLogOptions();
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    private final ClientLogger logger = new ClientLogger(MetricsAdvisorAdministrationClientBuilder.class);
    private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private final HttpHeaders headers;
    private final String clientName;
    private final String clientVersion;
    private String endpoint;
    private TokenCredential tokenCredential;
    private MetricsAdvisorKeyCredential metricsAdvisorKeyCredential;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private ClientOptions clientOptions;
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private RetryPolicy retryPolicy;
    private MetricsAdvisorServiceVersion version;
    static final String OCP_APIM_SUBSCRIPTION_KEY = "Ocp-Apim-Subscription-Key";
    static final String API_KEY = "x-api-key";

    public MetricsAdvisorAdministrationClientBuilder() {
        Map properties = CoreUtils.getProperties((String)METRICSADVISOR_PROPERTIES);
        this.clientName = properties.getOrDefault(NAME, "UnknownName");
        this.clientVersion = properties.getOrDefault(VERSION, "UnknownVersion");
        this.headers = new HttpHeaders().set(ECHO_REQUEST_ID_HEADER, "true").set(ACCEPT_HEADER, CONTENT_TYPE_HEADER_VALUE);
    }

    public MetricsAdvisorAdministrationClient buildClient() {
        return new MetricsAdvisorAdministrationClient(this.buildAsyncClient());
    }

    public MetricsAdvisorAdministrationAsyncClient buildAsyncClient() {
        Objects.requireNonNull(this.endpoint, "'Endpoint' is required and can not be null.");
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        MetricsAdvisorServiceVersion serviceVersion = this.version != null ? this.version : MetricsAdvisorServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline;
        if (pipeline == null) {
            pipeline = this.getDefaultHttpPipeline(buildConfiguration);
        }
        AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl advisorRestAPIOpenAPIV2 = new AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2ImplBuilder().endpoint(this.endpoint).pipeline(pipeline).buildClient();
        return new MetricsAdvisorAdministrationAsyncClient(advisorRestAPIOpenAPIV2, serviceVersion);
    }

    private HttpPipeline getDefaultHttpPipeline(Configuration buildConfiguration) {
        ArrayList<Object> policies = new ArrayList<Object>();
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{DEFAULT_SCOPE}));
        } else if (!CoreUtils.isNullOrEmpty((CharSequence)this.metricsAdvisorKeyCredential.getKeys().getSubscriptionKey()) || !CoreUtils.isNullOrEmpty((CharSequence)this.metricsAdvisorKeyCredential.getKeys().getApiKey())) {
            this.headers.set(OCP_APIM_SUBSCRIPTION_KEY, this.metricsAdvisorKeyCredential.getKeys().getSubscriptionKey());
            this.headers.set(API_KEY, this.metricsAdvisorKeyCredential.getKeys().getApiKey());
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
        }
        ClientOptions buildClientOptions = this.clientOptions == null ? DEFAULT_CLIENT_OPTIONS : this.clientOptions;
        HttpLogOptions buildLogOptions = this.httpLogOptions == null ? DEFAULT_LOG_OPTIONS : this.httpLogOptions;
        String applicationId = CoreUtils.getApplicationId((ClientOptions)buildClientOptions, (HttpLogOptions)buildLogOptions);
        policies.add(new UserAgentPolicy(applicationId, this.clientName, this.clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersPolicy(this.headers));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? DEFAULT_RETRY_POLICY : this.retryPolicy);
        policies.add(new AddDatePolicy());
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
    }

    public MetricsAdvisorAdministrationClientBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL.", ex));
        }
        this.endpoint = endpoint.endsWith("/") ? endpoint.substring(0, endpoint.length() - 1) : endpoint;
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder credential(MetricsAdvisorKeyCredential metricsAdvisorKeyCredential) {
        this.metricsAdvisorKeyCredential = Objects.requireNonNull(metricsAdvisorKeyCredential, "'metricsAdvisorKeyCredential' cannot be null.");
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder addPolicy(HttpPipelinePolicy policy) {
        this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public MetricsAdvisorAdministrationClientBuilder serviceVersion(MetricsAdvisorServiceVersion version) {
        this.version = version;
        return this;
    }
}

