/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.MetricAlertConfiguration;
import com.azure.ai.metricsadvisor.administration.models.MetricAlertConfigurationsOperator;
import com.azure.ai.metricsadvisor.implementation.util.AnomalyAlertConfigurationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AnomalyAlertConfiguration {
    private String id;
    private final String name;
    private String description;
    private MetricAlertConfigurationsOperator crossMetricsOperator;
    private List<MetricAlertConfiguration> metricAnomalyAlertConfigurations;
    private List<String> hookIds;
    private List<String> splitAlertByDimensions;

    public AnomalyAlertConfiguration(String name) {
        this(name, null);
    }

    public AnomalyAlertConfiguration(String name, MetricAlertConfigurationsOperator crossMetricsOperator) {
        this.name = name;
        this.crossMetricsOperator = crossMetricsOperator;
        this.metricAnomalyAlertConfigurations = new ArrayList<MetricAlertConfiguration>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public MetricAlertConfigurationsOperator getCrossMetricsOperator() {
        return this.crossMetricsOperator;
    }

    public List<MetricAlertConfiguration> getMetricAlertConfigurations() {
        return Collections.unmodifiableList(this.metricAnomalyAlertConfigurations);
    }

    public List<String> getHookIdsToAlert() {
        if (this.hookIds != null) {
            return Collections.unmodifiableList(this.hookIds);
        }
        return Collections.emptyList();
    }

    public List<String> getDimensionsToSplitAlert() {
        return Collections.unmodifiableList(this.splitAlertByDimensions);
    }

    public AnomalyAlertConfiguration setDescription(String description) {
        this.description = description;
        return this;
    }

    public AnomalyAlertConfiguration setCrossMetricsOperator(MetricAlertConfigurationsOperator crossMetricsOperator) {
        this.crossMetricsOperator = crossMetricsOperator;
        return this;
    }

    public AnomalyAlertConfiguration addMetricAlertConfiguration(MetricAlertConfiguration configuration) {
        this.metricAnomalyAlertConfigurations.add(configuration);
        return this;
    }

    public AnomalyAlertConfiguration setMetricAlertConfigurations(List<MetricAlertConfiguration> configurations) {
        this.metricAnomalyAlertConfigurations = configurations == null ? new ArrayList<MetricAlertConfiguration>() : configurations;
        return this;
    }

    public AnomalyAlertConfiguration setHookIdsToAlert(List<String> hookIds) {
        this.hookIds = hookIds;
        return this;
    }

    public AnomalyAlertConfiguration setDimensionsToSplitAlert(List<String> dimensions) {
        this.splitAlertByDimensions = dimensions;
        return this;
    }

    private void setId(String id) {
        this.id = id;
    }

    private List<String> getHookIdsToAlertRaw() {
        return this.hookIds;
    }

    private List<String> getDimensionsToSplitAlertRaw() {
        return this.splitAlertByDimensions;
    }

    static {
        AnomalyAlertConfigurationHelper.setAccessor(new AnomalyAlertConfigurationHelper.AnomalyAlertConfigurationAccessor(){

            @Override
            public void setId(AnomalyAlertConfiguration configuration, String id) {
                configuration.setId(id);
            }

            @Override
            public List<String> getHookIdsToAlertRaw(AnomalyAlertConfiguration configuration) {
                return configuration.getHookIdsToAlertRaw();
            }

            @Override
            public List<String> getDimensionsToSplitAlertRaw(AnomalyAlertConfiguration configuration) {
                return configuration.getDimensionsToSplitAlertRaw();
            }
        });
    }
}

