/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.MetricSeriesGroupDetectionCondition;
import com.azure.ai.metricsadvisor.administration.models.MetricSingleSeriesDetectionCondition;
import com.azure.ai.metricsadvisor.administration.models.MetricWholeSeriesDetectionCondition;
import com.azure.ai.metricsadvisor.implementation.util.AnomalyDetectionConfigurationHelper;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AnomalyDetectionConfiguration {
    private String id;
    private String metricId;
    private String name;
    private String description;
    private MetricWholeSeriesDetectionCondition wholeSeriesCondition;
    private final List<MetricSeriesGroupDetectionCondition> seriesGroupConditions;
    private final List<MetricSingleSeriesDetectionCondition> seriesConditions;

    public AnomalyDetectionConfiguration(String name) {
        this.name = name;
        this.seriesGroupConditions = new ArrayList<MetricSeriesGroupDetectionCondition>();
        this.seriesConditions = new ArrayList<MetricSingleSeriesDetectionCondition>();
    }

    public String getId() {
        return this.id;
    }

    public String getMetricId() {
        return this.metricId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public MetricWholeSeriesDetectionCondition getWholeSeriesDetectionCondition() {
        return this.wholeSeriesCondition;
    }

    public List<MetricSeriesGroupDetectionCondition> getSeriesGroupDetectionConditions() {
        return Collections.unmodifiableList(this.seriesGroupConditions);
    }

    public List<MetricSingleSeriesDetectionCondition> getSeriesDetectionConditions() {
        return Collections.unmodifiableList(this.seriesConditions);
    }

    public AnomalyDetectionConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public AnomalyDetectionConfiguration setDescription(String description) {
        this.description = description;
        return this;
    }

    public AnomalyDetectionConfiguration setWholeSeriesDetectionCondition(MetricWholeSeriesDetectionCondition wholeSeriesCondition) {
        if (wholeSeriesCondition == null) {
            return this;
        }
        this.wholeSeriesCondition = wholeSeriesCondition;
        return this;
    }

    public AnomalyDetectionConfiguration addSeriesGroupDetectionCondition(MetricSeriesGroupDetectionCondition groupCondition) {
        if (groupCondition == null) {
            return this;
        }
        this.seriesGroupConditions.add(groupCondition);
        return this;
    }

    public AnomalyDetectionConfiguration removeSeriesGroupDetectionCondition(DimensionKey seriesGroupKey) {
        if (seriesGroupKey == null) {
            return this;
        }
        int idx = 0;
        for (MetricSeriesGroupDetectionCondition condition : this.seriesGroupConditions) {
            if (condition.getSeriesGroupKey().equals(seriesGroupKey)) break;
            ++idx;
        }
        if (idx != this.seriesGroupConditions.size()) {
            this.seriesGroupConditions.remove(idx);
        }
        return this;
    }

    public AnomalyDetectionConfiguration addSingleSeriesDetectionCondition(MetricSingleSeriesDetectionCondition seriesCondition) {
        if (seriesCondition == null) {
            return this;
        }
        this.seriesConditions.add(seriesCondition);
        return this;
    }

    public AnomalyDetectionConfiguration removeSingleSeriesDetectionCondition(DimensionKey seriesKey) {
        if (seriesKey == null) {
            return this;
        }
        int idx = 0;
        for (MetricSingleSeriesDetectionCondition condition : this.seriesConditions) {
            if (condition.getSeriesKey().equals(seriesKey)) break;
            ++idx;
        }
        if (idx != this.seriesConditions.size()) {
            this.seriesConditions.remove(idx);
        }
        return this;
    }

    void setId(String id) {
        this.id = id;
    }

    void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    static {
        AnomalyDetectionConfigurationHelper.setAccessor(new AnomalyDetectionConfigurationHelper.AnomalyDetectionConfigurationAccessor(){

            @Override
            public void setId(AnomalyDetectionConfiguration configuration, String id) {
                configuration.setId(id);
            }

            @Override
            public void setMetricId(AnomalyDetectionConfiguration configuration, String metricId) {
                configuration.setMetricId(metricId);
            }
        });
    }
}

