/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.DataFeedSource;
import com.azure.ai.metricsadvisor.administration.models.DataSourceAuthenticationType;
import com.azure.ai.metricsadvisor.implementation.util.AzureBlobDataFeedSourceAccessor;

public final class AzureBlobDataFeedSource
extends DataFeedSource {
    private final String connectionString;
    private final String container;
    private final String blobTemplate;
    private final DataSourceAuthenticationType authType;

    private AzureBlobDataFeedSource(String connectionString, String container, String blobTemplate, DataSourceAuthenticationType authType) {
        this.connectionString = connectionString;
        this.container = container;
        this.blobTemplate = blobTemplate;
        this.authType = authType;
    }

    public static AzureBlobDataFeedSource fromBasicCredential(String connectionString, String container, String blobTemplate) {
        return new AzureBlobDataFeedSource(connectionString, container, blobTemplate, DataSourceAuthenticationType.BASIC);
    }

    public static AzureBlobDataFeedSource fromManagedIdentityCredential(String connectionString, String container, String blobTemplate) {
        return new AzureBlobDataFeedSource(connectionString, container, blobTemplate, DataSourceAuthenticationType.MANAGED_IDENTITY);
    }

    public String getContainer() {
        return this.container;
    }

    public String getBlobTemplate() {
        return this.blobTemplate;
    }

    public DataSourceAuthenticationType getAuthenticationType() {
        return this.authType;
    }

    private String getConnectionString() {
        return this.connectionString;
    }

    static {
        AzureBlobDataFeedSourceAccessor.setAccessor(new AzureBlobDataFeedSourceAccessor.Accessor(){

            @Override
            public String getConnectionString(AzureBlobDataFeedSource feedSource) {
                return feedSource.getConnectionString();
            }
        });
    }
}

