/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.DataFeedSource;
import com.azure.ai.metricsadvisor.administration.models.DataSourceAuthenticationType;
import com.azure.ai.metricsadvisor.implementation.util.AzureDataExplorerDataFeedSourceAccessor;

public final class AzureDataExplorerDataFeedSource
extends DataFeedSource {
    private final String connectionString;
    private final String query;
    private final String credentialId;
    private final DataSourceAuthenticationType authType;

    private AzureDataExplorerDataFeedSource(String connectionString, String query, String credentialId, DataSourceAuthenticationType authType) {
        this.connectionString = connectionString;
        this.query = query;
        this.credentialId = credentialId;
        this.authType = authType;
    }

    public static AzureDataExplorerDataFeedSource fromBasicCredential(String connectionString, String query) {
        return new AzureDataExplorerDataFeedSource(connectionString, query, null, DataSourceAuthenticationType.BASIC);
    }

    public static AzureDataExplorerDataFeedSource fromManagedIdentityCredential(String connectionString, String query) {
        return new AzureDataExplorerDataFeedSource(connectionString, query, null, DataSourceAuthenticationType.MANAGED_IDENTITY);
    }

    public static AzureDataExplorerDataFeedSource fromServicePrincipalCredential(String connectionString, String query, String credentialId) {
        return new AzureDataExplorerDataFeedSource(connectionString, query, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL);
    }

    public static AzureDataExplorerDataFeedSource fromServicePrincipalInKeyVaultCredential(String connectionString, String query, String credentialId) {
        return new AzureDataExplorerDataFeedSource(connectionString, query, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL_IN_KV);
    }

    public String getQuery() {
        return this.query;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public DataSourceAuthenticationType getAuthenticationType() {
        return this.authType;
    }

    private String getConnectionString() {
        return this.connectionString;
    }

    static {
        AzureDataExplorerDataFeedSourceAccessor.setAccessor(new AzureDataExplorerDataFeedSourceAccessor.Accessor(){

            @Override
            public String getConnectionString(AzureDataExplorerDataFeedSource feedSource) {
                return feedSource.getConnectionString();
            }
        });
    }
}

