/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.DataFeedSource;
import com.azure.ai.metricsadvisor.administration.models.DataSourceAuthenticationType;
import com.azure.ai.metricsadvisor.implementation.util.AzureDataLakeStorageGen2DataFeedSourceAccessor;

public final class AzureDataLakeStorageGen2DataFeedSource
extends DataFeedSource {
    private final String accountName;
    private final String accountKey;
    private final String fileSystemName;
    private final String directoryTemplate;
    private final String fileTemplate;
    private final String credentialId;
    private final DataSourceAuthenticationType authType;

    private AzureDataLakeStorageGen2DataFeedSource(String accountName, String accountKey, String fileSystemName, String directoryTemplate, String fileTemplate, String credentialId, DataSourceAuthenticationType authType) {
        this.accountName = accountName;
        this.accountKey = accountKey;
        this.fileSystemName = fileSystemName;
        this.directoryTemplate = directoryTemplate;
        this.fileTemplate = fileTemplate;
        this.credentialId = credentialId;
        this.authType = authType;
    }

    public static AzureDataLakeStorageGen2DataFeedSource fromBasicCredential(String accountName, String accountKey, String fileSystemName, String directoryTemplate, String fileTemplate) {
        return new AzureDataLakeStorageGen2DataFeedSource(accountName, accountKey, fileSystemName, directoryTemplate, fileTemplate, null, DataSourceAuthenticationType.BASIC);
    }

    public static AzureDataLakeStorageGen2DataFeedSource fromSharedKeyCredential(String accountName, String fileSystemName, String directoryTemplate, String fileTemplate, String credentialId) {
        return new AzureDataLakeStorageGen2DataFeedSource(accountName, null, fileSystemName, directoryTemplate, fileTemplate, credentialId, DataSourceAuthenticationType.DATA_LAKE_GEN2_SHARED_KEY);
    }

    public static AzureDataLakeStorageGen2DataFeedSource fromServicePrincipalCredential(String accountName, String fileSystemName, String directoryTemplate, String fileTemplate, String credentialId) {
        return new AzureDataLakeStorageGen2DataFeedSource(accountName, null, fileSystemName, directoryTemplate, fileTemplate, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL);
    }

    public static AzureDataLakeStorageGen2DataFeedSource fromServicePrincipalInKeyVaultCredential(String accountName, String fileSystemName, String directoryTemplate, String fileTemplate, String credentialId) {
        return new AzureDataLakeStorageGen2DataFeedSource(accountName, null, fileSystemName, directoryTemplate, fileTemplate, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL_IN_KV);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public String getDirectoryTemplate() {
        return this.directoryTemplate;
    }

    public String getFileTemplate() {
        return this.fileTemplate;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public DataSourceAuthenticationType getAuthenticationType() {
        return this.authType;
    }

    private String getAccountKey() {
        return this.accountKey;
    }

    static {
        AzureDataLakeStorageGen2DataFeedSourceAccessor.setAccessor(new AzureDataLakeStorageGen2DataFeedSourceAccessor.Accessor(){

            @Override
            public String getAccountKey(AzureDataLakeStorageGen2DataFeedSource feedSource) {
                return feedSource.getAccountKey();
            }
        });
    }
}

