/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.DataFeedSource;
import com.azure.ai.metricsadvisor.administration.models.DataSourceAuthenticationType;
import com.azure.ai.metricsadvisor.implementation.util.AzureLogAnalyticsDataFeedSourceAccessor;

public final class AzureLogAnalyticsDataFeedSource
extends DataFeedSource {
    private final String tenantId;
    private final String clientId;
    private final String clientSecret;
    private final String workspaceId;
    private final String query;
    private final String credentialId;
    private final DataSourceAuthenticationType authType;

    private AzureLogAnalyticsDataFeedSource(String tenantId, String clientId, String clientSecret, String workspaceId, String query, String credentialId, DataSourceAuthenticationType authType) {
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.workspaceId = workspaceId;
        this.query = query;
        this.credentialId = credentialId;
        this.authType = authType;
    }

    public static AzureLogAnalyticsDataFeedSource fromBasicCredential(String tenantId, String clientId, String clientSecret, String workspaceId, String query) {
        return new AzureLogAnalyticsDataFeedSource(tenantId, clientId, clientSecret, workspaceId, query, null, DataSourceAuthenticationType.BASIC);
    }

    public static AzureLogAnalyticsDataFeedSource fromServicePrincipalCredential(String workspaceId, String query, String credentialId) {
        return new AzureLogAnalyticsDataFeedSource(null, null, null, workspaceId, query, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL);
    }

    public static AzureLogAnalyticsDataFeedSource fromServicePrincipalInKeyVaultCredential(String workspaceId, String query, String credentialId) {
        return new AzureLogAnalyticsDataFeedSource(null, null, null, workspaceId, query, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL_IN_KV);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getQuery() {
        return this.query;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public DataSourceAuthenticationType getAuthenticationType() {
        return this.authType;
    }

    private String getClientSecret() {
        return this.clientSecret;
    }

    static {
        AzureLogAnalyticsDataFeedSourceAccessor.setAccessor(new AzureLogAnalyticsDataFeedSourceAccessor.Accessor(){

            @Override
            public String getClientSecret(AzureLogAnalyticsDataFeedSource feedSource) {
                return feedSource.getClientSecret();
            }
        });
    }
}

