/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.DataFeedGranularity;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionSettings;
import com.azure.ai.metricsadvisor.administration.models.DataFeedOptions;
import com.azure.ai.metricsadvisor.administration.models.DataFeedSchema;
import com.azure.ai.metricsadvisor.administration.models.DataFeedSource;
import com.azure.ai.metricsadvisor.administration.models.DataFeedSourceType;
import com.azure.ai.metricsadvisor.administration.models.DataFeedStatus;
import com.azure.ai.metricsadvisor.implementation.util.DataFeedHelper;
import java.time.OffsetDateTime;
import java.util.Map;

public final class DataFeed {
    private String id;
    private Map<String, String> metricIds;
    private OffsetDateTime createdTime;
    private DataFeedStatus dataFeedStatus;
    private DataFeedSourceType dataFeedSourceType;
    private boolean isAdmin;
    private String creator;
    private DataFeedSource dataFeedSource;
    private DataFeedGranularity dataFeedGranularity;
    private DataFeedIngestionSettings dataFeedIngestionSettings;
    private DataFeedOptions dataFeedOptions;
    private String dataFeedName;
    private DataFeedSchema dataFeedSchema;

    public String getId() {
        return this.id;
    }

    public Map<String, String> getMetricIds() {
        return this.metricIds;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public DataFeedStatus getStatus() {
        return this.dataFeedStatus;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getName() {
        return this.dataFeedName;
    }

    public DataFeedSource getSource() {
        return this.dataFeedSource;
    }

    public DataFeedSchema getSchema() {
        return this.dataFeedSchema;
    }

    public DataFeedGranularity getGranularity() {
        return this.dataFeedGranularity;
    }

    public String getCreator() {
        return this.creator;
    }

    public DataFeedIngestionSettings getIngestionSettings() {
        return this.dataFeedIngestionSettings;
    }

    public DataFeedOptions getOptions() {
        return this.dataFeedOptions;
    }

    public DataFeedSourceType getSourceType() {
        return this.dataFeedSourceType;
    }

    public DataFeed setName(String dataFeedName) {
        this.dataFeedName = dataFeedName;
        return this;
    }

    public DataFeed setSource(DataFeedSource dataFeedSource) {
        this.dataFeedSource = dataFeedSource;
        return this;
    }

    public DataFeed setSchema(DataFeedSchema dataFeedSchema) {
        this.dataFeedSchema = dataFeedSchema;
        return this;
    }

    public DataFeed setGranularity(DataFeedGranularity granularity) {
        this.dataFeedGranularity = granularity;
        return this;
    }

    public DataFeed setIngestionSettings(DataFeedIngestionSettings dataFeedIngestionSettings) {
        this.dataFeedIngestionSettings = dataFeedIngestionSettings;
        return this;
    }

    public DataFeed setOptions(DataFeedOptions dataFeedOptions) {
        this.dataFeedOptions = dataFeedOptions;
        return this;
    }

    void setId(String id) {
        this.id = id;
    }

    void setMetricIds(Map<String, String> metricIds) {
        this.metricIds = metricIds;
    }

    void setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
    }

    void setStatus(DataFeedStatus dataFeedStatus) {
        this.dataFeedStatus = dataFeedStatus;
    }

    void setSourceType(DataFeedSourceType dataFeedSourceType) {
        this.dataFeedSourceType = dataFeedSourceType;
    }

    void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    void setCreator(String creator) {
        this.creator = creator;
    }

    static {
        DataFeedHelper.setAccessor(new DataFeedHelper.DataFeedAccessor(){

            @Override
            public void setId(DataFeed feed, String id) {
                feed.setId(id);
            }

            @Override
            public void setMetricIds(DataFeed feed, Map<String, String> metricIds) {
                feed.setMetricIds(metricIds);
            }

            @Override
            public void setCreatedTime(DataFeed feed, OffsetDateTime createdTime) {
                feed.setCreatedTime(createdTime);
            }

            @Override
            public void setStatus(DataFeed feed, DataFeedStatus dataFeedStatus) {
                feed.setStatus(dataFeedStatus);
            }

            @Override
            public void setSourceType(DataFeed feed, DataFeedSourceType dataFeedSourceType) {
                feed.setSourceType(dataFeedSourceType);
            }

            @Override
            public void setIsAdmin(DataFeed feed, boolean isAdmin) {
                feed.setIsAdmin(isAdmin);
            }

            @Override
            public void setCreator(DataFeed feed, String creator) {
                feed.setCreator(creator);
            }
        });
    }
}

