/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.NotificationHook;
import java.util.Collections;
import java.util.List;

public final class EmailNotificationHook
extends NotificationHook {
    private String name;
    private String description;
    private List<String> emailsToAlert;
    private String externalLink;

    public EmailNotificationHook(String name) {
        this.name = name;
    }

    public EmailNotificationHook(String name, List<String> emails) {
        if (emails != null) {
            this.emailsToAlert = this.dedupe(emails);
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExternalLink() {
        return this.externalLink;
    }

    public List<String> getEmailsToAlert() {
        if (this.emailsToAlert != null) {
            return Collections.unmodifiableList(this.emailsToAlert);
        }
        return Collections.emptyList();
    }

    public EmailNotificationHook setEmailsToAlert(List<String> emails) {
        this.emailsToAlert = emails != null ? this.dedupe(emails) : null;
        return this;
    }

    public EmailNotificationHook setName(String name) {
        this.name = name;
        return this;
    }

    public EmailNotificationHook setDescription(String description) {
        this.description = description;
        return this;
    }

    public EmailNotificationHook setExternalLink(String externalLink) {
        this.externalLink = externalLink;
        return this;
    }

    public EmailNotificationHook setAdmins(List<String> admins) {
        super.setAdministrators(admins);
        return this;
    }

    List<String> getEmailsToAlertRaw() {
        return this.emailsToAlert;
    }
}

