/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertConditions;
import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertScope;
import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertSnoozeCondition;

public final class MetricAlertConfiguration {
    private final String detectionConfigurationId;
    private boolean negationOperation;
    private MetricAnomalyAlertScope alertScope;
    private MetricAnomalyAlertConditions alertConditions;
    private MetricAnomalyAlertSnoozeCondition snoozeCondition;

    public MetricAlertConfiguration(String detectionConfigurationId, MetricAnomalyAlertScope alertScope) {
        this(detectionConfigurationId, alertScope, false);
    }

    public MetricAlertConfiguration(String detectionConfigurationId, MetricAnomalyAlertScope alertScope, boolean negationOperation) {
        this.detectionConfigurationId = detectionConfigurationId;
        this.negationOperation = negationOperation;
        this.alertScope = alertScope;
    }

    public String getDetectionConfigurationId() {
        return this.detectionConfigurationId;
    }

    public Boolean isNegationOperationEnabled() {
        return this.negationOperation;
    }

    public MetricAnomalyAlertScope getAlertScope() {
        return this.alertScope;
    }

    public MetricAnomalyAlertConditions getAlertConditions() {
        return this.alertConditions;
    }

    public MetricAnomalyAlertSnoozeCondition getAlertSnoozeCondition() {
        return this.snoozeCondition;
    }

    public MetricAlertConfiguration setNegationOperation(boolean negationOperation) {
        this.negationOperation = negationOperation;
        return this;
    }

    public MetricAlertConfiguration setScopeOfAlertTo(MetricAnomalyAlertScope alertScope) {
        this.alertScope = alertScope;
        return this;
    }

    public MetricAlertConfiguration setAlertConditions(MetricAnomalyAlertConditions alertConditions) {
        this.alertConditions = alertConditions;
        return this;
    }

    public MetricAlertConfiguration setAlertSnoozeCondition(MetricAnomalyAlertSnoozeCondition snoozeCondition) {
        this.snoozeCondition = snoozeCondition;
        return this;
    }
}

