/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertScopeType;
import com.azure.ai.metricsadvisor.administration.models.TopNGroupScope;
import com.azure.ai.metricsadvisor.models.DimensionKey;

public final class MetricAnomalyAlertScope {
    private final MetricAnomalyAlertScopeType scopeType;
    private final DimensionKey seriesGroupId;
    private final TopNGroupScope topNGroup;

    private MetricAnomalyAlertScope() {
        this.scopeType = MetricAnomalyAlertScopeType.WHOLE_SERIES;
        this.seriesGroupId = null;
        this.topNGroup = null;
    }

    private MetricAnomalyAlertScope(DimensionKey seriesGroupId) {
        this.scopeType = MetricAnomalyAlertScopeType.SERIES_GROUP;
        this.seriesGroupId = seriesGroupId;
        this.topNGroup = null;
    }

    private MetricAnomalyAlertScope(TopNGroupScope topNGroup) {
        this.scopeType = MetricAnomalyAlertScopeType.TOP_N;
        this.topNGroup = topNGroup;
        this.seriesGroupId = null;
    }

    public MetricAnomalyAlertScopeType getScopeType() {
        return this.scopeType;
    }

    public DimensionKey getSeriesGroupInScope() {
        return this.seriesGroupId;
    }

    public TopNGroupScope getTopNGroupInScope() {
        return this.topNGroup;
    }

    public static MetricAnomalyAlertScope forWholeSeries() {
        return new MetricAnomalyAlertScope();
    }

    public static MetricAnomalyAlertScope forSeriesGroup(DimensionKey seriesGroupId) {
        return new MetricAnomalyAlertScope(seriesGroupId);
    }

    public static MetricAnomalyAlertScope forTopNGroup(int top, int period, int minTopCount) {
        return new MetricAnomalyAlertScope(new TopNGroupScope(top, period, minTopCount));
    }

    public static MetricAnomalyAlertScope forTopNGroup(TopNGroupScope topNGroup) {
        return new MetricAnomalyAlertScope(topNGroup);
    }
}

