/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.BoundaryDirection;
import com.azure.ai.metricsadvisor.administration.models.BoundaryMeasureType;
import com.azure.ai.metricsadvisor.implementation.util.MetricBoundaryConditionHelper;

public final class MetricBoundaryCondition {
    private BoundaryDirection boundaryDirection;
    private Double lowerBoundary;
    private Double upperBoundary;
    private String companionMetricId;
    private Boolean alertIfMissing;
    private BoundaryMeasureType measureType;

    public BoundaryDirection getDirection() {
        return this.boundaryDirection;
    }

    public Double getLowerBoundary() {
        return this.lowerBoundary;
    }

    public Double getUpperBoundary() {
        return this.upperBoundary;
    }

    public String getCompanionMetricId() {
        return this.companionMetricId;
    }

    public Boolean shouldAlertIfDataPointMissing() {
        return this.alertIfMissing;
    }

    public BoundaryMeasureType getMeasureType() {
        return this.measureType;
    }

    public MetricBoundaryCondition setBoundary(BoundaryDirection direction, Double lowerBoundary, Double upperBoundary) {
        this.lowerBoundary = lowerBoundary;
        this.upperBoundary = upperBoundary;
        this.boundaryDirection = direction;
        return this;
    }

    public MetricBoundaryCondition setCompanionMetricId(String companionMetricId) {
        this.companionMetricId = companionMetricId;
        return this;
    }

    public MetricBoundaryCondition setCompanionMetricId(String companionMetricId, boolean alertIfMissing) {
        this.companionMetricId = companionMetricId;
        this.alertIfMissing = alertIfMissing;
        return this;
    }

    public MetricBoundaryCondition setMeasureType(BoundaryMeasureType measureType) {
        this.measureType = measureType;
        return this;
    }

    void setLowerBoundary(Double lowerBoundary) {
        this.lowerBoundary = lowerBoundary;
    }

    void setUpperBoundary(Double upperBoundary) {
        this.upperBoundary = upperBoundary;
    }

    void setBoundaryDirection(BoundaryDirection boundaryDirection) {
        this.boundaryDirection = boundaryDirection;
    }

    static {
        MetricBoundaryConditionHelper.setAccessor(new MetricBoundaryConditionHelper.MetricBoundaryConditionAccessor(){

            @Override
            public void setLowerBoundary(MetricBoundaryCondition condition, Double lowerBoundary) {
                condition.setLowerBoundary(lowerBoundary);
            }

            @Override
            public void setUpperBoundary(MetricBoundaryCondition condition, Double upperBoundary) {
                condition.setUpperBoundary(upperBoundary);
            }

            @Override
            public void setBoundaryDirection(MetricBoundaryCondition condition, BoundaryDirection boundaryDirection) {
                condition.setBoundaryDirection(boundaryDirection);
            }
        });
    }
}

