/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.EmailNotificationHook;
import com.azure.ai.metricsadvisor.administration.models.WebNotificationHook;
import com.azure.ai.metricsadvisor.implementation.util.HookHelper;
import com.azure.core.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public abstract class NotificationHook {
    private String id;
    private List<String> admins;

    public String getId() {
        return this.id;
    }

    public abstract String getName();

    public abstract String getDescription();

    public List<String> getAdmins() {
        if (this.admins != null) {
            return Collections.unmodifiableList(this.admins);
        }
        return Collections.emptyList();
    }

    private void setId(String id) {
        this.id = id;
    }

    private List<String> getAdminsRaw() {
        return this.admins;
    }

    void setAdministrators(List<String> admins) {
        this.admins = admins != null ? this.dedupe(admins) : null;
    }

    List<String> dedupe(List<String> list) {
        TreeSet seen = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> dedupedList = new ArrayList<String>(list);
        dedupedList.removeIf(e -> !seen.add(e));
        return dedupedList;
    }

    static {
        HookHelper.setAccessor(new HookHelper.HookAccessor(){

            @Override
            public void setId(NotificationHook hook, String id) {
                hook.setId(id);
            }

            @Override
            public List<String> getAdminsRaw(NotificationHook hook) {
                return hook.getAdminsRaw();
            }

            @Override
            public List<String> getEmailsToAlertRaw(EmailNotificationHook emailHook) {
                return emailHook.getEmailsToAlertRaw();
            }

            @Override
            public HttpHeaders getHttpHeadersRaw(WebNotificationHook webHook) {
                return webHook.getHttpHeadersRaw();
            }
        });
    }
}

