/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.administration.models.DataFeedSource;
import com.azure.ai.metricsadvisor.administration.models.DataSourceAuthenticationType;
import com.azure.ai.metricsadvisor.implementation.util.SqlServerDataFeedSourceAccessor;

public final class SqlServerDataFeedSource
extends DataFeedSource {
    private final String connectionString;
    private final String query;
    private final String credentialId;
    private final DataSourceAuthenticationType authType;

    private SqlServerDataFeedSource(String connectionString, String query, String credentialId, DataSourceAuthenticationType authType) {
        this.connectionString = connectionString;
        this.query = query;
        this.credentialId = credentialId;
        this.authType = authType;
    }

    public static SqlServerDataFeedSource fromBasicCredential(String connectionString, String query) {
        return new SqlServerDataFeedSource(connectionString, query, null, DataSourceAuthenticationType.BASIC);
    }

    public static SqlServerDataFeedSource fromManagedIdentityCredential(String connectionString, String query) {
        return new SqlServerDataFeedSource(connectionString, query, null, DataSourceAuthenticationType.MANAGED_IDENTITY);
    }

    public static SqlServerDataFeedSource fromConnectionStringCredential(String query, String credentialId) {
        return new SqlServerDataFeedSource(null, query, credentialId, DataSourceAuthenticationType.AZURE_SQL_CONNECTION_STRING);
    }

    public static SqlServerDataFeedSource fromServicePrincipalCredential(String connectionString, String query, String credentialId) {
        return new SqlServerDataFeedSource(connectionString, query, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL);
    }

    public static SqlServerDataFeedSource fromServicePrincipalInKeyVaultCredential(String connectionString, String query, String credentialId) {
        return new SqlServerDataFeedSource(connectionString, query, credentialId, DataSourceAuthenticationType.SERVICE_PRINCIPAL_IN_KV);
    }

    public String getQuery() {
        return this.query;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public DataSourceAuthenticationType getAuthenticationType() {
        return this.authType;
    }

    private String getConnectionString() {
        return this.connectionString;
    }

    static {
        SqlServerDataFeedSourceAccessor.setAccessor(new SqlServerDataFeedSourceAccessor.Accessor(){

            @Override
            public String getConnectionString(SqlServerDataFeedSource feedSource) {
                return feedSource.getConnectionString();
            }
        });
    }
}

