/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation;

import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionProgress;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionStatus;
import com.azure.ai.metricsadvisor.implementation.models.AlertResultList;
import com.azure.ai.metricsadvisor.implementation.models.AlertingResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfigurationList;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfigurationList;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDimensionList;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDimensionQuery;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyResult;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyResultList;
import com.azure.ai.metricsadvisor.implementation.models.CreateAnomalyAlertingConfigurationResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateAnomalyDetectionConfigurationResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateCredentialResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateDataFeedResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateHookResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateMetricFeedbackResponse;
import com.azure.ai.metricsadvisor.implementation.models.DataFeedDetail;
import com.azure.ai.metricsadvisor.implementation.models.DataFeedDetailPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataFeedList;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredential;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredentialList;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceType;
import com.azure.ai.metricsadvisor.implementation.models.DetectionAnomalyResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.DetectionIncidentResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.DetectionSeriesQuery;
import com.azure.ai.metricsadvisor.implementation.models.EnrichmentStatusList;
import com.azure.ai.metricsadvisor.implementation.models.EnrichmentStatusQueryOption;
import com.azure.ai.metricsadvisor.implementation.models.EntityStatus;
import com.azure.ai.metricsadvisor.implementation.models.Granularity;
import com.azure.ai.metricsadvisor.implementation.models.HookInfo;
import com.azure.ai.metricsadvisor.implementation.models.HookInfoPatch;
import com.azure.ai.metricsadvisor.implementation.models.HookList;
import com.azure.ai.metricsadvisor.implementation.models.IncidentResult;
import com.azure.ai.metricsadvisor.implementation.models.IncidentResultList;
import com.azure.ai.metricsadvisor.implementation.models.IngestionProgressResetOptions;
import com.azure.ai.metricsadvisor.implementation.models.IngestionStatusList;
import com.azure.ai.metricsadvisor.implementation.models.IngestionStatusQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricDataList;
import com.azure.ai.metricsadvisor.implementation.models.MetricDataQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricDimensionList;
import com.azure.ai.metricsadvisor.implementation.models.MetricDimensionQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedback;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedbackFilter;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedbackList;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesItem;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesList;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.RootCauseList;
import com.azure.ai.metricsadvisor.implementation.models.SeriesResultList;
import com.azure.ai.metricsadvisor.implementation.models.UsageStats;
import com.azure.ai.metricsadvisor.models.AnomalyAlert;
import com.azure.ai.metricsadvisor.models.EnrichmentStatus;
import com.azure.ai.metricsadvisor.models.MetricsAdvisorResponseException;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl {
    private final AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Service service;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl(String endpoint) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint);
    }

    AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl(HttpPipeline httpPipeline, String endpoint) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint);
    }

    AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.service = (AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Service)RestProxy.create(AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Service.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UsageStats>> getActiveSeriesCountWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getActiveSeriesCount(this.getEndpoint(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UsageStats>> getActiveSeriesCountWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.getActiveSeriesCount(this.getEndpoint(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UsageStats> getActiveSeriesCountAsync() {
        return this.getActiveSeriesCountWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((UsageStats)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UsageStats> getActiveSeriesCountAsync(Context context) {
        return this.getActiveSeriesCountWithResponseAsync(context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((UsageStats)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UsageStats getActiveSeriesCount() {
        return (UsageStats)this.getActiveSeriesCountAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UsageStats> getActiveSeriesCountWithResponse(Context context) {
        return (Response)this.getActiveSeriesCountWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationWithResponseAsync(UUID configurationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationWithResponseAsync(UUID configurationId, Context context) {
        String accept = "application/json";
        return this.service.getAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationAsync(UUID configurationId) {
        return this.getAnomalyAlertingConfigurationWithResponseAsync(configurationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyAlertingConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationAsync(UUID configurationId, Context context) {
        return this.getAnomalyAlertingConfigurationWithResponseAsync(configurationId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyAlertingConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyAlertingConfiguration getAnomalyAlertingConfiguration(UUID configurationId) {
        return (AnomalyAlertingConfiguration)this.getAnomalyAlertingConfigurationAsync(configurationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationWithResponse(UUID configurationId, Context context) {
        return (Response)this.getAnomalyAlertingConfigurationWithResponseAsync(configurationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> updateAnomalyAlertingConfigurationWithResponseAsync(UUID configurationId, AnomalyAlertingConfigurationPatch body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> updateAnomalyAlertingConfigurationWithResponseAsync(UUID configurationId, AnomalyAlertingConfigurationPatch body, Context context) {
        String accept = "application/json";
        return this.service.updateAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> updateAnomalyAlertingConfigurationAsync(UUID configurationId, AnomalyAlertingConfigurationPatch body) {
        return this.updateAnomalyAlertingConfigurationWithResponseAsync(configurationId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyAlertingConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> updateAnomalyAlertingConfigurationAsync(UUID configurationId, AnomalyAlertingConfigurationPatch body, Context context) {
        return this.updateAnomalyAlertingConfigurationWithResponseAsync(configurationId, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyAlertingConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyAlertingConfiguration updateAnomalyAlertingConfiguration(UUID configurationId, AnomalyAlertingConfigurationPatch body) {
        return (AnomalyAlertingConfiguration)this.updateAnomalyAlertingConfigurationAsync(configurationId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyAlertingConfiguration> updateAnomalyAlertingConfigurationWithResponse(UUID configurationId, AnomalyAlertingConfigurationPatch body, Context context) {
        return (Response)this.updateAnomalyAlertingConfigurationWithResponseAsync(configurationId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyAlertingConfigurationWithResponseAsync(UUID configurationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyAlertingConfigurationWithResponseAsync(UUID configurationId, Context context) {
        String accept = "application/json";
        return this.service.deleteAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyAlertingConfigurationAsync(UUID configurationId) {
        return this.deleteAnomalyAlertingConfigurationWithResponseAsync(configurationId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyAlertingConfigurationAsync(UUID configurationId, Context context) {
        return this.deleteAnomalyAlertingConfigurationWithResponseAsync(configurationId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAnomalyAlertingConfiguration(UUID configurationId) {
        this.deleteAnomalyAlertingConfigurationAsync(configurationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAnomalyAlertingConfigurationWithResponse(UUID configurationId, Context context) {
        return (Response)this.deleteAnomalyAlertingConfigurationWithResponseAsync(configurationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateAnomalyAlertingConfigurationResponse> createAnomalyAlertingConfigurationWithResponseAsync(AnomalyAlertingConfiguration body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAnomalyAlertingConfiguration(this.getEndpoint(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateAnomalyAlertingConfigurationResponse> createAnomalyAlertingConfigurationWithResponseAsync(AnomalyAlertingConfiguration body, Context context) {
        String accept = "application/json";
        return this.service.createAnomalyAlertingConfiguration(this.getEndpoint(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAnomalyAlertingConfigurationAsync(AnomalyAlertingConfiguration body) {
        return this.createAnomalyAlertingConfigurationWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAnomalyAlertingConfigurationAsync(AnomalyAlertingConfiguration body, Context context) {
        return this.createAnomalyAlertingConfigurationWithResponseAsync(body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createAnomalyAlertingConfiguration(AnomalyAlertingConfiguration body) {
        this.createAnomalyAlertingConfigurationAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createAnomalyAlertingConfigurationWithResponse(AnomalyAlertingConfiguration body, Context context) {
        return (Response)this.createAnomalyAlertingConfigurationWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationSinglePageAsync(UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAlertsByAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertResultList)res.getValue()).getValue(), ((AlertResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationSinglePageAsync(UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getAlertsByAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertResultList)res.getValue()).getValue(), ((AlertResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlert> getAlertsByAnomalyAlertingConfigurationAsync(UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getAlertsByAnomalyAlertingConfigurationSinglePageAsync(configurationId, body, skip, maxpagesize), nextLink -> this.getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlert> getAlertsByAnomalyAlertingConfigurationAsync(UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getAlertsByAnomalyAlertingConfigurationSinglePageAsync(configurationId, body, skip, maxpagesize, context), nextLink -> this.getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlert> getAlertsByAnomalyAlertingConfiguration(UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getAlertsByAnomalyAlertingConfigurationAsync(configurationId, body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlert> getAlertsByAnomalyAlertingConfiguration(UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getAlertsByAnomalyAlertingConfigurationAsync(configurationId, body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomaliesFromAlertByAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, alertId, skip, maxpagesize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getAnomaliesFromAlertByAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, alertId, skip, maxpagesize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(configurationId, alertId, skip, maxpagesize), nextLink -> this.getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(configurationId, alertId, skip, maxpagesize, context), nextLink -> this.getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfiguration(UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(configurationId, alertId, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfiguration(UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(configurationId, alertId, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIncidentsFromAlertByAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, alertId, skip, maxpagesize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getIncidentsFromAlertByAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, alertId, skip, maxpagesize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(configurationId, alertId, skip, maxpagesize), nextLink -> this.getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(configurationId, alertId, skip, maxpagesize, context), nextLink -> this.getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfiguration(UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(configurationId, alertId, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfiguration(UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(configurationId, alertId, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, Context context) {
        String accept = "application/json";
        return this.service.getAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationAsync(UUID configurationId) {
        return this.getAnomalyDetectionConfigurationWithResponseAsync(configurationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyDetectionConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationAsync(UUID configurationId, Context context) {
        return this.getAnomalyDetectionConfigurationWithResponseAsync(configurationId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyDetectionConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyDetectionConfiguration getAnomalyDetectionConfiguration(UUID configurationId) {
        return (AnomalyDetectionConfiguration)this.getAnomalyDetectionConfigurationAsync(configurationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationWithResponse(UUID configurationId, Context context) {
        return (Response)this.getAnomalyDetectionConfigurationWithResponseAsync(configurationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> updateAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, AnomalyDetectionConfigurationPatch body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> updateAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, AnomalyDetectionConfigurationPatch body, Context context) {
        String accept = "application/json";
        return this.service.updateAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> updateAnomalyDetectionConfigurationAsync(UUID configurationId, AnomalyDetectionConfigurationPatch body) {
        return this.updateAnomalyDetectionConfigurationWithResponseAsync(configurationId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyDetectionConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> updateAnomalyDetectionConfigurationAsync(UUID configurationId, AnomalyDetectionConfigurationPatch body, Context context) {
        return this.updateAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnomalyDetectionConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnomalyDetectionConfiguration updateAnomalyDetectionConfiguration(UUID configurationId, AnomalyDetectionConfigurationPatch body) {
        return (AnomalyDetectionConfiguration)this.updateAnomalyDetectionConfigurationAsync(configurationId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnomalyDetectionConfiguration> updateAnomalyDetectionConfigurationWithResponse(UUID configurationId, AnomalyDetectionConfigurationPatch body, Context context) {
        return (Response)this.updateAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, Context context) {
        String accept = "application/json";
        return this.service.deleteAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyDetectionConfigurationAsync(UUID configurationId) {
        return this.deleteAnomalyDetectionConfigurationWithResponseAsync(configurationId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyDetectionConfigurationAsync(UUID configurationId, Context context) {
        return this.deleteAnomalyDetectionConfigurationWithResponseAsync(configurationId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAnomalyDetectionConfiguration(UUID configurationId) {
        this.deleteAnomalyDetectionConfigurationAsync(configurationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAnomalyDetectionConfigurationWithResponse(UUID configurationId, Context context) {
        return (Response)this.deleteAnomalyDetectionConfigurationWithResponseAsync(configurationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateAnomalyDetectionConfigurationResponse> createAnomalyDetectionConfigurationWithResponseAsync(AnomalyDetectionConfiguration body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAnomalyDetectionConfiguration(this.getEndpoint(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateAnomalyDetectionConfigurationResponse> createAnomalyDetectionConfigurationWithResponseAsync(AnomalyDetectionConfiguration body, Context context) {
        String accept = "application/json";
        return this.service.createAnomalyDetectionConfiguration(this.getEndpoint(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAnomalyDetectionConfigurationAsync(AnomalyDetectionConfiguration body) {
        return this.createAnomalyDetectionConfigurationWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAnomalyDetectionConfigurationAsync(AnomalyDetectionConfiguration body, Context context) {
        return this.createAnomalyDetectionConfigurationWithResponseAsync(body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createAnomalyDetectionConfiguration(AnomalyDetectionConfiguration body) {
        this.createAnomalyDetectionConfigurationAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createAnomalyDetectionConfigurationWithResponse(AnomalyDetectionConfiguration body, Context context) {
        return (Response)this.createAnomalyDetectionConfigurationWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyAlertingConfigurationList)res.getValue()).getValue(), ((AnomalyAlertingConfigurationList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyAlertingConfigurationList)res.getValue()).getValue(), ((AnomalyAlertingConfigurationList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(UUID configurationId, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(configurationId, skip, maxpagesize), nextLink -> this.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(UUID configurationId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(configurationId, skip, maxpagesize, context), nextLink -> this.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(UUID configurationId, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(configurationId, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(UUID configurationId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(configurationId, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SeriesResultList>> getSeriesByAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, DetectionSeriesQuery body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSeriesByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SeriesResultList>> getSeriesByAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, DetectionSeriesQuery body, Context context) {
        String accept = "application/json";
        return this.service.getSeriesByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SeriesResultList> getSeriesByAnomalyDetectionConfigurationAsync(UUID configurationId, DetectionSeriesQuery body) {
        return this.getSeriesByAnomalyDetectionConfigurationWithResponseAsync(configurationId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SeriesResultList)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SeriesResultList> getSeriesByAnomalyDetectionConfigurationAsync(UUID configurationId, DetectionSeriesQuery body, Context context) {
        return this.getSeriesByAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SeriesResultList)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SeriesResultList getSeriesByAnomalyDetectionConfiguration(UUID configurationId, DetectionSeriesQuery body) {
        return (SeriesResultList)this.getSeriesByAnomalyDetectionConfigurationAsync(configurationId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SeriesResultList> getSeriesByAnomalyDetectionConfigurationWithResponse(UUID configurationId, DetectionSeriesQuery body, Context context) {
        return (Response)this.getSeriesByAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomaliesByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getAnomaliesByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesByAnomalyDetectionConfigurationAsync(UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(configurationId, body, skip, maxpagesize), nextLink -> this.getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesByAnomalyDetectionConfigurationAsync(UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(configurationId, body, skip, maxpagesize, context), nextLink -> this.getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesByAnomalyDetectionConfiguration(UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getAnomaliesByAnomalyDetectionConfigurationAsync(configurationId, body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesByAnomalyDetectionConfiguration(UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getAnomaliesByAnomalyDetectionConfigurationAsync(configurationId, body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDimensionOfAnomaliesByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDimensionList)res.getValue()).getValue(), ((AnomalyDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getDimensionOfAnomaliesByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDimensionList)res.getValue()).getValue(), ((AnomalyDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(configurationId, body, skip, maxpagesize), nextLink -> this.getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(configurationId, body, skip, maxpagesize, context), nextLink -> this.getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> getDimensionOfAnomaliesByAnomalyDetectionConfiguration(UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(configurationId, body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> getDimensionOfAnomaliesByAnomalyDetectionConfiguration(UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(configurationId, body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIncidentsByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getIncidentsByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationAsync(UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize) {
        return new PagedFlux(() -> this.getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(configurationId, body, maxpagesize), nextLink -> this.getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationAsync(UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(configurationId, body, maxpagesize, context), nextLink -> this.getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfiguration(UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize) {
        return new PagedIterable(this.getIncidentsByAnomalyDetectionConfigurationAsync(configurationId, body, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfiguration(UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getIncidentsByAnomalyDetectionConfigurationAsync(configurationId, body, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(UUID configurationId, Integer maxpagesize, String token) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIncidentsByAnomalyDetectionConfigurationNextPages(this.getEndpoint(), configurationId, maxpagesize, token, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(UUID configurationId, Integer maxpagesize, String token, Context context) {
        String accept = "application/json";
        return this.service.getIncidentsByAnomalyDetectionConfigurationNextPages(this.getEndpoint(), configurationId, maxpagesize, token, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(UUID configurationId, Integer maxpagesize, String token) {
        return new PagedFlux(() -> this.getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(configurationId, maxpagesize, token), nextLink -> this.getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(UUID configurationId, Integer maxpagesize, String token, Context context) {
        return new PagedFlux(() -> this.getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(configurationId, maxpagesize, token, context), nextLink -> this.getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPages(UUID configurationId, Integer maxpagesize, String token) {
        return new PagedIterable(this.getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(configurationId, maxpagesize, token));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPages(UUID configurationId, Integer maxpagesize, String token, Context context) {
        return new PagedIterable(this.getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(configurationId, maxpagesize, token, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RootCauseList>> getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, String incidentId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRootCauseOfIncidentByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, incidentId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RootCauseList>> getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId, String incidentId, Context context) {
        String accept = "application/json";
        return this.service.getRootCauseOfIncidentByAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, incidentId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RootCauseList> getRootCauseOfIncidentByAnomalyDetectionConfigurationAsync(UUID configurationId, String incidentId) {
        return this.getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(configurationId, incidentId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RootCauseList)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RootCauseList> getRootCauseOfIncidentByAnomalyDetectionConfigurationAsync(UUID configurationId, String incidentId, Context context) {
        return this.getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(configurationId, incidentId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RootCauseList)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RootCauseList getRootCauseOfIncidentByAnomalyDetectionConfiguration(UUID configurationId, String incidentId) {
        return (RootCauseList)this.getRootCauseOfIncidentByAnomalyDetectionConfigurationAsync(configurationId, incidentId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RootCauseList> getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponse(UUID configurationId, String incidentId, Context context) {
        return (Response)this.getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(configurationId, incidentId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCredentialResponse> createCredentialWithResponseAsync(DataSourceCredential body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createCredential(this.getEndpoint(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCredentialResponse> createCredentialWithResponseAsync(DataSourceCredential body, Context context) {
        String accept = "application/json";
        return this.service.createCredential(this.getEndpoint(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createCredentialAsync(DataSourceCredential body) {
        return this.createCredentialWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createCredentialAsync(DataSourceCredential body, Context context) {
        return this.createCredentialWithResponseAsync(body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createCredential(DataSourceCredential body) {
        this.createCredentialAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createCredentialWithResponse(DataSourceCredential body, Context context) {
        return (Response)this.createCredentialWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsSinglePageAsync(Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCredentials(this.getEndpoint(), skip, maxpagesize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceCredentialList)res.getValue()).getValue(), ((DataSourceCredentialList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsSinglePageAsync(Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.listCredentials(this.getEndpoint(), skip, maxpagesize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceCredentialList)res.getValue()).getValue(), ((DataSourceCredentialList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataSourceCredential> listCredentialsAsync(Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.listCredentialsSinglePageAsync(skip, maxpagesize), nextLink -> this.listCredentialsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataSourceCredential> listCredentialsAsync(Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.listCredentialsSinglePageAsync(skip, maxpagesize, context), nextLink -> this.listCredentialsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataSourceCredential> listCredentials(Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.listCredentialsAsync(skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataSourceCredential> listCredentials(Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.listCredentialsAsync(skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> updateCredentialWithResponseAsync(UUID credentialId, DataSourceCredentialPatch body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCredential(this.getEndpoint(), credentialId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> updateCredentialWithResponseAsync(UUID credentialId, DataSourceCredentialPatch body, Context context) {
        String accept = "application/json";
        return this.service.updateCredential(this.getEndpoint(), credentialId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataSourceCredential> updateCredentialAsync(UUID credentialId, DataSourceCredentialPatch body) {
        return this.updateCredentialWithResponseAsync(credentialId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataSourceCredential)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataSourceCredential> updateCredentialAsync(UUID credentialId, DataSourceCredentialPatch body, Context context) {
        return this.updateCredentialWithResponseAsync(credentialId, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataSourceCredential)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataSourceCredential updateCredential(UUID credentialId, DataSourceCredentialPatch body) {
        return (DataSourceCredential)this.updateCredentialAsync(credentialId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataSourceCredential> updateCredentialWithResponse(UUID credentialId, DataSourceCredentialPatch body, Context context) {
        return (Response)this.updateCredentialWithResponseAsync(credentialId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCredentialWithResponseAsync(UUID credentialId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCredential(this.getEndpoint(), credentialId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCredentialWithResponseAsync(UUID credentialId, Context context) {
        String accept = "application/json";
        return this.service.deleteCredential(this.getEndpoint(), credentialId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCredentialAsync(UUID credentialId) {
        return this.deleteCredentialWithResponseAsync(credentialId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCredentialAsync(UUID credentialId, Context context) {
        return this.deleteCredentialWithResponseAsync(credentialId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteCredential(UUID credentialId) {
        this.deleteCredentialAsync(credentialId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteCredentialWithResponse(UUID credentialId, Context context) {
        return (Response)this.deleteCredentialWithResponseAsync(credentialId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> getCredentialWithResponseAsync(UUID credentialId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCredential(this.getEndpoint(), credentialId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> getCredentialWithResponseAsync(UUID credentialId, Context context) {
        String accept = "application/json";
        return this.service.getCredential(this.getEndpoint(), credentialId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataSourceCredential> getCredentialAsync(UUID credentialId) {
        return this.getCredentialWithResponseAsync(credentialId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataSourceCredential)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataSourceCredential> getCredentialAsync(UUID credentialId, Context context) {
        return this.getCredentialWithResponseAsync(credentialId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataSourceCredential)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataSourceCredential getCredential(UUID credentialId) {
        return (DataSourceCredential)this.getCredentialAsync(credentialId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataSourceCredential> getCredentialWithResponse(UUID credentialId, Context context) {
        return (Response)this.getCredentialWithResponseAsync(credentialId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsSinglePageAsync(String dataFeedName, DataSourceType dataSourceType, Granularity granularityName, EntityStatus status, String creator, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDataFeeds(this.getEndpoint(), dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFeedList)res.getValue()).getValue(), ((DataFeedList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsSinglePageAsync(String dataFeedName, DataSourceType dataSourceType, Granularity granularityName, EntityStatus status, String creator, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.listDataFeeds(this.getEndpoint(), dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFeedList)res.getValue()).getValue(), ((DataFeedList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFeedDetail> listDataFeedsAsync(String dataFeedName, DataSourceType dataSourceType, Granularity granularityName, EntityStatus status, String creator, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.listDataFeedsSinglePageAsync(dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize), nextLink -> this.listDataFeedsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFeedDetail> listDataFeedsAsync(String dataFeedName, DataSourceType dataSourceType, Granularity granularityName, EntityStatus status, String creator, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.listDataFeedsSinglePageAsync(dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize, context), nextLink -> this.listDataFeedsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeedDetail> listDataFeeds(String dataFeedName, DataSourceType dataSourceType, Granularity granularityName, EntityStatus status, String creator, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.listDataFeedsAsync(dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeedDetail> listDataFeeds(String dataFeedName, DataSourceType dataSourceType, Granularity granularityName, EntityStatus status, String creator, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.listDataFeedsAsync(dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateDataFeedResponse> createDataFeedWithResponseAsync(DataFeedDetail body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDataFeed(this.getEndpoint(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateDataFeedResponse> createDataFeedWithResponseAsync(DataFeedDetail body, Context context) {
        String accept = "application/json";
        return this.service.createDataFeed(this.getEndpoint(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createDataFeedAsync(DataFeedDetail body) {
        return this.createDataFeedWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createDataFeedAsync(DataFeedDetail body, Context context) {
        return this.createDataFeedWithResponseAsync(body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createDataFeed(DataFeedDetail body) {
        this.createDataFeedAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createDataFeedWithResponse(DataFeedDetail body, Context context) {
        return (Response)this.createDataFeedWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> getDataFeedByIdWithResponseAsync(UUID dataFeedId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDataFeedById(this.getEndpoint(), dataFeedId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> getDataFeedByIdWithResponseAsync(UUID dataFeedId, Context context) {
        String accept = "application/json";
        return this.service.getDataFeedById(this.getEndpoint(), dataFeedId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeedDetail> getDataFeedByIdAsync(UUID dataFeedId) {
        return this.getDataFeedByIdWithResponseAsync(dataFeedId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataFeedDetail)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeedDetail> getDataFeedByIdAsync(UUID dataFeedId, Context context) {
        return this.getDataFeedByIdWithResponseAsync(dataFeedId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataFeedDetail)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFeedDetail getDataFeedById(UUID dataFeedId) {
        return (DataFeedDetail)this.getDataFeedByIdAsync(dataFeedId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFeedDetail> getDataFeedByIdWithResponse(UUID dataFeedId, Context context) {
        return (Response)this.getDataFeedByIdWithResponseAsync(dataFeedId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> updateDataFeedWithResponseAsync(UUID dataFeedId, DataFeedDetailPatch body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDataFeed(this.getEndpoint(), dataFeedId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> updateDataFeedWithResponseAsync(UUID dataFeedId, DataFeedDetailPatch body, Context context) {
        String accept = "application/json";
        return this.service.updateDataFeed(this.getEndpoint(), dataFeedId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeedDetail> updateDataFeedAsync(UUID dataFeedId, DataFeedDetailPatch body) {
        return this.updateDataFeedWithResponseAsync(dataFeedId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataFeedDetail)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeedDetail> updateDataFeedAsync(UUID dataFeedId, DataFeedDetailPatch body, Context context) {
        return this.updateDataFeedWithResponseAsync(dataFeedId, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataFeedDetail)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFeedDetail updateDataFeed(UUID dataFeedId, DataFeedDetailPatch body) {
        return (DataFeedDetail)this.updateDataFeedAsync(dataFeedId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFeedDetail> updateDataFeedWithResponse(UUID dataFeedId, DataFeedDetailPatch body, Context context) {
        return (Response)this.updateDataFeedWithResponseAsync(dataFeedId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFeedWithResponseAsync(UUID dataFeedId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDataFeed(this.getEndpoint(), dataFeedId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFeedWithResponseAsync(UUID dataFeedId, Context context) {
        String accept = "application/json";
        return this.service.deleteDataFeed(this.getEndpoint(), dataFeedId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFeedAsync(UUID dataFeedId) {
        return this.deleteDataFeedWithResponseAsync(dataFeedId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFeedAsync(UUID dataFeedId, Context context) {
        return this.deleteDataFeedWithResponseAsync(dataFeedId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataFeed(UUID dataFeedId) {
        this.deleteDataFeedAsync(dataFeedId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataFeedWithResponse(UUID dataFeedId, Context context) {
        return (Response)this.deleteDataFeedWithResponseAsync(dataFeedId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricFeedback>> getMetricFeedbackWithResponseAsync(UUID feedbackId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricFeedback(this.getEndpoint(), feedbackId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricFeedback>> getMetricFeedbackWithResponseAsync(UUID feedbackId, Context context) {
        String accept = "application/json";
        return this.service.getMetricFeedback(this.getEndpoint(), feedbackId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricFeedback> getMetricFeedbackAsync(UUID feedbackId) {
        return this.getMetricFeedbackWithResponseAsync(feedbackId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricFeedback)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricFeedback> getMetricFeedbackAsync(UUID feedbackId, Context context) {
        return this.getMetricFeedbackWithResponseAsync(feedbackId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricFeedback)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricFeedback getMetricFeedback(UUID feedbackId) {
        return (MetricFeedback)this.getMetricFeedbackAsync(feedbackId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricFeedback> getMetricFeedbackWithResponse(UUID feedbackId, Context context) {
        return (Response)this.getMetricFeedbackWithResponseAsync(feedbackId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksSinglePageAsync(MetricFeedbackFilter body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetricFeedbacks(this.getEndpoint(), skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricFeedbackList)res.getValue()).getValue(), ((MetricFeedbackList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksSinglePageAsync(MetricFeedbackFilter body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.listMetricFeedbacks(this.getEndpoint(), skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricFeedbackList)res.getValue()).getValue(), ((MetricFeedbackList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricFeedback> listMetricFeedbacksAsync(MetricFeedbackFilter body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.listMetricFeedbacksSinglePageAsync(body, skip, maxpagesize), nextLink -> this.listMetricFeedbacksNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricFeedback> listMetricFeedbacksAsync(MetricFeedbackFilter body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.listMetricFeedbacksSinglePageAsync(body, skip, maxpagesize, context), nextLink -> this.listMetricFeedbacksNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricFeedback> listMetricFeedbacks(MetricFeedbackFilter body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.listMetricFeedbacksAsync(body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricFeedback> listMetricFeedbacks(MetricFeedbackFilter body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.listMetricFeedbacksAsync(body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateMetricFeedbackResponse> createMetricFeedbackWithResponseAsync(MetricFeedback body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createMetricFeedback(this.getEndpoint(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateMetricFeedbackResponse> createMetricFeedbackWithResponseAsync(MetricFeedback body, Context context) {
        String accept = "application/json";
        return this.service.createMetricFeedback(this.getEndpoint(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createMetricFeedbackAsync(MetricFeedback body) {
        return this.createMetricFeedbackWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createMetricFeedbackAsync(MetricFeedback body, Context context) {
        return this.createMetricFeedbackWithResponseAsync(body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createMetricFeedback(MetricFeedback body) {
        this.createMetricFeedbackAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createMetricFeedbackWithResponse(MetricFeedback body, Context context) {
        return (Response)this.createMetricFeedbackWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksSinglePageAsync(String hookName, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHooks(this.getEndpoint(), hookName, skip, maxpagesize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HookList)res.getValue()).getValue(), ((HookList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksSinglePageAsync(String hookName, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.listHooks(this.getEndpoint(), hookName, skip, maxpagesize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HookList)res.getValue()).getValue(), ((HookList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<HookInfo> listHooksAsync(String hookName, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.listHooksSinglePageAsync(hookName, skip, maxpagesize), nextLink -> this.listHooksNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<HookInfo> listHooksAsync(String hookName, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.listHooksSinglePageAsync(hookName, skip, maxpagesize, context), nextLink -> this.listHooksNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HookInfo> listHooks(String hookName, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.listHooksAsync(hookName, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HookInfo> listHooks(String hookName, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.listHooksAsync(hookName, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateHookResponse> createHookWithResponseAsync(HookInfo body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createHook(this.getEndpoint(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateHookResponse> createHookWithResponseAsync(HookInfo body, Context context) {
        String accept = "application/json";
        return this.service.createHook(this.getEndpoint(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createHookAsync(HookInfo body) {
        return this.createHookWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createHookAsync(HookInfo body, Context context) {
        return this.createHookWithResponseAsync(body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createHook(HookInfo body) {
        this.createHookAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createHookWithResponse(HookInfo body, Context context) {
        return (Response)this.createHookWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HookInfo>> getHookWithResponseAsync(UUID hookId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getHook(this.getEndpoint(), hookId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HookInfo>> getHookWithResponseAsync(UUID hookId, Context context) {
        String accept = "application/json";
        return this.service.getHook(this.getEndpoint(), hookId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HookInfo> getHookAsync(UUID hookId) {
        return this.getHookWithResponseAsync(hookId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((HookInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HookInfo> getHookAsync(UUID hookId, Context context) {
        return this.getHookWithResponseAsync(hookId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((HookInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public HookInfo getHook(UUID hookId) {
        return (HookInfo)this.getHookAsync(hookId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HookInfo> getHookWithResponse(UUID hookId, Context context) {
        return (Response)this.getHookWithResponseAsync(hookId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HookInfo>> updateHookWithResponseAsync(UUID hookId, HookInfoPatch body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateHook(this.getEndpoint(), hookId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HookInfo>> updateHookWithResponseAsync(UUID hookId, HookInfoPatch body, Context context) {
        String accept = "application/json";
        return this.service.updateHook(this.getEndpoint(), hookId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HookInfo> updateHookAsync(UUID hookId, HookInfoPatch body) {
        return this.updateHookWithResponseAsync(hookId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((HookInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HookInfo> updateHookAsync(UUID hookId, HookInfoPatch body, Context context) {
        return this.updateHookWithResponseAsync(hookId, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((HookInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public HookInfo updateHook(UUID hookId, HookInfoPatch body) {
        return (HookInfo)this.updateHookAsync(hookId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HookInfo> updateHookWithResponse(UUID hookId, HookInfoPatch body, Context context) {
        return (Response)this.updateHookWithResponseAsync(hookId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHookWithResponseAsync(UUID hookId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteHook(this.getEndpoint(), hookId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHookWithResponseAsync(UUID hookId, Context context) {
        String accept = "application/json";
        return this.service.deleteHook(this.getEndpoint(), hookId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteHookAsync(UUID hookId) {
        return this.deleteHookWithResponseAsync(hookId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteHookAsync(UUID hookId, Context context) {
        return this.deleteHookWithResponseAsync(hookId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteHook(UUID hookId) {
        this.deleteHookAsync(hookId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteHookWithResponse(UUID hookId, Context context) {
        return (Response)this.deleteHookWithResponseAsync(hookId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusSinglePageAsync(UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDataFeedIngestionStatus(this.getEndpoint(), dataFeedId, skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IngestionStatusList)res.getValue()).getValue(), ((IngestionStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusSinglePageAsync(UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getDataFeedIngestionStatus(this.getEndpoint(), dataFeedId, skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IngestionStatusList)res.getValue()).getValue(), ((IngestionStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFeedIngestionStatus> getDataFeedIngestionStatusAsync(UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getDataFeedIngestionStatusSinglePageAsync(dataFeedId, body, skip, maxpagesize), nextLink -> this.getDataFeedIngestionStatusNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFeedIngestionStatus> getDataFeedIngestionStatusAsync(UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getDataFeedIngestionStatusSinglePageAsync(dataFeedId, body, skip, maxpagesize, context), nextLink -> this.getDataFeedIngestionStatusNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeedIngestionStatus> getDataFeedIngestionStatus(UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getDataFeedIngestionStatusAsync(dataFeedId, body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFeedIngestionStatus> getDataFeedIngestionStatus(UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getDataFeedIngestionStatusAsync(dataFeedId, body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetDataFeedIngestionStatusWithResponseAsync(UUID dataFeedId, IngestionProgressResetOptions body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetDataFeedIngestionStatus(this.getEndpoint(), dataFeedId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetDataFeedIngestionStatusWithResponseAsync(UUID dataFeedId, IngestionProgressResetOptions body, Context context) {
        String accept = "application/json";
        return this.service.resetDataFeedIngestionStatus(this.getEndpoint(), dataFeedId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetDataFeedIngestionStatusAsync(UUID dataFeedId, IngestionProgressResetOptions body) {
        return this.resetDataFeedIngestionStatusWithResponseAsync(dataFeedId, body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetDataFeedIngestionStatusAsync(UUID dataFeedId, IngestionProgressResetOptions body, Context context) {
        return this.resetDataFeedIngestionStatusWithResponseAsync(dataFeedId, body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetDataFeedIngestionStatus(UUID dataFeedId, IngestionProgressResetOptions body) {
        this.resetDataFeedIngestionStatusAsync(dataFeedId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetDataFeedIngestionStatusWithResponse(UUID dataFeedId, IngestionProgressResetOptions body, Context context) {
        return (Response)this.resetDataFeedIngestionStatusWithResponseAsync(dataFeedId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeedIngestionProgress>> getIngestionProgressWithResponseAsync(UUID dataFeedId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIngestionProgress(this.getEndpoint(), dataFeedId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFeedIngestionProgress>> getIngestionProgressWithResponseAsync(UUID dataFeedId, Context context) {
        String accept = "application/json";
        return this.service.getIngestionProgress(this.getEndpoint(), dataFeedId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeedIngestionProgress> getIngestionProgressAsync(UUID dataFeedId) {
        return this.getIngestionProgressWithResponseAsync(dataFeedId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataFeedIngestionProgress)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFeedIngestionProgress> getIngestionProgressAsync(UUID dataFeedId, Context context) {
        return this.getIngestionProgressWithResponseAsync(dataFeedId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DataFeedIngestionProgress)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFeedIngestionProgress getIngestionProgress(UUID dataFeedId) {
        return (DataFeedIngestionProgress)this.getIngestionProgressAsync(dataFeedId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFeedIngestionProgress> getIngestionProgressWithResponse(UUID dataFeedId, Context context) {
        return (Response)this.getIngestionProgressWithResponseAsync(dataFeedId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricDataList>> getMetricDataWithResponseAsync(UUID metricId, MetricDataQueryOptions body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricData(this.getEndpoint(), metricId, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricDataList>> getMetricDataWithResponseAsync(UUID metricId, MetricDataQueryOptions body, Context context) {
        String accept = "application/json";
        return this.service.getMetricData(this.getEndpoint(), metricId, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricDataList> getMetricDataAsync(UUID metricId, MetricDataQueryOptions body) {
        return this.getMetricDataWithResponseAsync(metricId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricDataList)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricDataList> getMetricDataAsync(UUID metricId, MetricDataQueryOptions body, Context context) {
        return this.getMetricDataWithResponseAsync(metricId, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricDataList)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricDataList getMetricData(UUID metricId, MetricDataQueryOptions body) {
        return (MetricDataList)this.getMetricDataAsync(metricId, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricDataList> getMetricDataWithResponse(UUID metricId, MetricDataQueryOptions body, Context context) {
        return (Response)this.getMetricDataWithResponseAsync(metricId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesSinglePageAsync(UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricSeries(this.getEndpoint(), metricId, skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricSeriesList)res.getValue()).getValue(), ((MetricSeriesList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesSinglePageAsync(UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getMetricSeries(this.getEndpoint(), metricId, skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricSeriesList)res.getValue()).getValue(), ((MetricSeriesList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricSeriesItem> getMetricSeriesAsync(UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getMetricSeriesSinglePageAsync(metricId, body, skip, maxpagesize), nextLink -> this.getMetricSeriesNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricSeriesItem> getMetricSeriesAsync(UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getMetricSeriesSinglePageAsync(metricId, body, skip, maxpagesize, context), nextLink -> this.getMetricSeriesNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesItem> getMetricSeries(UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getMetricSeriesAsync(metricId, body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesItem> getMetricSeries(UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getMetricSeriesAsync(metricId, body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionSinglePageAsync(UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricDimension(this.getEndpoint(), metricId, skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDimensionList)res.getValue()).getValue(), ((MetricDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionSinglePageAsync(UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getMetricDimension(this.getEndpoint(), metricId, skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDimensionList)res.getValue()).getValue(), ((MetricDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> getMetricDimensionAsync(UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getMetricDimensionSinglePageAsync(metricId, body, skip, maxpagesize), nextLink -> this.getMetricDimensionNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> getMetricDimensionAsync(UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getMetricDimensionSinglePageAsync(metricId, body, skip, maxpagesize, context), nextLink -> this.getMetricDimensionNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> getMetricDimension(UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getMetricDimensionAsync(metricId, body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> getMetricDimension(UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getMetricDimensionAsync(metricId, body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationsByMetricSinglePageAsync(UUID metricId, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomalyDetectionConfigurationsByMetric(this.getEndpoint(), metricId, skip, maxpagesize, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDetectionConfigurationList)res.getValue()).getValue(), ((AnomalyDetectionConfigurationList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationsByMetricSinglePageAsync(UUID metricId, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getAnomalyDetectionConfigurationsByMetric(this.getEndpoint(), metricId, skip, maxpagesize, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDetectionConfigurationList)res.getValue()).getValue(), ((AnomalyDetectionConfigurationList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetricAsync(UUID metricId, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getAnomalyDetectionConfigurationsByMetricSinglePageAsync(metricId, skip, maxpagesize), nextLink -> this.getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetricAsync(UUID metricId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getAnomalyDetectionConfigurationsByMetricSinglePageAsync(metricId, skip, maxpagesize, context), nextLink -> this.getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetric(UUID metricId, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getAnomalyDetectionConfigurationsByMetricAsync(metricId, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetric(UUID metricId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getAnomalyDetectionConfigurationsByMetricAsync(metricId, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricSinglePageAsync(UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEnrichmentStatusByMetric(this.getEndpoint(), metricId, skip, maxpagesize, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EnrichmentStatusList)res.getValue()).getValue(), ((EnrichmentStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricSinglePageAsync(UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize, Context context) {
        String accept = "application/json";
        return this.service.getEnrichmentStatusByMetric(this.getEndpoint(), metricId, skip, maxpagesize, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EnrichmentStatusList)res.getValue()).getValue(), ((EnrichmentStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EnrichmentStatus> getEnrichmentStatusByMetricAsync(UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize) {
        return new PagedFlux(() -> this.getEnrichmentStatusByMetricSinglePageAsync(metricId, body, skip, maxpagesize), nextLink -> this.getEnrichmentStatusByMetricNextSinglePageAsync((String)nextLink, body));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EnrichmentStatus> getEnrichmentStatusByMetricAsync(UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux(() -> this.getEnrichmentStatusByMetricSinglePageAsync(metricId, body, skip, maxpagesize, context), nextLink -> this.getEnrichmentStatusByMetricNextSinglePageAsync((String)nextLink, body, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EnrichmentStatus> getEnrichmentStatusByMetric(UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize) {
        return new PagedIterable(this.getEnrichmentStatusByMetricAsync(metricId, body, skip, maxpagesize));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EnrichmentStatus> getEnrichmentStatusByMetric(UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable(this.getEnrichmentStatusByMetricAsync(metricId, body, skip, maxpagesize, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync(String nextLink, AlertingResultQuery body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAlertsByAnomalyAlertingConfigurationNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertResultList)res.getValue()).getValue(), ((AlertResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync(String nextLink, AlertingResultQuery body, Context context) {
        String accept = "application/json";
        return this.service.getAlertsByAnomalyAlertingConfigurationNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertResultList)res.getValue()).getValue(), ((AlertResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink, DetectionAnomalyResultQuery body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomaliesByAnomalyDetectionConfigurationNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink, DetectionAnomalyResultQuery body, Context context) {
        String accept = "application/json";
        return this.service.getAnomaliesByAnomalyDetectionConfigurationNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink, AnomalyDimensionQuery body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDimensionOfAnomaliesByAnomalyDetectionConfigurationNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDimensionList)res.getValue()).getValue(), ((AnomalyDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink, AnomalyDimensionQuery body, Context context) {
        String accept = "application/json";
        return this.service.getDimensionOfAnomaliesByAnomalyDetectionConfigurationNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDimensionList)res.getValue()).getValue(), ((AnomalyDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksNextSinglePageAsync(String nextLink, MetricFeedbackFilter body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetricFeedbacksNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricFeedbackList)res.getValue()).getValue(), ((MetricFeedbackList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksNextSinglePageAsync(String nextLink, MetricFeedbackFilter body, Context context) {
        String accept = "application/json";
        return this.service.listMetricFeedbacksNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricFeedbackList)res.getValue()).getValue(), ((MetricFeedbackList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusNextSinglePageAsync(String nextLink, IngestionStatusQueryOptions body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDataFeedIngestionStatusNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IngestionStatusList)res.getValue()).getValue(), ((IngestionStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusNextSinglePageAsync(String nextLink, IngestionStatusQueryOptions body, Context context) {
        String accept = "application/json";
        return this.service.getDataFeedIngestionStatusNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IngestionStatusList)res.getValue()).getValue(), ((IngestionStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesNextSinglePageAsync(String nextLink, MetricSeriesQueryOptions body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricSeriesNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricSeriesList)res.getValue()).getValue(), ((MetricSeriesList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesNextSinglePageAsync(String nextLink, MetricSeriesQueryOptions body, Context context) {
        String accept = "application/json";
        return this.service.getMetricSeriesNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricSeriesList)res.getValue()).getValue(), ((MetricSeriesList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionNextSinglePageAsync(String nextLink, MetricDimensionQueryOptions body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricDimensionNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDimensionList)res.getValue()).getValue(), ((MetricDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionNextSinglePageAsync(String nextLink, MetricDimensionQueryOptions body, Context context) {
        String accept = "application/json";
        return this.service.getMetricDimensionNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDimensionList)res.getValue()).getValue(), ((MetricDimensionList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricNextSinglePageAsync(String nextLink, EnrichmentStatusQueryOption body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEnrichmentStatusByMetricNext(this.getEndpoint(), nextLink, body, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EnrichmentStatusList)res.getValue()).getValue(), ((EnrichmentStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricNextSinglePageAsync(String nextLink, EnrichmentStatusQueryOption body, Context context) {
        String accept = "application/json";
        return this.service.getEnrichmentStatusByMetricNext(this.getEndpoint(), nextLink, body, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EnrichmentStatusList)res.getValue()).getValue(), ((EnrichmentStatusList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomaliesFromAlertByAnomalyAlertingConfigurationNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getAnomaliesFromAlertByAnomalyAlertingConfigurationNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyResultList)res.getValue()).getValue(), ((AnomalyResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIncidentsFromAlertByAnomalyAlertingConfigurationNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getIncidentsFromAlertByAnomalyAlertingConfigurationNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyAlertingConfigurationList)res.getValue()).getValue(), ((AnomalyAlertingConfigurationList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyAlertingConfigurationList)res.getValue()).getValue(), ((AnomalyAlertingConfigurationList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIncidentsByAnomalyDetectionConfigurationNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getIncidentsByAnomalyDetectionConfigurationNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIncidentsByAnomalyDetectionConfigurationNextPagesNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getIncidentsByAnomalyDetectionConfigurationNextPagesNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentResultList)res.getValue()).getValue(), ((IncidentResultList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCredentialsNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceCredentialList)res.getValue()).getValue(), ((DataSourceCredentialList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listCredentialsNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceCredentialList)res.getValue()).getValue(), ((DataSourceCredentialList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDataFeedsNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFeedList)res.getValue()).getValue(), ((DataFeedList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listDataFeedsNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFeedList)res.getValue()).getValue(), ((DataFeedList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHooksNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HookList)res.getValue()).getValue(), ((HookList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listHooksNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HookList)res.getValue()).getValue(), ((HookList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnomalyDetectionConfigurationsByMetricNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDetectionConfigurationList)res.getValue()).getValue(), ((AnomalyDetectionConfigurationList)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getAnomalyDetectionConfigurationsByMetricNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnomalyDetectionConfigurationList)res.getValue()).getValue(), ((AnomalyDetectionConfigurationList)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}/metricsadvisor/v1.0")
    @ServiceInterface(name="AzureCognitiveServic")
    private static interface AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Service {
        @Get(value="/stats/latest")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<UsageStats>> getActiveSeriesCount(@HostParam(value="endpoint") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Get(value="/alert/anomaly/configurations/{configurationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyAlertingConfiguration>> getAnomalyAlertingConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Patch(value="/alert/anomaly/configurations/{configurationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyAlertingConfiguration>> updateAnomalyAlertingConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @BodyParam(value="application/merge-patch+json") AnomalyAlertingConfigurationPatch var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/alert/anomaly/configurations/{configurationId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<Void>> deleteAnomalyAlertingConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/alert/anomaly/configurations")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<CreateAnomalyAlertingConfigurationResponse> createAnomalyAlertingConfiguration(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") AnomalyAlertingConfiguration var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/alert/anomaly/configurations/{configurationId}/alerts/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AlertResultList>> getAlertsByAnomalyAlertingConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @BodyParam(value="application/json") AlertingResultQuery var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/alert/anomaly/configurations/{configurationId}/alerts/{alertId}/anomalies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyResultList>> getAnomaliesFromAlertByAnomalyAlertingConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @PathParam(value="alertId") String var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$maxpagesize") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/alert/anomaly/configurations/{configurationId}/alerts/{alertId}/incidents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IncidentResultList>> getIncidentsFromAlertByAnomalyAlertingConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @PathParam(value="alertId") String var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$maxpagesize") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/enrichment/anomalyDetection/configurations/{configurationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyDetectionConfiguration>> getAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Patch(value="/enrichment/anomalyDetection/configurations/{configurationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyDetectionConfiguration>> updateAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @BodyParam(value="application/merge-patch+json") AnomalyDetectionConfigurationPatch var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/enrichment/anomalyDetection/configurations/{configurationId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<Void>> deleteAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/enrichment/anomalyDetection/configurations")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<CreateAnomalyDetectionConfigurationResponse> createAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") AnomalyDetectionConfiguration var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/enrichment/anomalyDetection/configurations/{configurationId}/alert/anomaly/configurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyAlertingConfigurationList>> getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/enrichment/anomalyDetection/configurations/{configurationId}/series/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<SeriesResultList>> getSeriesByAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @BodyParam(value="application/json") DetectionSeriesQuery var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/enrichment/anomalyDetection/configurations/{configurationId}/anomalies/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyResultList>> getAnomaliesByAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @BodyParam(value="application/json") DetectionAnomalyResultQuery var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/enrichment/anomalyDetection/configurations/{configurationId}/anomalies/dimension/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyDimensionList>> getDimensionOfAnomaliesByAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @BodyParam(value="application/json") AnomalyDimensionQuery var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/enrichment/anomalyDetection/configurations/{configurationId}/incidents/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @QueryParam(value="$maxpagesize") Integer var3, @BodyParam(value="application/json") DetectionIncidentResultQuery var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/enrichment/anomalyDetection/configurations/{configurationId}/incidents/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfigurationNextPages(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @QueryParam(value="$maxpagesize") Integer var3, @QueryParam(value="$token") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/enrichment/anomalyDetection/configurations/{configurationId}/incidents/{incidentId}/rootCause")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<RootCauseList>> getRootCauseOfIncidentByAnomalyDetectionConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="configurationId") UUID var2, @PathParam(value="incidentId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/credentials")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<CreateCredentialResponse> createCredential(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") DataSourceCredential var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/credentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataSourceCredentialList>> listCredentials(@HostParam(value="endpoint") String var1, @QueryParam(value="$skip") Integer var2, @QueryParam(value="$maxpagesize") Integer var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/credentials/{credentialId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataSourceCredential>> updateCredential(@HostParam(value="endpoint") String var1, @PathParam(value="credentialId") UUID var2, @BodyParam(value="application/merge-patch+json") DataSourceCredentialPatch var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/credentials/{credentialId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<Void>> deleteCredential(@HostParam(value="endpoint") String var1, @PathParam(value="credentialId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/credentials/{credentialId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataSourceCredential>> getCredential(@HostParam(value="endpoint") String var1, @PathParam(value="credentialId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/dataFeeds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataFeedList>> listDataFeeds(@HostParam(value="endpoint") String var1, @QueryParam(value="dataFeedName") String var2, @QueryParam(value="dataSourceType") DataSourceType var3, @QueryParam(value="granularityName") Granularity var4, @QueryParam(value="status") EntityStatus var5, @QueryParam(value="creator") String var6, @QueryParam(value="$skip") Integer var7, @QueryParam(value="$maxpagesize") Integer var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/dataFeeds")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<CreateDataFeedResponse> createDataFeed(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") DataFeedDetail var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/dataFeeds/{dataFeedId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataFeedDetail>> getDataFeedById(@HostParam(value="endpoint") String var1, @PathParam(value="dataFeedId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Patch(value="/dataFeeds/{dataFeedId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataFeedDetail>> updateDataFeed(@HostParam(value="endpoint") String var1, @PathParam(value="dataFeedId") UUID var2, @BodyParam(value="application/merge-patch+json") DataFeedDetailPatch var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/dataFeeds/{dataFeedId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<Void>> deleteDataFeed(@HostParam(value="endpoint") String var1, @PathParam(value="dataFeedId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/feedback/metric/{feedbackId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricFeedback>> getMetricFeedback(@HostParam(value="endpoint") String var1, @PathParam(value="feedbackId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/feedback/metric/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricFeedbackList>> listMetricFeedbacks(@HostParam(value="endpoint") String var1, @QueryParam(value="$skip") Integer var2, @QueryParam(value="$maxpagesize") Integer var3, @BodyParam(value="application/json") MetricFeedbackFilter var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/feedback/metric")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<CreateMetricFeedbackResponse> createMetricFeedback(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") MetricFeedback var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/hooks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<HookList>> listHooks(@HostParam(value="endpoint") String var1, @QueryParam(value="hookName") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/hooks")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<CreateHookResponse> createHook(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") HookInfo var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/hooks/{hookId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<HookInfo>> getHook(@HostParam(value="endpoint") String var1, @PathParam(value="hookId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Patch(value="/hooks/{hookId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<HookInfo>> updateHook(@HostParam(value="endpoint") String var1, @PathParam(value="hookId") UUID var2, @BodyParam(value="application/merge-patch+json") HookInfoPatch var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/hooks/{hookId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<Void>> deleteHook(@HostParam(value="endpoint") String var1, @PathParam(value="hookId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/dataFeeds/{dataFeedId}/ingestionStatus/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IngestionStatusList>> getDataFeedIngestionStatus(@HostParam(value="endpoint") String var1, @PathParam(value="dataFeedId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @BodyParam(value="application/json") IngestionStatusQueryOptions var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/dataFeeds/{dataFeedId}/ingestionProgress/reset")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<Void>> resetDataFeedIngestionStatus(@HostParam(value="endpoint") String var1, @PathParam(value="dataFeedId") UUID var2, @BodyParam(value="application/json") IngestionProgressResetOptions var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/dataFeeds/{dataFeedId}/ingestionProgress")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataFeedIngestionProgress>> getIngestionProgress(@HostParam(value="endpoint") String var1, @PathParam(value="dataFeedId") UUID var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/metrics/{metricId}/data/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricDataList>> getMetricData(@HostParam(value="endpoint") String var1, @PathParam(value="metricId") UUID var2, @BodyParam(value="application/json") MetricDataQueryOptions var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/metrics/{metricId}/series/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricSeriesList>> getMetricSeries(@HostParam(value="endpoint") String var1, @PathParam(value="metricId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @BodyParam(value="application/json") MetricSeriesQueryOptions var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/metrics/{metricId}/dimension/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricDimensionList>> getMetricDimension(@HostParam(value="endpoint") String var1, @PathParam(value="metricId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @BodyParam(value="application/json") MetricDimensionQueryOptions var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/metrics/{metricId}/enrichment/anomalyDetection/configurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyDetectionConfigurationList>> getAnomalyDetectionConfigurationsByMetric(@HostParam(value="endpoint") String var1, @PathParam(value="metricId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/metrics/{metricId}/status/enrichment/anomalyDetection/query")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<EnrichmentStatusList>> getEnrichmentStatusByMetric(@HostParam(value="endpoint") String var1, @PathParam(value="metricId") UUID var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$maxpagesize") Integer var4, @BodyParam(value="application/json") EnrichmentStatusQueryOption var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AlertResultList>> getAlertsByAnomalyAlertingConfigurationNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") AlertingResultQuery var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyResultList>> getAnomaliesByAnomalyDetectionConfigurationNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") DetectionAnomalyResultQuery var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyDimensionList>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") AnomalyDimensionQuery var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricFeedbackList>> listMetricFeedbacksNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") MetricFeedbackFilter var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IngestionStatusList>> getDataFeedIngestionStatusNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") IngestionStatusQueryOptions var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricSeriesList>> getMetricSeriesNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") MetricSeriesQueryOptions var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<MetricDimensionList>> getMetricDimensionNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") MetricDimensionQueryOptions var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<EnrichmentStatusList>> getEnrichmentStatusByMetricNext(@HostParam(value="endpoint") String var1, @PathParam(value="nextLink", encoded=true) String var2, @BodyParam(value="application/json") EnrichmentStatusQueryOption var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyResultList>> getAnomaliesFromAlertByAnomalyAlertingConfigurationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IncidentResultList>> getIncidentsFromAlertByAnomalyAlertingConfigurationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyAlertingConfigurationList>> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfigurationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfigurationNextPagesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataSourceCredentialList>> listCredentialsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<DataFeedList>> listDataFeedsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<HookList>> listHooksNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MetricsAdvisorResponseException.class)
        public Mono<Response<AnomalyDetectionConfigurationList>> getAnomalyDetectionConfigurationsByMetricNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

