/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.administration.models.AnomalyAlertConfiguration;
import com.azure.ai.metricsadvisor.administration.models.BoundaryDirection;
import com.azure.ai.metricsadvisor.administration.models.BoundaryMeasureType;
import com.azure.ai.metricsadvisor.administration.models.MetricAlertConfiguration;
import com.azure.ai.metricsadvisor.administration.models.MetricAlertConfigurationsOperator;
import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertConditions;
import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertScope;
import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertScopeType;
import com.azure.ai.metricsadvisor.administration.models.MetricAnomalyAlertSnoozeCondition;
import com.azure.ai.metricsadvisor.administration.models.MetricBoundaryCondition;
import com.azure.ai.metricsadvisor.administration.models.TopNGroupScope;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfigurationLogicType;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyScope;
import com.azure.ai.metricsadvisor.implementation.models.DimensionGroupIdentity;
import com.azure.ai.metricsadvisor.implementation.models.Direction;
import com.azure.ai.metricsadvisor.implementation.models.MetricAlertingConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.SeverityCondition;
import com.azure.ai.metricsadvisor.implementation.models.ValueCondition;
import com.azure.ai.metricsadvisor.implementation.models.ValueType;
import com.azure.ai.metricsadvisor.implementation.util.AnomalyAlertConfigurationHelper;
import com.azure.ai.metricsadvisor.implementation.util.MetricBoundaryConditionHelper;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public final class AlertConfigurationTransforms {
    private static final ClientLogger LOGGER = new ClientLogger(AlertConfigurationTransforms.class);

    private AlertConfigurationTransforms() {
    }

    public static AnomalyAlertingConfiguration toInnerForCreate(AnomalyAlertConfiguration alertConfiguration) {
        List<String> dimensions;
        AnomalyAlertingConfiguration innerAlertConfiguration = new AnomalyAlertingConfiguration();
        innerAlertConfiguration.setName(alertConfiguration.getName());
        innerAlertConfiguration.setDescription(alertConfiguration.getDescription());
        innerAlertConfiguration.setCrossMetricsOperator(alertConfiguration.getCrossMetricsOperator() == null ? null : AnomalyAlertingConfigurationLogicType.fromString(alertConfiguration.getCrossMetricsOperator().toString()));
        List<String> rawIds = AnomalyAlertConfigurationHelper.getHookIdsToAlertRaw(alertConfiguration);
        if (rawIds != null) {
            innerAlertConfiguration.setHookIds(rawIds.stream().map(UUID::fromString).collect(Collectors.toList()));
        }
        if ((dimensions = AnomalyAlertConfigurationHelper.getDimensionsToSplitAlertRaw(alertConfiguration)) != null) {
            innerAlertConfiguration.setSplitAlertByDimensions(dimensions);
        }
        List<MetricAlertingConfiguration> innerMetricAlertConfigurations = AlertConfigurationTransforms.getMetricAlertConfigList(alertConfiguration.getMetricAlertConfigurations());
        innerAlertConfiguration.setMetricAlertingConfigurations(innerMetricAlertConfigurations);
        return innerAlertConfiguration;
    }

    public static AnomalyAlertingConfigurationPatch toInnerForUpdate(AnomalyAlertConfiguration alertConfiguration) {
        List<String> dimensions;
        AnomalyAlertingConfigurationPatch innerAlertConfiguration = new AnomalyAlertingConfigurationPatch();
        innerAlertConfiguration.setName(alertConfiguration.getName());
        innerAlertConfiguration.setDescription(alertConfiguration.getDescription());
        innerAlertConfiguration.setCrossMetricsOperator(alertConfiguration.getCrossMetricsOperator() == null ? null : AnomalyAlertingConfigurationLogicType.fromString(alertConfiguration.getCrossMetricsOperator().toString()));
        List<String> rawIds = AnomalyAlertConfigurationHelper.getHookIdsToAlertRaw(alertConfiguration);
        if (rawIds != null) {
            innerAlertConfiguration.setHookIds(rawIds.stream().map(UUID::fromString).collect(Collectors.toList()));
        }
        if ((dimensions = AnomalyAlertConfigurationHelper.getDimensionsToSplitAlertRaw(alertConfiguration)) != null) {
            innerAlertConfiguration.setSplitAlertByDimensions(dimensions);
        }
        List<MetricAlertingConfiguration> innerMetricAlertConfigurations = AlertConfigurationTransforms.getMetricAlertConfigList(alertConfiguration.getMetricAlertConfigurations());
        innerAlertConfiguration.setMetricAlertingConfigurations(innerMetricAlertConfigurations);
        return innerAlertConfiguration;
    }

    private static List<MetricAlertingConfiguration> getMetricAlertConfigList(List<MetricAlertConfiguration> metricAlertConfigurations) {
        ArrayList<MetricAlertingConfiguration> innerMetricAlertConfigurations = new ArrayList<MetricAlertingConfiguration>();
        for (MetricAlertConfiguration metricAnomalyAlertConfiguration : metricAlertConfigurations) {
            MetricAlertingConfiguration innerMetricAlertConfiguration = new MetricAlertingConfiguration();
            innerMetricAlertConfiguration.setAnomalyDetectionConfigurationId(UUID.fromString(metricAnomalyAlertConfiguration.getDetectionConfigurationId()));
            innerMetricAlertConfiguration.setNegationOperation(metricAnomalyAlertConfiguration.isNegationOperationEnabled());
            MetricAnomalyAlertScope alertScope = metricAnomalyAlertConfiguration.getAlertScope();
            if (alertScope.getScopeType() == MetricAnomalyAlertScopeType.WHOLE_SERIES) {
                innerMetricAlertConfiguration.setAnomalyScopeType(AnomalyScope.ALL);
            } else if (alertScope.getScopeType() == MetricAnomalyAlertScopeType.SERIES_GROUP) {
                innerMetricAlertConfiguration.setAnomalyScopeType(AnomalyScope.DIMENSION);
                DimensionGroupIdentity innerId = new DimensionGroupIdentity().setDimension(metricAnomalyAlertConfiguration.getAlertScope().getSeriesGroupInScope().asMap());
                innerMetricAlertConfiguration.setDimensionAnomalyScope(innerId);
            } else if (alertScope.getScopeType() == MetricAnomalyAlertScopeType.TOP_N) {
                innerMetricAlertConfiguration.setAnomalyScopeType(AnomalyScope.TOPN);
                com.azure.ai.metricsadvisor.implementation.models.TopNGroupScope innerTopNGroupScope = new com.azure.ai.metricsadvisor.implementation.models.TopNGroupScope().setTop(alertScope.getTopNGroupInScope().getTop()).setPeriod(alertScope.getTopNGroupInScope().getPeriod()).setMinTopCount(alertScope.getTopNGroupInScope().getMinTopCount());
                innerMetricAlertConfiguration.setTopNAnomalyScope(innerTopNGroupScope);
            }
            MetricAnomalyAlertConditions alertConditions = metricAnomalyAlertConfiguration.getAlertConditions();
            if (alertConditions != null) {
                if (alertConditions.getSeverityCondition() != null) {
                    innerMetricAlertConfiguration.setSeverityFilter(new SeverityCondition().setMaxAlertSeverity(alertConditions.getSeverityCondition().getMinAlertSeverity()).setMaxAlertSeverity(alertConditions.getSeverityCondition().getMaxAlertSeverity()));
                }
                MetricBoundaryCondition boundaryConditions = alertConditions.getMetricBoundaryCondition();
                ValueCondition innerValueCondition = new ValueCondition();
                if (boundaryConditions != null) {
                    BoundaryDirection direction = boundaryConditions.getDirection();
                    if (direction == BoundaryDirection.LOWER) {
                        innerValueCondition.setDirection(Direction.DOWN);
                    } else if (direction == BoundaryDirection.UPPER) {
                        innerValueCondition.setDirection(Direction.UP);
                    } else if (direction == BoundaryDirection.BOTH) {
                        innerValueCondition.setDirection(Direction.BOTH);
                    } else {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Unexpected value: " + (Object)((Object)direction)));
                    }
                    innerValueCondition.setLower(boundaryConditions.getLowerBoundary());
                    innerValueCondition.setUpper(boundaryConditions.getUpperBoundary());
                    if (boundaryConditions.getCompanionMetricId() != null) {
                        innerValueCondition.setMetricId(UUID.fromString(boundaryConditions.getCompanionMetricId()));
                        innerValueCondition.setTriggerForMissing(boundaryConditions.shouldAlertIfDataPointMissing());
                    }
                    if (boundaryConditions.getMeasureType() != null) {
                        innerValueCondition.setType(ValueType.fromString(boundaryConditions.getMeasureType().toString()));
                    }
                    innerMetricAlertConfiguration.setValueFilter(innerValueCondition);
                }
            }
            if (metricAnomalyAlertConfiguration.getAlertSnoozeCondition() != null) {
                com.azure.ai.metricsadvisor.implementation.models.MetricAnomalyAlertSnoozeCondition innerSnoozeCondition = new com.azure.ai.metricsadvisor.implementation.models.MetricAnomalyAlertSnoozeCondition();
                innerSnoozeCondition.setAutoSnooze(metricAnomalyAlertConfiguration.getAlertSnoozeCondition().getAutoSnooze()).setSnoozeScope(metricAnomalyAlertConfiguration.getAlertSnoozeCondition().getSnoozeScope()).setOnlyForSuccessive(metricAnomalyAlertConfiguration.getAlertSnoozeCondition().isOnlyForSuccessive());
                innerMetricAlertConfiguration.setSnoozeFilter(innerSnoozeCondition);
            }
            innerMetricAlertConfigurations.add(innerMetricAlertConfiguration);
        }
        return innerMetricAlertConfigurations;
    }

    public static PagedResponse<AnomalyAlertConfiguration> fromInnerPagedResponse(PagedResponse<AnomalyAlertingConfiguration> innerResponse) {
        List innerConfigurationList = innerResponse.getValue();
        List<Object> configurationList = innerConfigurationList != null ? innerConfigurationList.stream().map(innerConfiguration -> AlertConfigurationTransforms.fromInner(innerConfiguration)).collect(Collectors.toList()) : new ArrayList();
        return new PagedResponseBase(innerResponse.getRequest(), innerResponse.getStatusCode(), innerResponse.getHeaders(), configurationList, (String)innerResponse.getContinuationToken(), null);
    }

    public static AnomalyAlertConfiguration fromInner(AnomalyAlertingConfiguration innerAlertConfiguration) {
        AnomalyAlertConfiguration alertConfiguration = innerAlertConfiguration.getCrossMetricsOperator() == null ? new AnomalyAlertConfiguration(innerAlertConfiguration.getName()) : new AnomalyAlertConfiguration(innerAlertConfiguration.getName(), MetricAlertConfigurationsOperator.fromString(innerAlertConfiguration.getCrossMetricsOperator().toString()));
        AnomalyAlertConfigurationHelper.setId(alertConfiguration, innerAlertConfiguration.getAnomalyAlertingConfigurationId().toString());
        alertConfiguration.setDescription(innerAlertConfiguration.getDescription());
        alertConfiguration.setHookIdsToAlert(innerAlertConfiguration.getHookIds().stream().map(UUID::toString).collect(Collectors.toList()));
        List<MetricAlertingConfiguration> innerMetricAlertConfigurations = innerAlertConfiguration.getMetricAlertingConfigurations();
        if (innerMetricAlertConfigurations != null) {
            ArrayList<MetricAlertConfiguration> metricAlertConfigurations = new ArrayList<MetricAlertConfiguration>();
            for (MetricAlertingConfiguration innerMetricAlertConfiguration : innerMetricAlertConfigurations) {
                com.azure.ai.metricsadvisor.implementation.models.MetricAnomalyAlertSnoozeCondition innerSnoozeCondition;
                MetricAnomalyAlertScope alertScope = null;
                if (innerMetricAlertConfiguration.getAnomalyScopeType() == AnomalyScope.ALL) {
                    alertScope = MetricAnomalyAlertScope.forWholeSeries();
                } else if (innerMetricAlertConfiguration.getAnomalyScopeType() == AnomalyScope.DIMENSION) {
                    DimensionKey seriesGroupId = new DimensionKey();
                    for (Map.Entry<String, String> entry : innerMetricAlertConfiguration.getDimensionAnomalyScope().getDimension().entrySet()) {
                        seriesGroupId.put(entry.getKey(), entry.getValue());
                    }
                    alertScope = MetricAnomalyAlertScope.forSeriesGroup(seriesGroupId);
                } else if (innerMetricAlertConfiguration.getAnomalyScopeType() == AnomalyScope.TOPN) {
                    com.azure.ai.metricsadvisor.implementation.models.TopNGroupScope innerTopNGroupScope = innerMetricAlertConfiguration.getTopNAnomalyScope();
                    alertScope = MetricAnomalyAlertScope.forTopNGroup(new TopNGroupScope(innerTopNGroupScope.getTop(), innerTopNGroupScope.getPeriod(), innerTopNGroupScope.getMinTopCount()));
                }
                MetricAlertConfiguration metricAlertConfiguration = new MetricAlertConfiguration(innerMetricAlertConfiguration.getAnomalyDetectionConfigurationId().toString(), alertScope, innerMetricAlertConfiguration.isNegationOperation());
                if (innerMetricAlertConfiguration.getSeverityFilter() != null || innerMetricAlertConfiguration.getValueFilter() != null) {
                    ValueCondition innerValueCondition;
                    MetricAnomalyAlertConditions alertConditions = new MetricAnomalyAlertConditions();
                    if (innerMetricAlertConfiguration.getSeverityFilter() != null) {
                        alertConditions.setSeverityRangeCondition(new com.azure.ai.metricsadvisor.administration.models.SeverityCondition(innerMetricAlertConfiguration.getSeverityFilter().getMinAlertSeverity(), innerMetricAlertConfiguration.getSeverityFilter().getMaxAlertSeverity()));
                    }
                    if ((innerValueCondition = innerMetricAlertConfiguration.getValueFilter()) != null) {
                        MetricBoundaryCondition boundaryCondition = new MetricBoundaryCondition();
                        MetricBoundaryConditionHelper.setLowerBoundary(boundaryCondition, innerValueCondition.getLower());
                        MetricBoundaryConditionHelper.setUpperBoundary(boundaryCondition, innerValueCondition.getUpper());
                        if (innerValueCondition.getDirection() == Direction.DOWN) {
                            MetricBoundaryConditionHelper.setBoundaryDirection(boundaryCondition, BoundaryDirection.LOWER);
                        } else if (innerValueCondition.getDirection() == Direction.UP) {
                            MetricBoundaryConditionHelper.setBoundaryDirection(boundaryCondition, BoundaryDirection.UPPER);
                        } else if (innerValueCondition.getDirection() == Direction.BOTH) {
                            MetricBoundaryConditionHelper.setBoundaryDirection(boundaryCondition, BoundaryDirection.BOTH);
                        }
                        if (innerValueCondition.getMetricId() != null) {
                            boolean triggerIfMissing = innerValueCondition.isTriggerForMissing() != null && innerValueCondition.isTriggerForMissing() != false;
                            boundaryCondition.setCompanionMetricId(innerValueCondition.getMetricId().toString(), triggerIfMissing);
                        }
                        if (innerValueCondition.getType() != null) {
                            boundaryCondition.setMeasureType(BoundaryMeasureType.fromString(innerValueCondition.getType().toString()));
                        }
                        alertConditions.setMetricBoundaryCondition(boundaryCondition);
                    }
                    metricAlertConfiguration.setAlertConditions(alertConditions);
                }
                if ((innerSnoozeCondition = innerMetricAlertConfiguration.getSnoozeFilter()) != null) {
                    metricAlertConfiguration.setAlertSnoozeCondition(new MetricAnomalyAlertSnoozeCondition(innerSnoozeCondition.getAutoSnooze(), innerSnoozeCondition.getSnoozeScope(), innerSnoozeCondition.isOnlyForSuccessive()));
                }
                metricAlertConfigurations.add(metricAlertConfiguration);
            }
            alertConfiguration.setMetricAlertConfigurations(metricAlertConfigurations);
        }
        return alertConfiguration;
    }
}

