/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.administration.models.AnomalySeverity;
import com.azure.ai.metricsadvisor.models.AnomalyStatus;
import com.azure.ai.metricsadvisor.models.DataPointAnomaly;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import java.time.OffsetDateTime;

public final class AnomalyHelper {
    private static AnomalyAccessor accessor;

    private AnomalyHelper() {
    }

    public static void setAccessor(AnomalyAccessor anomalyAccessor) {
        accessor = anomalyAccessor;
    }

    static void setDataFeedId(DataPointAnomaly anomaly, String dataFeedId) {
        accessor.setDataFeedId(anomaly, dataFeedId);
    }

    static void setMetricId(DataPointAnomaly anomaly, String metricId) {
        accessor.setMetricId(anomaly, metricId);
    }

    static void setSeriesKey(DataPointAnomaly anomaly, DimensionKey seriesKey) {
        accessor.setSeriesKey(anomaly, seriesKey);
    }

    static void setDetectionConfigurationId(DataPointAnomaly anomaly, String detectionConfigurationId) {
        accessor.setDetectionConfigurationId(anomaly, detectionConfigurationId);
    }

    static void setSeverity(DataPointAnomaly anomaly, AnomalySeverity severity) {
        accessor.setSeverity(anomaly, severity);
    }

    static void setStatus(DataPointAnomaly anomaly, AnomalyStatus status) {
        accessor.setStatus(anomaly, status);
    }

    static void setTimeStamp(DataPointAnomaly anomaly, OffsetDateTime timeStamp) {
        accessor.setTimeStamp(anomaly, timeStamp);
    }

    static void setCreatedTime(DataPointAnomaly anomaly, OffsetDateTime createdTime) {
        accessor.setCreatedTime(anomaly, createdTime);
    }

    static void setModifiedTime(DataPointAnomaly anomaly, OffsetDateTime modifiedTime) {
        accessor.setModifiedTime(anomaly, modifiedTime);
    }

    static void setValue(DataPointAnomaly anomaly, Double value) {
        accessor.setValue(anomaly, value);
    }

    static void setExpectedValue(DataPointAnomaly anomaly, Double value) {
        accessor.setExpectedValue(anomaly, value);
    }

    public static interface AnomalyAccessor {
        public void setDataFeedId(DataPointAnomaly var1, String var2);

        public void setMetricId(DataPointAnomaly var1, String var2);

        public void setSeriesKey(DataPointAnomaly var1, DimensionKey var2);

        public void setDetectionConfigurationId(DataPointAnomaly var1, String var2);

        public void setSeverity(DataPointAnomaly var1, AnomalySeverity var2);

        public void setStatus(DataPointAnomaly var1, AnomalyStatus var2);

        public void setTimeStamp(DataPointAnomaly var1, OffsetDateTime var2);

        public void setCreatedTime(DataPointAnomaly var1, OffsetDateTime var2);

        public void setModifiedTime(DataPointAnomaly var1, OffsetDateTime var2);

        public void setValue(DataPointAnomaly var1, Double var2);

        public void setExpectedValue(DataPointAnomaly var1, Double var2);
    }
}

