/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.administration.models.DataSourceCredentialEntity;
import com.azure.ai.metricsadvisor.administration.models.DataSourceDataLakeGen2SharedKey;
import com.azure.ai.metricsadvisor.administration.models.DataSourceServicePrincipal;
import com.azure.ai.metricsadvisor.administration.models.DataSourceServicePrincipalInKeyVault;
import com.azure.ai.metricsadvisor.administration.models.DataSourceSqlServerConnectionString;
import com.azure.ai.metricsadvisor.implementation.models.AzureSQLConnectionStringCredential;
import com.azure.ai.metricsadvisor.implementation.models.AzureSQLConnectionStringCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.AzureSQLConnectionStringParam;
import com.azure.ai.metricsadvisor.implementation.models.AzureSQLConnectionStringParamPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataLakeGen2SharedKeyCredential;
import com.azure.ai.metricsadvisor.implementation.models.DataLakeGen2SharedKeyCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataLakeGen2SharedKeyParam;
import com.azure.ai.metricsadvisor.implementation.models.DataLakeGen2SharedKeyParamPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredential;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalCredential;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalInKVCredential;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalInKVCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalInKVParam;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalInKVParamPatch;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalParam;
import com.azure.ai.metricsadvisor.implementation.models.ServicePrincipalParamPatch;
import com.azure.ai.metricsadvisor.implementation.util.DataSourceDataLakeGen2SharedKeyAccessor;
import com.azure.ai.metricsadvisor.implementation.util.DataSourceServicePrincipalAccessor;
import com.azure.ai.metricsadvisor.implementation.util.DataSourceServicePrincipalInKeyVaultAccessor;
import com.azure.ai.metricsadvisor.implementation.util.DataSourceSqlServerConnectionStringAccessor;
import com.azure.core.util.logging.ClientLogger;

public final class DataSourceCredentialEntityTransforms {
    private static final ClientLogger LOGGER = new ClientLogger(DataSourceCredentialEntityTransforms.class);

    private DataSourceCredentialEntityTransforms() {
    }

    public static DataSourceCredentialEntity fromInner(DataSourceCredential innerCredential) {
        if (innerCredential instanceof AzureSQLConnectionStringCredential) {
            AzureSQLConnectionStringCredential sqlConnectionStringCredential = (AzureSQLConnectionStringCredential)innerCredential;
            DataSourceSqlServerConnectionString credentialEntity = new DataSourceSqlServerConnectionString(sqlConnectionStringCredential.getDataSourceCredentialName(), null);
            DataSourceSqlServerConnectionStringAccessor.setId(credentialEntity, sqlConnectionStringCredential.getDataSourceCredentialId().toString());
            credentialEntity.setDescription(sqlConnectionStringCredential.getDataSourceCredentialDescription());
            return credentialEntity;
        }
        if (innerCredential instanceof DataLakeGen2SharedKeyCredential) {
            DataLakeGen2SharedKeyCredential dataLakeGen2SharedKeyCredential = (DataLakeGen2SharedKeyCredential)innerCredential;
            DataSourceDataLakeGen2SharedKey credentialEntity = new DataSourceDataLakeGen2SharedKey(dataLakeGen2SharedKeyCredential.getDataSourceCredentialName(), null);
            DataSourceDataLakeGen2SharedKeyAccessor.setId(credentialEntity, dataLakeGen2SharedKeyCredential.getDataSourceCredentialId().toString());
            credentialEntity.setDescription(dataLakeGen2SharedKeyCredential.getDataSourceCredentialDescription());
            return credentialEntity;
        }
        if (innerCredential instanceof ServicePrincipalCredential) {
            ServicePrincipalCredential servicePrincipalCredential = (ServicePrincipalCredential)innerCredential;
            DataSourceServicePrincipal credentialEntity = new DataSourceServicePrincipal(servicePrincipalCredential.getDataSourceCredentialName(), servicePrincipalCredential.getParameters().getClientId(), servicePrincipalCredential.getParameters().getTenantId(), null);
            DataSourceServicePrincipalAccessor.setId(credentialEntity, servicePrincipalCredential.getDataSourceCredentialId().toString());
            credentialEntity.setDescription(servicePrincipalCredential.getDataSourceCredentialDescription());
            return credentialEntity;
        }
        if (innerCredential instanceof ServicePrincipalInKVCredential) {
            ServicePrincipalInKVCredential servicePrincipalInKVCredential = (ServicePrincipalInKVCredential)innerCredential;
            DataSourceServicePrincipalInKeyVault credentialEntity = new DataSourceServicePrincipalInKeyVault();
            credentialEntity.setName(servicePrincipalInKVCredential.getDataSourceCredentialName()).setDescription(servicePrincipalInKVCredential.getDataSourceCredentialDescription()).setKeyVaultForDataSourceSecrets(servicePrincipalInKVCredential.getParameters().getKeyVaultEndpoint(), servicePrincipalInKVCredential.getParameters().getKeyVaultClientId(), null).setTenantId(servicePrincipalInKVCredential.getParameters().getTenantId()).setSecretNameForDataSourceClientId(servicePrincipalInKVCredential.getParameters().getServicePrincipalIdNameInKV()).setSecretNameForDataSourceClientSecret(servicePrincipalInKVCredential.getParameters().getServicePrincipalSecretNameInKV());
            DataSourceServicePrincipalInKeyVaultAccessor.setId(credentialEntity, servicePrincipalInKVCredential.getDataSourceCredentialId().toString());
            return credentialEntity;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown inner credential type."));
    }

    public static DataSourceCredential toInnerForCreate(DataSourceCredentialEntity credentialEntity) {
        if (credentialEntity instanceof DataSourceSqlServerConnectionString) {
            DataSourceSqlServerConnectionString credential = (DataSourceSqlServerConnectionString)credentialEntity;
            AzureSQLConnectionStringCredential innerCredential = new AzureSQLConnectionStringCredential();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new AzureSQLConnectionStringParam().setConnectionString(DataSourceSqlServerConnectionStringAccessor.getConnectionString(credential)));
            return innerCredential;
        }
        if (credentialEntity instanceof DataSourceDataLakeGen2SharedKey) {
            DataSourceDataLakeGen2SharedKey credential = (DataSourceDataLakeGen2SharedKey)credentialEntity;
            DataLakeGen2SharedKeyCredential innerCredential = new DataLakeGen2SharedKeyCredential();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new DataLakeGen2SharedKeyParam().setAccountKey(DataSourceDataLakeGen2SharedKeyAccessor.getSharedKey(credential)));
            return innerCredential;
        }
        if (credentialEntity instanceof DataSourceServicePrincipal) {
            DataSourceServicePrincipal credential = (DataSourceServicePrincipal)credentialEntity;
            ServicePrincipalCredential innerCredential = new ServicePrincipalCredential();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new ServicePrincipalParam().setClientId(credential.getClientId()).setTenantId(credential.getTenantId()).setClientSecret(DataSourceServicePrincipalAccessor.getClientSecret(credential)));
            return innerCredential;
        }
        if (credentialEntity instanceof DataSourceServicePrincipalInKeyVault) {
            DataSourceServicePrincipalInKeyVault credential = (DataSourceServicePrincipalInKeyVault)credentialEntity;
            ServicePrincipalInKVCredential innerCredential = new ServicePrincipalInKVCredential();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new ServicePrincipalInKVParam().setKeyVaultEndpoint(credential.getKeyVaultEndpoint()).setKeyVaultClientId(credential.getKeyVaultClientId()).setKeyVaultClientSecret(DataSourceServicePrincipalInKeyVaultAccessor.getKeyVaultClientSecret(credential)).setServicePrincipalIdNameInKV(credential.getSecretNameForDataSourceClientId()).setServicePrincipalSecretNameInKV(credential.getSecretNameForDataSourceClientSecret()).setTenantId(credential.getTenantId()));
            return innerCredential;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown credential entity type."));
    }

    public static DataSourceCredentialPatch toInnerForUpdate(DataSourceCredentialEntity credentialEntity) {
        if (credentialEntity instanceof DataSourceSqlServerConnectionString) {
            DataSourceSqlServerConnectionString credential = (DataSourceSqlServerConnectionString)credentialEntity;
            AzureSQLConnectionStringCredentialPatch innerCredential = new AzureSQLConnectionStringCredentialPatch();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new AzureSQLConnectionStringParamPatch().setConnectionString(DataSourceSqlServerConnectionStringAccessor.getConnectionString(credential)));
            return innerCredential;
        }
        if (credentialEntity instanceof DataSourceDataLakeGen2SharedKey) {
            DataSourceDataLakeGen2SharedKey credential = (DataSourceDataLakeGen2SharedKey)credentialEntity;
            DataLakeGen2SharedKeyCredentialPatch innerCredential = new DataLakeGen2SharedKeyCredentialPatch();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new DataLakeGen2SharedKeyParamPatch().setAccountKey(DataSourceDataLakeGen2SharedKeyAccessor.getSharedKey(credential)));
            return innerCredential;
        }
        if (credentialEntity instanceof DataSourceServicePrincipal) {
            DataSourceServicePrincipal credential = (DataSourceServicePrincipal)credentialEntity;
            ServicePrincipalCredentialPatch innerCredential = new ServicePrincipalCredentialPatch();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new ServicePrincipalParamPatch().setClientId(credential.getClientId()).setTenantId(credential.getTenantId()).setClientSecret(DataSourceServicePrincipalAccessor.getClientSecret(credential)));
            return innerCredential;
        }
        if (credentialEntity instanceof DataSourceServicePrincipalInKeyVault) {
            DataSourceServicePrincipalInKeyVault credential = (DataSourceServicePrincipalInKeyVault)credentialEntity;
            ServicePrincipalInKVCredentialPatch innerCredential = new ServicePrincipalInKVCredentialPatch();
            innerCredential.setDataSourceCredentialName(credentialEntity.getName());
            innerCredential.setDataSourceCredentialDescription(credentialEntity.getDescription());
            innerCredential.setParameters(new ServicePrincipalInKVParamPatch().setKeyVaultEndpoint(credential.getKeyVaultEndpoint()).setKeyVaultClientId(credential.getKeyVaultClientId()).setKeyVaultClientSecret(DataSourceServicePrincipalInKeyVaultAccessor.getKeyVaultClientSecret(credential)).setServicePrincipalIdNameInKV(credential.getSecretNameForDataSourceClientId()).setServicePrincipalSecretNameInKV(credential.getSecretNameForDataSourceClientSecret()).setTenantId(credential.getTenantId()));
            return innerCredential;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown credential entity type."));
    }
}

