/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.administration.models.DetectionConditionOperator;
import com.azure.ai.metricsadvisor.administration.models.HardThresholdCondition;
import com.azure.ai.metricsadvisor.administration.models.MetricSeriesGroupDetectionCondition;
import com.azure.ai.metricsadvisor.administration.models.MetricSingleSeriesDetectionCondition;
import com.azure.ai.metricsadvisor.administration.models.MetricWholeSeriesDetectionCondition;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfigurationLogicType;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.ChangeThresholdCondition;
import com.azure.ai.metricsadvisor.implementation.models.ChangeThresholdConditionPatch;
import com.azure.ai.metricsadvisor.implementation.models.DimensionGroupConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.DimensionGroupIdentity;
import com.azure.ai.metricsadvisor.implementation.models.HardThresholdConditionPatch;
import com.azure.ai.metricsadvisor.implementation.models.SeriesConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.SeriesIdentity;
import com.azure.ai.metricsadvisor.implementation.models.SmartDetectionCondition;
import com.azure.ai.metricsadvisor.implementation.models.SmartDetectionConditionPatch;
import com.azure.ai.metricsadvisor.implementation.models.SuppressCondition;
import com.azure.ai.metricsadvisor.implementation.models.SuppressConditionPatch;
import com.azure.ai.metricsadvisor.implementation.models.WholeMetricConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.WholeMetricConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.util.AnomalyDetectionConfigurationHelper;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DetectionConfigurationTransforms {
    private DetectionConfigurationTransforms() {
    }

    public static PagedResponse<com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration> fromInnerPagedResponse(PagedResponse<AnomalyDetectionConfiguration> innerResponse) {
        List innerConfigurationList = innerResponse.getValue();
        List<Object> configurationList = innerConfigurationList != null ? innerConfigurationList.stream().map(innerConfiguration -> DetectionConfigurationTransforms.fromInner(innerConfiguration)).collect(Collectors.toList()) : new ArrayList();
        return new PagedResponseBase(innerResponse.getRequest(), innerResponse.getStatusCode(), innerResponse.getHeaders(), configurationList, (String)innerResponse.getContinuationToken(), null);
    }

    public static com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration fromInner(AnomalyDetectionConfiguration innerConfiguration) {
        List<SeriesConfiguration> innerSeriesConfigurationsList;
        List<DimensionGroupConfiguration> innerSeriesGroupConfigurationsList;
        com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration configuration = new com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration(innerConfiguration.getName());
        AnomalyDetectionConfigurationHelper.setId(configuration, innerConfiguration.getAnomalyDetectionConfigurationId().toString());
        AnomalyDetectionConfigurationHelper.setMetricId(configuration, innerConfiguration.getMetricId().toString());
        configuration.setDescription(innerConfiguration.getDescription());
        WholeMetricConfiguration innerWholeSeriesConditions = innerConfiguration.getWholeMetricConfiguration();
        if (innerWholeSeriesConditions != null) {
            MetricWholeSeriesDetectionCondition wholeSeriesConditions = new MetricWholeSeriesDetectionCondition();
            if (innerWholeSeriesConditions.getConditionOperator() != null) {
                wholeSeriesConditions.setConditionOperator(DetectionConditionOperator.fromString(innerWholeSeriesConditions.getConditionOperator().toString()));
            }
            wholeSeriesConditions.setSmartDetectionCondition(DetectionConfigurationTransforms.fromInner(innerWholeSeriesConditions.getSmartDetectionCondition())).setChangeThresholdCondition(DetectionConfigurationTransforms.fromInner(innerWholeSeriesConditions.getChangeThresholdCondition())).setHardThresholdCondition(DetectionConfigurationTransforms.fromInner(innerWholeSeriesConditions.getHardThresholdCondition()));
            configuration.setWholeSeriesDetectionCondition(wholeSeriesConditions);
        }
        if ((innerSeriesGroupConfigurationsList = innerConfiguration.getDimensionGroupOverrideConfigurations()) != null) {
            innerSeriesGroupConfigurationsList.forEach(innerSeriesGroupConfiguration -> {
                DimensionKey groupDimensionKey = innerSeriesGroupConfiguration.getGroup().getDimension() != null ? new DimensionKey(innerSeriesGroupConfiguration.getGroup().getDimension()) : new DimensionKey();
                MetricSeriesGroupDetectionCondition seriesGroupCondition = new MetricSeriesGroupDetectionCondition(groupDimensionKey);
                if (innerSeriesGroupConfiguration.getConditionOperator() != null) {
                    seriesGroupCondition.setConditionOperator(DetectionConditionOperator.fromString(innerSeriesGroupConfiguration.getConditionOperator().toString()));
                }
                seriesGroupCondition.setSmartDetectionCondition(DetectionConfigurationTransforms.fromInner(innerSeriesGroupConfiguration.getSmartDetectionCondition())).setChangeThresholdCondition(DetectionConfigurationTransforms.fromInner(innerSeriesGroupConfiguration.getChangeThresholdCondition())).setHardThresholdCondition(DetectionConfigurationTransforms.fromInner(innerSeriesGroupConfiguration.getHardThresholdCondition()));
                configuration.addSeriesGroupDetectionCondition(seriesGroupCondition);
            });
        }
        if ((innerSeriesConfigurationsList = innerConfiguration.getSeriesOverrideConfigurations()) != null) {
            innerSeriesConfigurationsList.forEach(innerSeriesConfiguration -> {
                DimensionKey groupDimensionKey = innerSeriesConfiguration.getSeries().getDimension() != null ? new DimensionKey(innerSeriesConfiguration.getSeries().getDimension()) : new DimensionKey();
                MetricSingleSeriesDetectionCondition seriesCondition = new MetricSingleSeriesDetectionCondition(groupDimensionKey);
                if (innerSeriesConfiguration.getConditionOperator() != null) {
                    seriesCondition.setConditionOperator(DetectionConditionOperator.fromString(innerSeriesConfiguration.getConditionOperator().toString()));
                }
                seriesCondition.setSmartDetectionCondition(DetectionConfigurationTransforms.fromInner(innerSeriesConfiguration.getSmartDetectionCondition())).setChangeThresholdCondition(DetectionConfigurationTransforms.fromInner(innerSeriesConfiguration.getChangeThresholdCondition())).setHardThresholdCondition(DetectionConfigurationTransforms.fromInner(innerSeriesConfiguration.getHardThresholdCondition()));
                configuration.addSingleSeriesDetectionCondition(seriesCondition);
            });
        }
        return configuration;
    }

    public static AnomalyDetectionConfiguration toInnerForCreate(ClientLogger logger, String metricId, com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration detectionConfiguration) {
        AnomalyDetectionConfiguration innerDetectionConfiguration = new AnomalyDetectionConfiguration();
        innerDetectionConfiguration.setMetricId(UUID.fromString(metricId));
        if (CoreUtils.isNullOrEmpty((CharSequence)detectionConfiguration.getName())) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("detectionConfiguration.name is required"));
        }
        innerDetectionConfiguration.setName(detectionConfiguration.getName());
        innerDetectionConfiguration.setDescription(detectionConfiguration.getDescription());
        MetricWholeSeriesDetectionCondition wholeSeriesCondition = detectionConfiguration.getWholeSeriesDetectionCondition();
        if (wholeSeriesCondition == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException("detectionConfiguration.wholeSeriesCondition is required"));
        }
        innerDetectionConfiguration.setWholeMetricConfiguration(DetectionConfigurationTransforms.setupInnerWholeSeriesConfigurationForCreate(logger, wholeSeriesCondition));
        innerDetectionConfiguration.setDimensionGroupOverrideConfigurations(detectionConfiguration.getSeriesGroupDetectionConditions().stream().map(seriesGroupCondition -> DetectionConfigurationTransforms.setupInnerSeriesGroupConfiguration(logger, true, seriesGroupCondition)).collect(Collectors.toList()));
        innerDetectionConfiguration.setSeriesOverrideConfigurations(detectionConfiguration.getSeriesDetectionConditions().stream().map(seriesGroupCondition -> DetectionConfigurationTransforms.setupInnerSeriesConfiguration(logger, true, seriesGroupCondition)).collect(Collectors.toList()));
        return innerDetectionConfiguration;
    }

    public static AnomalyDetectionConfigurationPatch toInnerForUpdate(ClientLogger logger, com.azure.ai.metricsadvisor.administration.models.AnomalyDetectionConfiguration detectionConfiguration) {
        AnomalyDetectionConfigurationPatch innerDetectionConfiguration = new AnomalyDetectionConfigurationPatch();
        innerDetectionConfiguration.setName(detectionConfiguration.getName());
        innerDetectionConfiguration.setDescription(detectionConfiguration.getDescription());
        MetricWholeSeriesDetectionCondition wholeSeriesCondition = detectionConfiguration.getWholeSeriesDetectionCondition();
        if (wholeSeriesCondition != null) {
            innerDetectionConfiguration.setWholeMetricConfiguration(DetectionConfigurationTransforms.setupInnerWholeSeriesConfigurationForUpdate(wholeSeriesCondition));
        }
        innerDetectionConfiguration.setDimensionGroupOverrideConfigurations(detectionConfiguration.getSeriesGroupDetectionConditions().stream().map(seriesGroupCondition -> DetectionConfigurationTransforms.setupInnerSeriesGroupConfiguration(logger, false, seriesGroupCondition)).collect(Collectors.toList()));
        innerDetectionConfiguration.setSeriesOverrideConfigurations(detectionConfiguration.getSeriesDetectionConditions().stream().map(seriesGroupCondition -> DetectionConfigurationTransforms.setupInnerSeriesConfiguration(logger, false, seriesGroupCondition)).collect(Collectors.toList()));
        return innerDetectionConfiguration;
    }

    private static WholeMetricConfiguration setupInnerWholeSeriesConfigurationForCreate(ClientLogger logger, MetricWholeSeriesDetectionCondition wholeSeriesCondition) {
        WholeMetricConfiguration innerWholeSeriesCondition = new WholeMetricConfiguration();
        DetectionConditionOperator crossConditionOperator = wholeSeriesCondition.getConditionOperator();
        if (crossConditionOperator != null) {
            innerWholeSeriesCondition.setConditionOperator(AnomalyDetectionConfigurationLogicType.fromString(crossConditionOperator.toString()));
        } else if (DetectionConfigurationTransforms.hasMultipleNestedConditions(wholeSeriesCondition)) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("detectionConfiguration.wholeSeriesCondition.conditionOperator is required when multiple conditions are specified for the whole series."));
        }
        innerWholeSeriesCondition.setSmartDetectionCondition(DetectionConfigurationTransforms.toInnerForCreate(wholeSeriesCondition.getSmartDetectionCondition())).setChangeThresholdCondition(DetectionConfigurationTransforms.toInnerForCreate(wholeSeriesCondition.getChangeThresholdCondition())).setHardThresholdCondition(DetectionConfigurationTransforms.toInnerForCreate(wholeSeriesCondition.getHardThresholdCondition()));
        return innerWholeSeriesCondition;
    }

    private static WholeMetricConfigurationPatch setupInnerWholeSeriesConfigurationForUpdate(MetricWholeSeriesDetectionCondition wholeSeriesCondition) {
        WholeMetricConfigurationPatch innerWholeSeriesCondition = new WholeMetricConfigurationPatch();
        DetectionConditionOperator crossConditionOperator = wholeSeriesCondition.getConditionOperator();
        if (crossConditionOperator != null) {
            innerWholeSeriesCondition.setConditionOperator(AnomalyDetectionConfigurationLogicType.fromString(crossConditionOperator.toString()));
        }
        if (wholeSeriesCondition.getSmartDetectionCondition() != null) {
            innerWholeSeriesCondition.setSmartDetectionCondition(DetectionConfigurationTransforms.toInnerForUpdate(wholeSeriesCondition.getSmartDetectionCondition()));
        }
        if (wholeSeriesCondition.getChangeThresholdCondition() != null) {
            innerWholeSeriesCondition.setChangeThresholdCondition(DetectionConfigurationTransforms.toInnerForUpdate(wholeSeriesCondition.getChangeThresholdCondition()));
        }
        if (wholeSeriesCondition.getHardThresholdCondition() != null) {
            innerWholeSeriesCondition.setHardThresholdCondition(DetectionConfigurationTransforms.toInnerForUpdate(wholeSeriesCondition.getHardThresholdCondition()));
        }
        return innerWholeSeriesCondition;
    }

    private static DimensionGroupConfiguration setupInnerSeriesGroupConfiguration(ClientLogger logger, boolean isCreate, MetricSeriesGroupDetectionCondition seriesGroupCondition) {
        DetectionConditionOperator groupConditionOperator;
        if (isCreate && seriesGroupCondition.getSeriesGroupKey() == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException("MetricSeriesGroupDetectionCondition.seriesGroupKey is required"));
        }
        DimensionGroupConfiguration innerConfiguration = new DimensionGroupConfiguration();
        if (seriesGroupCondition.getSeriesGroupKey() != null) {
            innerConfiguration.setGroup(new DimensionGroupIdentity().setDimension(seriesGroupCondition.getSeriesGroupKey().asMap()));
        }
        if ((groupConditionOperator = seriesGroupCondition.getConditionOperator()) != null) {
            innerConfiguration.setConditionOperator(AnomalyDetectionConfigurationLogicType.fromString(groupConditionOperator.toString()));
        } else if (isCreate && DetectionConfigurationTransforms.hasMultipleNestedConditions(seriesGroupCondition)) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("detectionConfiguration.seriesGroupConditions.conditionOperator is required when multiple conditions are specified for a series group."));
        }
        innerConfiguration.setSmartDetectionCondition(DetectionConfigurationTransforms.toInnerForCreate(seriesGroupCondition.getSmartDetectionCondition())).setChangeThresholdCondition(DetectionConfigurationTransforms.toInnerForCreate(seriesGroupCondition.getChangeThresholdCondition())).setHardThresholdCondition(DetectionConfigurationTransforms.toInnerForCreate(seriesGroupCondition.getHardThresholdCondition()));
        return innerConfiguration;
    }

    private static SeriesConfiguration setupInnerSeriesConfiguration(ClientLogger logger, boolean isCreate, MetricSingleSeriesDetectionCondition seriesCondition) {
        if (isCreate && seriesCondition.getSeriesKey() == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException("MetricSingleSeriesDetectionCondition.seriesKey is required"));
        }
        SeriesConfiguration innerConfiguration = new SeriesConfiguration().setSeries(new SeriesIdentity().setDimension(seriesCondition.getSeriesKey().asMap()));
        DetectionConditionOperator seriesConditionOperator = seriesCondition.getConditionOperator();
        if (seriesConditionOperator != null) {
            innerConfiguration.setConditionOperator(AnomalyDetectionConfigurationLogicType.fromString(seriesConditionOperator.toString()));
        } else if (isCreate && DetectionConfigurationTransforms.hasMultipleNestedConditions(seriesCondition)) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("detectionConfiguration.seriesConditions.conditionOperator is required when multiple conditions are specified for a series."));
        }
        innerConfiguration.setSmartDetectionCondition(DetectionConfigurationTransforms.toInnerForCreate(seriesCondition.getSmartDetectionCondition())).setChangeThresholdCondition(DetectionConfigurationTransforms.toInnerForCreate(seriesCondition.getChangeThresholdCondition())).setHardThresholdCondition(DetectionConfigurationTransforms.toInnerForCreate(seriesCondition.getHardThresholdCondition()));
        return innerConfiguration;
    }

    private static boolean hasMultipleNestedConditions(MetricWholeSeriesDetectionCondition seriesDetectionCondition) {
        Optional<Boolean> multipleConditionsOpt = Stream.of(seriesDetectionCondition.getSmartDetectionCondition() != null, seriesDetectionCondition.getChangeThresholdCondition() != null, seriesDetectionCondition.getChangeThresholdCondition() != null).filter(p -> p).skip(1L).findAny();
        return multipleConditionsOpt.isPresent();
    }

    private static boolean hasMultipleNestedConditions(MetricSeriesGroupDetectionCondition seriesDetectionCondition) {
        Optional<Boolean> multipleConditionsOpt = Stream.of(seriesDetectionCondition.getSmartDetectionCondition() != null, seriesDetectionCondition.getChangeThresholdCondition() != null, seriesDetectionCondition.getChangeThresholdCondition() != null).filter(p -> p).skip(1L).findAny();
        return multipleConditionsOpt.isPresent();
    }

    private static boolean hasMultipleNestedConditions(MetricSingleSeriesDetectionCondition seriesDetectionCondition) {
        Optional<Boolean> multipleConditionsOpt = Stream.of(seriesDetectionCondition.getSmartDetectionCondition() != null, seriesDetectionCondition.getChangeThresholdCondition() != null, seriesDetectionCondition.getChangeThresholdCondition() != null).filter(p -> p).skip(1L).findAny();
        return multipleConditionsOpt.isPresent();
    }

    private static com.azure.ai.metricsadvisor.administration.models.ChangeThresholdCondition fromInner(ChangeThresholdCondition inner) {
        if (inner == null) {
            return null;
        }
        return new com.azure.ai.metricsadvisor.administration.models.ChangeThresholdCondition(inner.getChangePercentage(), inner.getShiftPoint(), inner.isWithinRange(), inner.getAnomalyDetectorDirection(), DetectionConfigurationTransforms.fromInner(inner.getSuppressCondition()));
    }

    private static ChangeThresholdCondition toInnerForCreate(com.azure.ai.metricsadvisor.administration.models.ChangeThresholdCondition condition) {
        if (condition == null) {
            return null;
        }
        return new ChangeThresholdCondition().setAnomalyDetectorDirection(condition.getAnomalyDetectorDirection()).setChangePercentage(condition.getChangePercentage()).setShiftPoint(condition.getShiftPoint()).setWithinRange(condition.isWithinRange()).setSuppressCondition(DetectionConfigurationTransforms.toInnerForCreate(condition.getSuppressCondition()));
    }

    private static ChangeThresholdConditionPatch toInnerForUpdate(com.azure.ai.metricsadvisor.administration.models.ChangeThresholdCondition condition) {
        if (condition == null) {
            return null;
        }
        ChangeThresholdConditionPatch inner = new ChangeThresholdConditionPatch();
        inner.setAnomalyDetectorDirection(condition.getAnomalyDetectorDirection()).setChangePercentage(condition.getChangePercentage()).setShiftPoint(condition.getShiftPoint()).setWithinRange(condition.isWithinRange());
        if (condition.getSuppressCondition() != null) {
            inner.setSuppressCondition(DetectionConfigurationTransforms.toInnerForUpdate(condition.getSuppressCondition()));
        }
        return inner;
    }

    private static HardThresholdCondition fromInner(com.azure.ai.metricsadvisor.implementation.models.HardThresholdCondition inner) {
        if (inner == null) {
            return null;
        }
        return new HardThresholdCondition(inner.getAnomalyDetectorDirection(), DetectionConfigurationTransforms.fromInner(inner.getSuppressCondition())).setLowerBound(inner.getLowerBound()).setUpperBound(inner.getUpperBound());
    }

    private static com.azure.ai.metricsadvisor.implementation.models.HardThresholdCondition toInnerForCreate(HardThresholdCondition condition) {
        if (condition == null) {
            return null;
        }
        return new com.azure.ai.metricsadvisor.implementation.models.HardThresholdCondition().setAnomalyDetectorDirection(condition.getAnomalyDetectorDirection()).setSuppressCondition(DetectionConfigurationTransforms.toInnerForCreate(condition.getSuppressCondition())).setLowerBound(condition.getLowerBound()).setUpperBound(condition.getUpperBound());
    }

    private static HardThresholdConditionPatch toInnerForUpdate(HardThresholdCondition condition) {
        if (condition == null) {
            return null;
        }
        HardThresholdConditionPatch inner = new HardThresholdConditionPatch();
        inner.setAnomalyDetectorDirection(condition.getAnomalyDetectorDirection()).setLowerBound(condition.getLowerBound()).setUpperBound(condition.getUpperBound());
        if (condition.getSuppressCondition() != null) {
            inner.setSuppressCondition(DetectionConfigurationTransforms.toInnerForUpdate(condition.getSuppressCondition()));
        }
        return inner;
    }

    private static com.azure.ai.metricsadvisor.administration.models.SmartDetectionCondition fromInner(SmartDetectionCondition inner) {
        if (inner == null) {
            return null;
        }
        return new com.azure.ai.metricsadvisor.administration.models.SmartDetectionCondition(inner.getSensitivity(), inner.getAnomalyDetectorDirection(), DetectionConfigurationTransforms.fromInner(inner.getSuppressCondition()));
    }

    private static SmartDetectionCondition toInnerForCreate(com.azure.ai.metricsadvisor.administration.models.SmartDetectionCondition condition) {
        if (condition == null) {
            return null;
        }
        return new SmartDetectionCondition().setSensitivity(condition.getSensitivity()).setAnomalyDetectorDirection(condition.getAnomalyDetectorDirection()).setSuppressCondition(DetectionConfigurationTransforms.toInnerForCreate(condition.getSuppressCondition()));
    }

    private static SmartDetectionConditionPatch toInnerForUpdate(com.azure.ai.metricsadvisor.administration.models.SmartDetectionCondition condition) {
        if (condition == null) {
            return null;
        }
        SmartDetectionConditionPatch inner = new SmartDetectionConditionPatch();
        inner.setSensitivity(condition.getSensitivity()).setAnomalyDetectorDirection(condition.getAnomalyDetectorDirection());
        if (condition.getSuppressCondition() != null) {
            inner.setSuppressCondition(DetectionConfigurationTransforms.toInnerForUpdate(condition.getSuppressCondition()));
        }
        return inner;
    }

    private static com.azure.ai.metricsadvisor.administration.models.SuppressCondition fromInner(SuppressCondition inner) {
        return inner != null ? new com.azure.ai.metricsadvisor.administration.models.SuppressCondition(inner.getMinNumber(), inner.getMinRatio()) : null;
    }

    private static SuppressCondition toInnerForCreate(com.azure.ai.metricsadvisor.administration.models.SuppressCondition condition) {
        return condition != null ? new SuppressCondition().setMinNumber(condition.getMinNumber()).setMinRatio(condition.getMinRatio()) : null;
    }

    private static SuppressConditionPatch toInnerForUpdate(com.azure.ai.metricsadvisor.administration.models.SuppressCondition condition) {
        return condition != null ? new SuppressConditionPatch().setMinNumber(condition.getMinNumber()).setMinRatio(condition.getMinRatio()) : null;
    }
}

