/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.administration.models.EmailNotificationHook;
import com.azure.ai.metricsadvisor.administration.models.NotificationHook;
import com.azure.ai.metricsadvisor.administration.models.WebNotificationHook;
import com.azure.ai.metricsadvisor.implementation.models.EmailHookInfo;
import com.azure.ai.metricsadvisor.implementation.models.EmailHookInfoPatch;
import com.azure.ai.metricsadvisor.implementation.models.EmailHookParameter;
import com.azure.ai.metricsadvisor.implementation.models.EmailHookParameterPatch;
import com.azure.ai.metricsadvisor.implementation.models.HookInfo;
import com.azure.ai.metricsadvisor.implementation.models.HookInfoPatch;
import com.azure.ai.metricsadvisor.implementation.models.WebhookHookInfo;
import com.azure.ai.metricsadvisor.implementation.models.WebhookHookInfoPatch;
import com.azure.ai.metricsadvisor.implementation.models.WebhookHookParameter;
import com.azure.ai.metricsadvisor.implementation.models.WebhookHookParameterPatch;
import com.azure.ai.metricsadvisor.implementation.util.HookHelper;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.Exceptions;

public final class HookTransforms {
    private HookTransforms() {
    }

    public static HookInfo toInnerForCreate(ClientLogger logger, NotificationHook notificationHook) {
        if (notificationHook instanceof EmailNotificationHook) {
            EmailNotificationHook emailHook = (EmailNotificationHook)notificationHook;
            if (CoreUtils.isNullOrEmpty((CharSequence)emailHook.getName())) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The notificationHook.name is required."));
            }
            if (emailHook.getEmailsToAlert().isEmpty()) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("At least one email is required in the notificationHook."));
            }
            EmailHookInfo innerEmailHook = new EmailHookInfo();
            innerEmailHook.setHookName(emailHook.getName());
            innerEmailHook.setDescription(emailHook.getDescription());
            innerEmailHook.setExternalLink(emailHook.getExternalLink());
            List<String> emailsToAlert = HookHelper.getEmailsToAlertRaw(emailHook);
            if (emailsToAlert != null) {
                innerEmailHook.setHookParameter(new EmailHookParameter().setToList(emailsToAlert));
            }
            innerEmailHook.setAdmins(HookHelper.getAdminsRaw(emailHook));
            return innerEmailHook;
        }
        if (notificationHook instanceof WebNotificationHook) {
            WebNotificationHook webHook = (WebNotificationHook)notificationHook;
            if (CoreUtils.isNullOrEmpty((CharSequence)webHook.getName())) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The notificationHook.name is required."));
            }
            if (CoreUtils.isNullOrEmpty((CharSequence)webHook.getEndpoint())) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The notificationHook.endpoint is required."));
            }
            WebhookHookInfo innerWebHook = new WebhookHookInfo();
            innerWebHook.setHookName(webHook.getName());
            innerWebHook.setDescription(webHook.getDescription());
            innerWebHook.setExternalLink(webHook.getExternalLink());
            WebhookHookParameter hookParameter = new WebhookHookParameter().setEndpoint(webHook.getEndpoint()).setUsername(webHook.getUsername()).setPassword(webHook.getPassword()).setCertificateKey(webHook.getClientCertificate()).setCertificatePassword(webHook.getClientCertificatePassword());
            HttpHeaders headers = HookHelper.getHttpHeadersRaw(webHook);
            if (headers != null) {
                hookParameter.setHeaders(headers.toMap());
            }
            innerWebHook.setAdmins(HookHelper.getAdminsRaw(webHook));
            innerWebHook.setHookParameter(hookParameter);
            return innerWebHook;
        }
        throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The notificationHook type %s not supported", notificationHook.getClass().getCanonicalName())));
    }

    public static HookInfoPatch toInnerForUpdate(ClientLogger logger, NotificationHook notificationHook) {
        if (notificationHook instanceof EmailNotificationHook) {
            EmailNotificationHook emailHook = (EmailNotificationHook)notificationHook;
            EmailHookInfoPatch innerEmailHook = new EmailHookInfoPatch();
            innerEmailHook.setHookName(emailHook.getName());
            innerEmailHook.setDescription(emailHook.getDescription());
            innerEmailHook.setExternalLink(emailHook.getExternalLink());
            List<String> emailsToAlert = HookHelper.getEmailsToAlertRaw(emailHook);
            if (emailsToAlert != null) {
                innerEmailHook.setHookParameter(new EmailHookParameterPatch().setToList(emailsToAlert));
            }
            innerEmailHook.setAdmins(HookHelper.getAdminsRaw(emailHook));
            return innerEmailHook;
        }
        if (notificationHook instanceof WebNotificationHook) {
            WebNotificationHook webHook = (WebNotificationHook)notificationHook;
            WebhookHookInfoPatch innerWebHook = new WebhookHookInfoPatch();
            innerWebHook.setHookName(webHook.getName());
            innerWebHook.setDescription(webHook.getDescription());
            innerWebHook.setExternalLink(webHook.getExternalLink());
            WebhookHookParameterPatch hookParameter = new WebhookHookParameterPatch().setEndpoint(webHook.getEndpoint()).setUsername(webHook.getUsername()).setPassword(webHook.getPassword()).setCertificateKey(webHook.getClientCertificate()).setCertificatePassword(webHook.getClientCertificatePassword());
            HttpHeaders headers = HookHelper.getHttpHeadersRaw(webHook);
            if (headers != null) {
                hookParameter.setHeaders(headers.toMap());
            }
            innerWebHook.setHookParameter(hookParameter);
            innerWebHook.setAdmins(HookHelper.getAdminsRaw(webHook));
            return innerWebHook;
        }
        throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The notificationHook type %s not supported", notificationHook.getClass().getCanonicalName())));
    }

    public static NotificationHook fromInner(ClientLogger logger, HookInfo innerHook) {
        if (innerHook instanceof EmailHookInfo) {
            EmailHookInfo innerEmailHook = (EmailHookInfo)innerHook;
            EmailNotificationHook emailHook = new EmailNotificationHook(innerEmailHook.getHookName(), innerEmailHook.getHookParameter().getToList());
            emailHook.setDescription(innerEmailHook.getDescription());
            emailHook.setExternalLink(innerEmailHook.getExternalLink());
            HookHelper.setId(emailHook, innerEmailHook.getHookId().toString());
            emailHook.setAdmins(innerEmailHook.getAdmins());
            return emailHook;
        }
        if (innerHook instanceof WebhookHookInfo) {
            WebhookHookInfo innerWebHook = (WebhookHookInfo)innerHook;
            WebNotificationHook webHook = new WebNotificationHook(innerWebHook.getHookName(), innerWebHook.getHookParameter().getEndpoint());
            webHook.setDescription(innerWebHook.getDescription());
            webHook.setExternalLink(innerWebHook.getExternalLink());
            webHook.setUserCredentials(innerWebHook.getHookParameter().getUsername(), innerWebHook.getHookParameter().getPassword());
            webHook.setClientCertificate(innerWebHook.getHookParameter().getCertificateKey(), innerWebHook.getHookParameter().getCertificatePassword());
            Map<String, String> innerHeaders = innerWebHook.getHookParameter().getHeaders();
            if (innerHeaders == null) {
                innerHeaders = new HashMap<String, String>();
            }
            webHook.setHttpHeaders(new HttpHeaders(innerHeaders));
            HookHelper.setId(webHook, innerWebHook.getHookId().toString());
            webHook.setAdmins(innerWebHook.getAdmins());
            return webHook;
        }
        throw logger.logExceptionAsError(Exceptions.propagate((Throwable)new RuntimeException(String.format("The hook type %s not supported", innerHook.getClass().getCanonicalName()))));
    }

    public static PagedResponse<NotificationHook> fromInnerPagedResponse(ClientLogger logger, PagedResponse<HookInfo> innerResponse) {
        List innerHookList = innerResponse.getValue();
        List<Object> notificationHookList = innerHookList == null || innerHookList.isEmpty() ? new ArrayList() : innerHookList.stream().map(innerAnomaly -> HookTransforms.fromInner(logger, innerAnomaly)).collect(Collectors.toList());
        IterableStream pageElements = new IterableStream(notificationHookList);
        return new PagedResponseBase(innerResponse.getRequest(), innerResponse.getStatusCode(), innerResponse.getHeaders(), (Page)new HookPage(pageElements, (String)innerResponse.getContinuationToken()), null);
    }

    private static final class HookPage
    implements Page<NotificationHook> {
        private final IterableStream<NotificationHook> elements;
        private final String continuationTToken;

        private HookPage(IterableStream<NotificationHook> elements, String continuationTToken) {
            this.elements = elements;
            this.continuationTToken = continuationTToken;
        }

        public IterableStream<NotificationHook> getElements() {
            return this.elements;
        }

        public String getContinuationToken() {
            return this.continuationTToken;
        }
    }
}

