/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.implementation.models.SeriesResult;
import com.azure.ai.metricsadvisor.implementation.models.SeriesResultList;
import com.azure.ai.metricsadvisor.implementation.util.MetricEnrichedSeriesDataHelper;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import com.azure.ai.metricsadvisor.models.MetricEnrichedSeriesData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

public class MetricEnrichedSeriesDataTransformations {
    public static List<MetricEnrichedSeriesData> fromInnerList(SeriesResultList innerEnrichedSeriesDataList) {
        ArrayList<MetricEnrichedSeriesData> enrichedSeriesDataList = new ArrayList<MetricEnrichedSeriesData>();
        if (innerEnrichedSeriesDataList != null && !innerEnrichedSeriesDataList.getValue().isEmpty()) {
            for (SeriesResult innerEnrichedSeriesData : innerEnrichedSeriesDataList.getValue()) {
                enrichedSeriesDataList.add(MetricEnrichedSeriesDataTransformations.fromInner(innerEnrichedSeriesData));
            }
        }
        return enrichedSeriesDataList;
    }

    private static MetricEnrichedSeriesData fromInner(SeriesResult innerEnrichedSeriesData) {
        MetricEnrichedSeriesData enrichedSeriesData = new MetricEnrichedSeriesData();
        DimensionKey seriesKey = innerEnrichedSeriesData.getSeries().getDimension() != null ? new DimensionKey(innerEnrichedSeriesData.getSeries().getDimension()) : new DimensionKey();
        MetricEnrichedSeriesDataHelper.setSeriesKey(enrichedSeriesData, seriesKey);
        List<OffsetDateTime> timestampList = innerEnrichedSeriesData.getTimestampList();
        if (timestampList == null) {
            timestampList = new ArrayList<OffsetDateTime>();
        }
        MetricEnrichedSeriesDataHelper.setTimestamps(enrichedSeriesData, timestampList);
        List<Double> valueList = innerEnrichedSeriesData.getValueList();
        if (valueList == null) {
            valueList = new ArrayList<Double>();
        }
        MetricEnrichedSeriesDataHelper.setMetricValues(enrichedSeriesData, valueList);
        List<Boolean> isAnomalyList = innerEnrichedSeriesData.getIsAnomalyList();
        if (isAnomalyList == null) {
            isAnomalyList = new ArrayList<Boolean>();
        }
        MetricEnrichedSeriesDataHelper.setIsAnomalyList(enrichedSeriesData, isAnomalyList);
        List<Integer> periodList = innerEnrichedSeriesData.getPeriodList();
        if (periodList == null) {
            periodList = new ArrayList<Integer>();
        }
        MetricEnrichedSeriesDataHelper.setPeriods(enrichedSeriesData, periodList);
        List<Double> expectedValueList = innerEnrichedSeriesData.getExpectedValueList();
        if (expectedValueList == null) {
            expectedValueList = new ArrayList<Double>();
        }
        MetricEnrichedSeriesDataHelper.setExpectedMetricValues(enrichedSeriesData, expectedValueList);
        List<Double> lowerBoundList = innerEnrichedSeriesData.getLowerBoundaryList();
        if (lowerBoundList == null) {
            lowerBoundList = new ArrayList<Double>();
        }
        MetricEnrichedSeriesDataHelper.setLowerBoundaryValues(enrichedSeriesData, lowerBoundList);
        List<Double> upperBoundList = innerEnrichedSeriesData.getUpperBoundaryList();
        if (upperBoundList == null) {
            upperBoundList = new ArrayList<Double>();
        }
        MetricEnrichedSeriesDataHelper.setUpperBoundaryValues(enrichedSeriesData, upperBoundList);
        return enrichedSeriesData;
    }
}

