/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.implementation.models.AnomalyFeedback;
import com.azure.ai.metricsadvisor.implementation.models.ChangePointFeedback;
import com.azure.ai.metricsadvisor.implementation.models.CommentFeedback;
import com.azure.ai.metricsadvisor.implementation.models.FeedbackDimensionFilter;
import com.azure.ai.metricsadvisor.implementation.models.FeedbackQueryTimeMode;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedbackFilter;
import com.azure.ai.metricsadvisor.implementation.models.PeriodFeedback;
import com.azure.ai.metricsadvisor.implementation.util.DetectionConfigurationTransforms;
import com.azure.ai.metricsadvisor.implementation.util.MetricAnomalyFeedbackHelper;
import com.azure.ai.metricsadvisor.implementation.util.MetricFeedbackHelper;
import com.azure.ai.metricsadvisor.models.AnomalyValue;
import com.azure.ai.metricsadvisor.models.ChangePointValue;
import com.azure.ai.metricsadvisor.models.DimensionKey;
import com.azure.ai.metricsadvisor.models.FeedbackType;
import com.azure.ai.metricsadvisor.models.ListMetricFeedbackFilter;
import com.azure.ai.metricsadvisor.models.ListMetricFeedbackOptions;
import com.azure.ai.metricsadvisor.models.MetricAnomalyFeedback;
import com.azure.ai.metricsadvisor.models.MetricChangePointFeedback;
import com.azure.ai.metricsadvisor.models.MetricCommentFeedback;
import com.azure.ai.metricsadvisor.models.MetricFeedback;
import com.azure.ai.metricsadvisor.models.MetricPeriodFeedback;
import com.azure.ai.metricsadvisor.models.PeriodType;
import com.azure.core.util.logging.ClientLogger;
import java.util.UUID;

public final class MetricFeedbackTransforms {
    private static final ClientLogger LOGGER = new ClientLogger(MetricFeedbackTransforms.class);

    private MetricFeedbackTransforms() {
    }

    public static MetricFeedback fromInner(com.azure.ai.metricsadvisor.implementation.models.MetricFeedback metricFeedbackValue) {
        MetricFeedback metricFeedback;
        if (metricFeedbackValue instanceof AnomalyFeedback) {
            AnomalyFeedback anomalyFeedback = (AnomalyFeedback)metricFeedbackValue;
            metricFeedback = new MetricAnomalyFeedback(anomalyFeedback.getStartTime(), anomalyFeedback.getEndTime(), AnomalyValue.fromString(anomalyFeedback.getValue().getAnomalyValue().toString())).setDetectionConfigurationId(anomalyFeedback.getAnomalyDetectionConfigurationId() != null ? anomalyFeedback.getAnomalyDetectionConfigurationId().toString() : null);
            if (anomalyFeedback.getAnomalyDetectionConfigurationSnapshot() != null) {
                MetricAnomalyFeedbackHelper.setDetectionConfiguration((MetricAnomalyFeedback)metricFeedback, DetectionConfigurationTransforms.fromInner(anomalyFeedback.getAnomalyDetectionConfigurationSnapshot()));
            }
            MetricFeedbackHelper.setFeedbackType(metricFeedback, FeedbackType.ANOMALY);
        } else if (metricFeedbackValue instanceof ChangePointFeedback) {
            ChangePointFeedback changePointFeedback = (ChangePointFeedback)metricFeedbackValue;
            metricFeedback = new MetricChangePointFeedback(changePointFeedback.getStartTime(), changePointFeedback.getEndTime(), ChangePointValue.fromString(changePointFeedback.getValue().getChangePointValue().toString()));
            MetricFeedbackHelper.setFeedbackType(metricFeedback, FeedbackType.CHANGE_POINT);
        } else if (metricFeedbackValue instanceof PeriodFeedback) {
            PeriodFeedback periodFeedback = (PeriodFeedback)metricFeedbackValue;
            metricFeedback = new MetricPeriodFeedback(PeriodType.fromString(periodFeedback.getValue().getPeriodType().toString()), periodFeedback.getValue().getPeriodValue());
            MetricFeedbackHelper.setFeedbackType(metricFeedback, FeedbackType.PERIOD);
        } else if (metricFeedbackValue instanceof CommentFeedback) {
            CommentFeedback commentFeedback = (CommentFeedback)metricFeedbackValue;
            metricFeedback = new MetricCommentFeedback(commentFeedback.getStartTime(), commentFeedback.getEndTime(), commentFeedback.getValue().getCommentValue());
            MetricFeedbackHelper.setFeedbackType(metricFeedback, FeedbackType.COMMENT);
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown feedback type."));
        }
        MetricFeedbackHelper.setId(metricFeedback, metricFeedbackValue.getFeedbackId().toString());
        MetricFeedbackHelper.setMetricId(metricFeedback, metricFeedbackValue.getMetricId().toString());
        MetricFeedbackHelper.setCreatedTime(metricFeedback, metricFeedbackValue.getCreatedTime());
        MetricFeedbackHelper.setUserPrincipal(metricFeedback, metricFeedbackValue.getUserPrincipal());
        metricFeedback.setDimensionFilter(new DimensionKey(metricFeedbackValue.getDimensionFilter().getDimension()));
        return metricFeedback;
    }

    public static MetricFeedbackFilter toInnerFilter(String metricId, ListMetricFeedbackOptions options) {
        ListMetricFeedbackFilter listMetricFeedbackFilter = options.getFilter() == null ? new ListMetricFeedbackFilter() : options.getFilter();
        MetricFeedbackFilter metricFeedbackFilter = new MetricFeedbackFilter().setFeedbackType(listMetricFeedbackFilter.getFeedbackType()).setMetricId(UUID.fromString(metricId)).setStartTime(listMetricFeedbackFilter.getStartTime()).setEndTime(listMetricFeedbackFilter.getEndTime()).setTimeMode(listMetricFeedbackFilter.getTimeMode() == null ? null : FeedbackQueryTimeMode.fromString(listMetricFeedbackFilter.getTimeMode().toString()));
        if (listMetricFeedbackFilter.getDimensionFilter() != null) {
            metricFeedbackFilter.setDimensionFilter(new FeedbackDimensionFilter().setDimension(listMetricFeedbackFilter.getDimensionFilter().asMap()));
        }
        return metricFeedbackFilter;
    }
}

